/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptLanguageServiceCacheImpl
extends JSLanguageServiceDefaultCacheData {
    private final Map<VirtualFile, LastUpdateInfo> myUpdateFiles = ContainerUtil.newConcurrentMap();
    private final Set<VirtualFile> myOpenedFilesByEvent = ContainerUtil.newConcurrentSet();

    @Override
    @Nullable
    public final JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(0);
        }
        if (input instanceof TypeScriptLanguageServiceUpdateCommand) {
            return this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)input);
        }
        if (input instanceof TypeScriptCompositeCommand) {
            JSLanguageServiceCommand[] commands = ((TypeScriptCompositeCommand)input).getNestedCommands();
            ArrayList results = ContainerUtil.newArrayListWithCapacity((int)commands.length);
            for (JSLanguageServiceCommand command : commands) {
                JSLanguageServiceObject serviceObject = this.updateCacheAndGetServiceObject(command);
                if (serviceObject == null) continue;
                if (serviceObject instanceof TypeScriptCommandSetRequest) {
                    ((TypeScriptCommandSetRequest)serviceObject).nestedRequests.forEach((nestedServiceObject, nestedCommand) -> {
                        JSLanguageServiceRequest request = new JSLanguageServiceRequest((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedServiceObject, -1L, -1);
                        results.add(request);
                    });
                    continue;
                }
                JSLanguageServiceRequest request = new JSLanguageServiceRequest(command, serviceObject, -1L, -1);
                results.add(request);
            }
            if (results.size() == 0) {
                return null;
            }
            return new TypeScriptCompositeRequest(results);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            VirtualFile file;
            TypeScriptCommandWithArguments command;
            if (input instanceof TypeScriptOpenEditorCommand) {
                command = (TypeScriptOpenEditorCommand)input;
                VirtualFile file2 = ((TypeScriptOpenEditorCommand)command).getFile();
                this.myOpenedFilesByEvent.add(file2);
                if (this.myUpdateFiles.containsKey(file2)) {
                    return null;
                }
                this.myUpdateFiles.put(file2, new LastUpdateInfo(((TypeScriptOpenEditorCommand)command).getTimestamp(), ((TypeScriptOpenEditorCommand)command).getContentLength(), ((TypeScriptOpenEditorCommand)command).getLineCount(), ((TypeScriptOpenEditorCommand)command).getLastLineStartOffset()));
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                command = (TypeScriptCloseEditorCommand)input;
                VirtualFile virtualFile = ((TypeScriptCloseEditorCommand)command).getFile();
                this.myOpenedFilesByEvent.remove(virtualFile);
                if (this.myUpdateFiles.remove(virtualFile) == null) {
                    return null;
                }
            }
            if (input instanceof TypeScriptReloadFileCommand && (this.myOpenedFilesByEvent.contains(file = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file))) {
                return null;
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    @Nullable
    private JSLanguageServiceObject getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateCommand command) {
        if (command == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(1);
        }
        Map<VirtualFile, Long> currentChangedFiles = command.myChangedFilesToTimeStamp;
        Map<VirtualFile, Document> unsavedContents = command.myUnsavedFilesContent;
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentChangedFiles);
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = ContainerUtil.newHashMap();
        List toOpen = filesToOpen.stream().filter(el -> unsavedContents.containsKey(el)).map(el -> {
            Document document = (Document)unsavedContents.get(el);
            Long timestampObject = (Long)currentChangedFiles.get(el);
            String text = document.getText();
            int count = document.getLineCount();
            int contentLength = document.getTextLength();
            long timestamp = timestampObject == null ? -1L : timestampObject;
            int offset = count == 0 ? 0 : document.getLineStartOffset(count - 1);
            toUpdateCache.put(el, new LastUpdateInfo(timestamp, contentLength, count, offset));
            return new TypeScriptOpenEditorCommand((VirtualFile)el, timestamp, contentLength, count, offset, text);
        }).collect(Collectors.toList());
        List toChange = changedFiles.stream().map(el -> {
            LastUpdateInfo info = this.myUpdateFiles.get(el);
            Document document = (Document)unsavedContents.get(el);
            String text = document.getText();
            int newLineCount = document.getLineCount();
            int newOffset = newLineCount == 0 ? 0 : document.getLineStartOffset(newLineCount - 1);
            Long newTimestamp = (Long)currentChangedFiles.get(el);
            int newContentLength = text.length();
            toUpdateCache.put(el, new LastUpdateInfo(newTimestamp, newContentLength, newLineCount, newOffset));
            TypeScriptChangeRequestArgs req = TypeScriptChangeRequestArgs.build(el, text, info.myContentLength, info.myLineCount, info.myLastLineStartOffset);
            return new TypeScriptChangeCommand(req);
        }).collect(Collectors.toList());
        Collection toClose = filesToClose.stream().map(el -> {
            TypeScriptFileObject object = new TypeScriptFileObject();
            object.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(el);
            return new TypeScriptCloseEditorCommand(object, (VirtualFile)el);
        }).collect(Collectors.toList());
        filesToClose.forEach(el -> this.myUpdateFiles.remove(el));
        this.myUpdateFiles.putAll(toUpdateCache);
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty()) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        result.addAll(toOpen);
        result.addAll(toChange);
        result.addAll(toClose);
        return new TypeScriptCommandSetRequest(result);
    }

    private Collection<VirtualFile> getFilesToOpen(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(2);
        }
        return currentChangedFiles.keySet().stream().filter(el -> !this.myUpdateFiles.containsKey(el)).collect(Collectors.toList());
    }

    private Collection<VirtualFile> getFilesToChange(@NotNull Map<VirtualFile, Long> currentChangedFiles, @NotNull Collection<VirtualFile> filesToOpen) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(3);
        }
        if (filesToOpen == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(4);
        }
        ArrayList realChangedFiles = ContainerUtil.newArrayList();
        currentChangedFiles.forEach((file, modified) -> {
            if (filesToOpen == null) {
                TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(7);
            }
            if (filesToOpen.contains(file)) {
                return;
            }
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.LOGGER.error("Incorrect cache");
                return;
            }
            long timeStamp = lastUpdateInfo.myTimestamp;
            if (modified < 0L || timeStamp == -1L || modified != timeStamp) {
                realChangedFiles.add(file);
            }
        });
        return realChangedFiles;
    }

    @NotNull
    private Set<VirtualFile> getFilesToClose(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(5);
        }
        HashSet toClose = ContainerUtil.newHashSet();
        for (VirtualFile file : this.myUpdateFiles.keySet()) {
            if (currentChangedFiles.containsKey(file) || this.myOpenedFilesByEvent.contains(file)) continue;
            toClose.add(file);
        }
        HashSet hashSet = toClose;
        if (hashSet == null) {
            TypeScriptLanguageServiceCacheImpl.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        this.clear();
        this.myOpenedFilesByEvent.clear();
        this.myUpdateFiles.clear();
    }

    @Override
    public void clear() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentChangedFiles";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpen";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCacheAndGetServiceObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesServiceObject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToOpen";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToChange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToClose";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFilesToChange$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LastUpdateInfo {
        private final long myTimestamp;
        private final long myContentLength;
        private final int myLineCount;
        private final int myLastLineStartOffset;

        public LastUpdateInfo(long timestamp, long contentLength, int lineCount, int lastLineStartOffset) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
        }
    }
}

