/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.process.RunnerMediator;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicConsoleProcessRunner {
    private OSProcessHandler myProcessHandler;
    private volatile State myState = State.STARTING;
    private final LanguageConsoleView myConsoleView;
    private Executor myExecutor;
    private RunContentDescriptor myCurrentContentDescriptor;

    public abstract String getHistoryId();

    public abstract String getHistoryPersistenceId();

    public BasicConsoleProcessRunner(LanguageConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public boolean runProcess(@NotNull String command) throws ExecutionException {
        if (command == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(0);
        }
        this.myState = State.EXECUTING;
        this.myProcessHandler = this.createProcessHandler(this.createCommandLine(command));
        ProcessTerminatedListener.attach((ProcessHandler)this.myProcessHandler);
        this.getConsoleView().attachToProcess((ProcessHandler)this.myProcessHandler);
        RunContentDescriptor contentDescriptor = this.getContentDescriptor();
        contentDescriptor.setProcessHandler((ProcessHandler)this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                BasicConsoleProcessRunner.this.myState = State.READY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/play/console/BasicConsoleProcessRunner$1", "processTerminated"));
            }
        });
        ExecutionManager.getInstance((Project)this.getConsoleView().getProject()).getContentManager().showRunContent(this.getExecutor(), contentDescriptor);
        this.myProcessHandler.startNotify();
        return true;
    }

    protected RunContentDescriptor createContentDescriptor() {
        return new RunContentDescriptor((ExecutionConsole)this.getConsoleView(), (ProcessHandler)this.myProcessHandler, this.getConsoleComponent(), this.getConsoleView().getTitle()){

            public boolean isContentReuseProhibited() {
                return true;
            }
        };
    }

    protected JComponent getConsoleComponent() {
        return this.getConsoleView().getComponent();
    }

    @NotNull
    protected Executor createExecutor() {
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (executor == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(1);
        }
        return executor;
    }

    @NotNull
    protected abstract GeneralCommandLine createCommandLine(@NotNull String var1);

    public LanguageConsoleView getConsoleView() {
        return this.myConsoleView;
    }

    @NotNull
    protected Process createProcess(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(2);
        }
        ProcessHandler process = RunnerMediator.getInstance().createProcess(commandLine);
        Process process2 = ((OSProcessHandler)process).getProcess();
        if (process2 == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(3);
        }
        return process2;
    }

    protected OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(4);
        }
        return new RunnerMediator.CustomDestroyProcessHandler(this.createProcess(commandLine), commandLine);
    }

    public Executor getExecutor() {
        if (this.myExecutor == null) {
            this.myExecutor = this.createExecutor();
        }
        return this.myExecutor;
    }

    @NotNull
    public RunContentDescriptor getContentDescriptor() {
        if (this.myCurrentContentDescriptor == null) {
            this.myCurrentContentDescriptor = this.createContentDescriptor();
        }
        RunContentDescriptor runContentDescriptor = this.myCurrentContentDescriptor;
        if (runContentDescriptor == null) {
            BasicConsoleProcessRunner.$$$reportNull$$$0(5);
        }
        return runContentDescriptor;
    }

    public State getState() {
        return this.myState;
    }

    public boolean isReady() {
        return this.getState() != State.EXECUTING;
    }

    public OSProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/play/console/BasicConsoleProcessRunner";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/play/console/BasicConsoleProcessRunner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runProcess";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum State {
        STARTING,
        READY,
        COMPLETING,
        GETTING_DOCUMENTATION,
        EXECUTING;

    }
}

