/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;

public class VarargValueArgument
implements ResolvedValueArgument {
    private final List<ValueArgument> arguments = Lists.newArrayList();

    public void addArgument(@NotNull ValueArgument argument) {
        this.arguments.add(argument);
    }

    @Override
    @NotNull
    public List<ValueArgument> getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("vararg:{");
        Iterator<ValueArgument> iterator2 = this.arguments.iterator();
        while (iterator2.hasNext()) {
            ValueArgument valueArgument = iterator2.next();
            KtExpression expression2 = valueArgument.getArgumentExpression();
            builder.append(expression2 == null ? "no expression" : expression2.getText());
            if (!iterator2.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

