/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.MetaModelImpl;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.operations.exasol.ExaDdlOperationsBuilder;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExasolDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final MetaModel META_MODEL = MetaModelImpl.builder().put(ObjectKind.ROOT, ObjectKind.DATABASE).put(ObjectKind.ROOT, ObjectKind.USER).put(ObjectKind.ROOT, ObjectKind.ROLE).put(ObjectKind.ROOT, ObjectKind.CONNECTION).put(ObjectKind.DATABASE, ObjectKind.SCHEMA).put(ObjectKind.SCHEMA, ObjectKind.TABLE).put(ObjectKind.SCHEMA, ObjectKind.VIEW).put(ObjectKind.SCHEMA, ObjectKind.ROUTINE).put(ObjectKind.SCHEMA, ObjectKind.SCRIPT).put(ObjectKind.TABLE, ObjectKind.COLUMN).put(ObjectKind.TABLE, ObjectKind.KEY).put(ObjectKind.TABLE, ObjectKind.FOREIGN_KEY).put(ObjectKind.VIEW, ObjectKind.COLUMN).put(ObjectKind.ROUTINE, ObjectKind.ARGUMENT).put(ObjectKind.SCRIPT, ObjectKind.ARGUMENT).build();
    public static final ExasolDialect INSTANCE = new ExasolDialect();

    protected ExasolDialect() {
        super(META_MODEL, new TypeHelper.ExasolTypeHelper(), new KeywordHelper.ExasolKeywords(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.EXASOL;
        if (databaseFamilyId == null) {
            ExasolDialect.$$$reportNull$$$0(0);
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.Exasol;
        if (icon == null) {
            ExasolDialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Exasol" == null) {
            ExasolDialect.$$$reportNull$$$0(2);
        }
        return "Exasol";
    }

    @Override
    public boolean supportsTableDefinition() {
        return false;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DatabaseSystem system, @NotNull DatabaseConnection connection) throws SQLException {
        String s;
        if (system == null) {
            ExasolDialect.$$$reportNull$$$0(3);
        }
        if (connection == null) {
            ExasolDialect.$$$reportNull$$$0(4);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection, this, "select current_schema", 1, DbImplUtil.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)new ObjectPath(ObjectKind.SCHEMA, Arrays.asList("EXA_DB", s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            ExasolDialect.$$$reportNull$$$0(5);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("open schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(6);
        }
        if (column == null) {
            ExasolDialect.$$$reportNull$$$0(7);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(8);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsDropColumn() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(9);
        }
        if (column == null) {
            ExasolDialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnDropSQL(builder, column, "DROP COLUMN", false, "");
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(12);
        }
        if (table == null) {
            ExasolDialect.$$$reportNull$$$0(13);
        }
        if (model == null) {
            ExasolDialect.$$$reportNull$$$0(14);
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, true, "", isMaterializedView);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(15);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(16);
        }
        if (pk == null) {
            ExasolDialect.$$$reportNull$$$0(17);
        }
        builder.keyword("ALTER TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(18);
        }
        return ddlBuilder;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(19);
        }
        if (from == null) {
            ExasolDialect.$$$reportNull$$$0(20);
        }
        if (toName == null) {
            ExasolDialect.$$$reportNull$$$0(21);
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)from.getTable()).space();
        builder.keywords("RENAME", "COLUMN").space();
        builder.columnRef((DasObject)from).space();
        builder.keyword("TO").space();
        builder.newName(toName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(22);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to) throws UnsupportedOperationException {
        boolean modifyDefault;
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(23);
        }
        if (from == null) {
            ExasolDialect.$$$reportNull$$$0(24);
        }
        if (to == null) {
            ExasolDialect.$$$reportNull$$$0(25);
        }
        boolean modifyType = !this.isSameType(from, to);
        boolean modifyNullability = !ExasolDialect.isSameNullability(from, to);
        boolean bl = modifyDefault = !ExasolDialect.isSameDefault(from, to);
        if (modifyDefault || modifyNullability || modifyType) {
            DialectUtils.getColumnDefaultAlterSQL(builder, to, "MODIFY", modifyType, "DEFAULT");
            if (modifyNullability) {
                DialectUtils.addNullabilityClause(builder, to, true);
            }
        }
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateTable(@NotNull DdlBuilder builder, @NotNull List<? extends DasTable> tables, boolean constraintsAtEnd, @Nullable Set<? extends DasForeignKey> ignoreFks) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(27);
        }
        if (tables == null) {
            ExasolDialect.$$$reportNull$$$0(28);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateTableSQL(builder, tables, constraintsAtEnd, this, ignoreFks);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(29);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSchema(@NotNull DdlBuilder builder, @NotNull DasNamespace schema) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(30);
        }
        if (schema == null) {
            ExasolDialect.$$$reportNull$$$0(31);
        }
        DdlBuilder ddlBuilder = builder.keywords("CREATE", "SCHEMA").space().qualifiedRef((DasObject)schema);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(32);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(33);
        }
        if (from == null) {
            ExasolDialect.$$$reportNull$$$0(34);
        }
        if (to == null) {
            ExasolDialect.$$$reportNull$$$0(35);
        }
        int before = builder.getStatements().size();
        if (!ExasolDialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && ExasolDialect.isSameDefault(from, to) && ExasolDialect.isSameNullability(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, from, to).newStatement();
        }
        if (!ExasolDialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!ExasolDialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(36);
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return null;
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(37);
        }
        if (column == null) {
            ExasolDialect.$$$reportNull$$$0(38);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(39);
        }
        if (column == null) {
            ExasolDialect.$$$reportNull$$$0(40);
        }
        if (attrs == null) {
            ExasolDialect.$$$reportNull$$$0(41);
        }
        builder.suppressQuoteConstraints(true);
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            builder.newStatement();
            DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull(), DbSqlUtil.getSqlDialect(this));
        }
        DdlBuilder ddlBuilder = builder.suppressQuoteConstraints(false);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(42);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(43);
        }
        if (keyInfo == null) {
            ExasolDialect.$$$reportNull$$$0(44);
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(45);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(46);
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, null, false, DasForeignKey.RuleAction.NO_ACTION, DasForeignKey.RuleAction.NO_ACTION);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(47);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    protected DdlOperations getDdlOperations() {
        DdlOperations ddlOperations = new ExaDdlOperationsBuilder(this).build();
        if (ddlOperations == null) {
            ExasolDialect.$$$reportNull$$$0(48);
        }
        return ddlOperations;
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class), DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class));
        if (foreignKeyEditorCaps == null) {
            ExasolDialect.$$$reportNull$$$0(49);
        }
        return foreignKeyEditorCaps;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(50);
        }
        if (view == null) {
            ExasolDialect.$$$reportNull$$$0(51);
        }
        if (definition == null) {
            ExasolDialect.$$$reportNull$$$0(52);
        }
        if (checkOption == null) {
            ExasolDialect.$$$reportNull$$$0(53);
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewSQL(builder, view, definition, checkOption, this);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(54);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(55);
        }
        if (table == null) {
            ExasolDialect.$$$reportNull$$$0(56);
        }
        if (constraintName == null) {
            ExasolDialect.$$$reportNull$$$0(57);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(58);
        }
        if (view == null) {
            ExasolDialect.$$$reportNull$$$0(59);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropViewSQL(builder, view, null);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(60);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(61);
        }
        if (table == null) {
            ExasolDialect.$$$reportNull$$$0(62);
        }
        if (newName == null) {
            ExasolDialect.$$$reportNull$$$0(63);
        }
        DdlBuilder ddlBuilder = builder.keywords("RENAME", "TABLE").space().identifier(table.getName()).space().keyword("TO").space().newName(newName);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(64);
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(65);
        }
        if (view == null) {
            ExasolDialect.$$$reportNull$$$0(66);
        }
        if (newName == null) {
            ExasolDialect.$$$reportNull$$$0(67);
        }
        DdlBuilder ddlBuilder = builder.keywords("RENAME", "VIEW").space().identifier(view.getName()).space().keyword("TO").space().newName(newName);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(68);
        }
        return ddlBuilder;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return false;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return false;
    }

    public boolean supportsIndexes() {
        return false;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return true;
    }

    public boolean supportsSequence() {
        return false;
    }

    public boolean supportsSequenceInformation() {
        return false;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(69);
        }
        if (index == null) {
            ExasolDialect.$$$reportNull$$$0(70);
        }
        if (accessMethod == null) {
            ExasolDialect.$$$reportNull$$$0(71);
        }
        if (tablespace == null) {
            ExasolDialect.$$$reportNull$$$0(72);
        }
        if (constraints == null) {
            ExasolDialect.$$$reportNull$$$0(73);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(74);
        }
        if (table == null) {
            ExasolDialect.$$$reportNull$$$0(75);
        }
        if (indexName == null) {
            ExasolDialect.$$$reportNull$$$0(76);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(77);
        }
        if (sequence == null) {
            ExasolDialect.$$$reportNull$$$0(78);
        }
        if (increment == null) {
            ExasolDialect.$$$reportNull$$$0(79);
        }
        if (minimum == null) {
            ExasolDialect.$$$reportNull$$$0(80);
        }
        if (maximum == null) {
            ExasolDialect.$$$reportNull$$$0(81);
        }
        if (start == null) {
            ExasolDialect.$$$reportNull$$$0(82);
        }
        if (cache == null) {
            ExasolDialect.$$$reportNull$$$0(83);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(84);
        }
        if (sequence == null) {
            ExasolDialect.$$$reportNull$$$0(85);
        }
        if (increment == null) {
            ExasolDialect.$$$reportNull$$$0(86);
        }
        if (minimum == null) {
            ExasolDialect.$$$reportNull$$$0(87);
        }
        if (maximum == null) {
            ExasolDialect.$$$reportNull$$$0(88);
        }
        if (restart == null) {
            ExasolDialect.$$$reportNull$$$0(89);
        }
        if (cache == null) {
            ExasolDialect.$$$reportNull$$$0(90);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(91);
        }
        if (sequence == null) {
            ExasolDialect.$$$reportNull$$$0(92);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(93);
        }
        if (sequence == null) {
            ExasolDialect.$$$reportNull$$$0(94);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constriant, @NotNull String constraintName, @NotNull List<DasColumn> columns2) {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(95);
        }
        if (table == null) {
            ExasolDialect.$$$reportNull$$$0(96);
        }
        if (constraintName == null) {
            ExasolDialect.$$$reportNull$$$0(97);
        }
        if (columns2 == null) {
            ExasolDialect.$$$reportNull$$$0(98);
        }
        throw new UnsupportedOperationException("Unsupported");
    }

    public boolean supportsAccessMethods() {
        return false;
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            ExasolDialect.$$$reportNull$$$0(99);
        }
        return databaseProductName != null && databaseProductName.toLowerCase(Locale.ENGLISH).contains("exasol");
    }

    public boolean supportsCreateIndex() {
        return false;
    }

    public boolean supportsDropIndex() {
        return false;
    }

    public boolean supportsCreateSequence() {
        return false;
    }

    public boolean supportsAlterSequence() {
        return false;
    }

    public boolean supportsDropSequence() {
        return false;
    }

    public boolean supportsAddUniqueConstraint() {
        return false;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            ExasolDialect.$$$reportNull$$$0(100);
        }
        String name = element.getName();
        String schema = DasUtil.getSchema((DasObject)element);
        return Pair.create((Object)("SELECT VIEW_TEXT FROM SYS.EXA_USER_VIEWS WHERE VIEW_SCHEMA = '" + schema.replace("'", "''") + "' AND VIEW_NAME = '" + name.replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            ExasolDialect.$$$reportNull$$$0(101);
        }
        String name = element.getName();
        String schema = DasUtil.getSchema((DasObject)element);
        Pair pair = Pair.create((Object)("SELECT FUNCTION_TEXT FROM SYS.EXA_USER_FUNCTIONS WHERE FUNCTION_SCHEMA = '" + schema.replace("'", "''") + "' AND FUNCTION_NAME = '" + name.replace("'", "''") + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            ExasolDialect.$$$reportNull$$$0(102);
        }
        return pair;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            ExasolDialect.$$$reportNull$$$0(103);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            ExasolDialect.$$$reportNull$$$0(104);
        }
        if (qualifier == null) {
            ExasolDialect.$$$reportNull$$$0(105);
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            ExasolDialect.$$$reportNull$$$0(106);
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            ExasolDialect.$$$reportNull$$$0(107);
        }
        if (statement == null) {
            ExasolDialect.$$$reportNull$$$0(108);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/ExasolDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 39: 
            case 43: 
            case 46: 
            case 50: 
            case 55: 
            case 58: 
            case 61: 
            case 65: 
            case 69: 
            case 74: 
            case 77: 
            case 84: 
            case 91: 
            case 93: 
            case 95: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: 
            case 10: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 13: 
            case 56: 
            case 62: 
            case 75: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pk";
                break;
            }
            case 20: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tables";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyInfo";
                break;
            }
            case 51: 
            case 59: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOption";
                break;
            }
            case 57: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraintName";
                break;
            }
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessMethod";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tablespace";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraints";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 78: 
            case 85: 
            case 92: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 79: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "increment";
                break;
            }
            case 80: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minimum";
                break;
            }
            case 81: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maximum";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 83: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restart";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseProductVersion";
                break;
            }
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 103: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/ExasolDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnComment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropColumn";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropTable";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddPrimaryKey";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateTable";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateSchema";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAlterColumnDefinition";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddColumn";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlAddForeignKey";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDefineForeignKey";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDdlOperations";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getForeignKeyEditorCaps";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCreateView";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropView";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameTable";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRenameView";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropColumn";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropTable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddPrimaryKey";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnTypeNullabilityDefault";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateTable";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSchema";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterColumnDefinition";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumnAutoIncrement";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddColumn";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddForeignKey";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "sqlDefineForeignKey";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateView";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropConstraint";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropView";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameTable";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "sqlRenameView";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateIndex";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropIndex";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "sqlCreateSequence";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "sqlAlterSequence";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "sqlSequenceInformation";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 95: 
            case 96: 
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "sqlAddUniqueConstraint";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "supportsProduct";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 65: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 108: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

