/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.Binding;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

public class ExtensionScriptsUtil {
    private ExtensionScriptsUtil() {
    }

    @Nullable
    public static IdeScriptEngine getEngineFor(@Nullable Project project, @NotNull File file) {
        if (file == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(0);
        }
        String scriptExtension = FileUtilRt.getExtension((String)file.getName());
        IdeaPluginDescriptor descriptor = (IdeaPluginDescriptor)ObjectUtils.notNull((Object)PluginManager.getPlugin((PluginId)DatabasePluginId.get()));
        IdeScriptEngine engine = IdeScriptEngineManager.getInstance().getEngineForFileExtension(scriptExtension, descriptor.getPluginClassLoader());
        if (engine == null) {
            String title = "No script engine found for file extension '" + scriptExtension + "'";
            String content = "Please, make sure your script engine jar(s) and language runtime are in the IDE classpath.";
            ExtensionScriptsUtil.showError(project, title, content);
        }
        return engine;
    }

    @NotNull
    public static Binder setBindings(@NotNull IdeScriptEngine engine) {
        if (engine == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(1);
        }
        Binder binder = new Binder(engine);
        if (binder == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(2);
        }
        return binder;
    }

    public static void prepareScript(@NotNull File script) {
        if (script == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FileDocumentManager.getInstance().saveAllDocuments();
    }

    @NotNull
    public static String loadScript(@Nullable Project project, @NotNull File script) throws IOException {
        String string;
        if (script == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(4);
        }
        try {
            string = FileUtil.loadFile((File)script);
        }
        catch (IOException e) {
            ExtensionScriptsUtil.showError(project, "Failed to load script: " + script.getPath(), ExceptionUtil.getThrowableText((Throwable)e));
            throw e;
        }
        if (string == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static void evalScript(@Nullable Project project, @NotNull IdeScriptEngine engine, @NotNull String script) throws IdeScriptException {
        if (engine == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(6);
        }
        if (script == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(7);
        }
        try {
            engine.eval(script);
        }
        catch (IdeScriptException e) {
            if (e.getCause() instanceof ProcessCanceledException) {
                throw e;
            }
            ExtensionScriptsUtil.showScriptExecutionError(project, ExceptionUtil.getRootCause((Throwable)e));
            throw e;
        }
    }

    public static void showScriptExecutionError(@Nullable Project project, @NotNull Throwable error) {
        if (error == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(8);
        }
        ExtensionScriptsUtil.showError(project, "Script execution error", ExceptionUtil.getThrowableText((Throwable)error, (String)"com.intellij."));
    }

    public static void showError(@Nullable Project project, @NotNull String title, @NotNull String content) {
        if (title == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(9);
        }
        if (content == null) {
            ExtensionScriptsUtil.$$$reportNull$$$0(10);
        }
        DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification(title, content, NotificationType.ERROR, null).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "engine";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extensions/ExtensionScriptsUtil";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extensions/ExtensionScriptsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "setBindings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getEngineFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBindings";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareScript";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadScript";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evalScript";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showScriptExecutionError";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Binder {
        private final IdeScriptEngine myEngine;

        Binder(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                Binder.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        @NotNull
        public <T> Binder bind(@NotNull Binding<T> what, @Nullable T to) {
            if (what == null) {
                Binder.$$$reportNull$$$0(1);
            }
            this.myEngine.setBinding(what.name, to);
            Binder binder = this;
            if (binder == null) {
                Binder.$$$reportNull$$$0(2);
            }
            return binder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "what";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extensions/ExtensionScriptsUtil$Binder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extensions/ExtensionScriptsUtil$Binder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "bind";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "bind";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

