/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModModelFun;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ModelModifier;
import com.intellij.database.model.ModelReader;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.ModelUtil;
import com.intellij.database.model.basic.BasicArrangedElement;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIdentifiedElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicModelListener;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.psi.DbTable;
import com.intellij.database.scripting.CompositeText;
import com.intellij.database.util.DbUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Strings;

public abstract class BaseModel
implements BasicModModel {
    private static final AtomicInteger ourModelCounter = new AtomicInteger(0);
    private final int myModelInstanceNumber = ourModelCounter.incrementAndGet();
    @NotNull
    private ModelTextStorage myTextStorage = BlackHoleTextStorage.INSTANCE;
    @NotNull
    private Logger log = Logger.getInstance(this.getClass());
    private final THashSet<BaseElement> myLastCreatedElements = new THashSet();
    private final THashSet<BaseElement> myLastModifiedElements = new THashSet();
    private final THashSet<BaseElement> myLastRemovedElements = new THashSet();
    private final ReentrantReadWriteLock myLock = new ReentrantReadWriteLock();
    private volatile long myModificationThreadId = Long.MIN_VALUE;
    private final CopyOnWriteArrayList<BasicModelListener> myListeners = new CopyOnWriteArrayList();

    @Override
    @NotNull
    public abstract BasicRoot getRoot();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V read(@NotNull ModelReader<? super BasicModel, V> reader) {
        if (reader == null) {
            BaseModel.$$$reportNull$$$0(0);
        }
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        readLock.lock();
        try {
            V v = reader.perform(this);
            return v;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public <R extends BasicModRoot> void modify(@NotNull Class<R> rootClass, @NotNull ModelModifier<? super R> modifier) {
        if (rootClass == null) {
            BaseModel.$$$reportNull$$$0(1);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(2);
        }
        this.modify(this.getRoot(), rootClass, modifier);
    }

    @Override
    public <E extends BasicElement, M extends E> void modify(@NotNull E element, @NotNull Class<M> clazz, @NotNull ModelModifier<? super M> modifier) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            BaseModel.$$$reportNull$$$0(4);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(5);
        }
        if (element.getModel() == null) {
            throw new IllegalArgumentException("Orphan element (the element doesn't belong to any model)");
        }
        if (element.getModel() != this) {
            throw new IllegalArgumentException("Alien element (the element belong to another model)");
        }
        Class<?> elementClass = element.getClass();
        if (!clazz.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException("Attempt to modify element of " + elementClass.getSimpleName() + " as an instance of " + clazz.getSimpleName());
        }
        E modElement = element;
        this.modify(modElement, modifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends BasicElement> void modify(@NotNull E element, @NotNull ModelModifier<? super E> modifier) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(6);
        }
        if (modifier == null) {
            BaseModel.$$$reportNull$$$0(7);
        }
        long time1 = System.currentTimeMillis();
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        writeLock.lock();
        long time2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Model entered into modifying mode (lock delay was " + (time2 - time1) + " ms)");
        }
        try {
            this.clearModifications();
            this.myModificationThreadId = Thread.currentThread().getId();
            long time3 = System.currentTimeMillis();
            modifier.perform(element);
            long time4 = System.currentTimeMillis();
            this.compactListeners();
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.format("Model was modified during %d ms, %d created, %d updated, %d removed ", time4 - time3, this.myLastCreatedElements.size(), this.myLastModifiedElements.size(), this.myLastRemovedElements.size()));
            }
        }
        finally {
            writeLock.unlock();
            this.myModificationThreadId = Integer.MIN_VALUE;
            long time5 = System.currentTimeMillis();
            this.notifyListeners();
            long time6 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Listeners took " + (time6 - time5) + " ms");
            }
            long time7 = System.currentTimeMillis();
            this.removeDroppedSources();
            long time8 = System.currentTimeMillis();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Dropping sources took " + (time8 - time7) + " ms");
            }
        }
    }

    void doingObjectCreate(@NotNull BaseElement element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(8);
        }
        this.doingAnyModification();
        this.myLastCreatedElements.add((Object)element);
    }

    void doingObjectModify(@NotNull BaseElement element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(9);
        }
        this.doingAnyModification();
        this.myLastModifiedElements.add((Object)element);
    }

    void doingObjectRemove(@NotNull BaseElement element) {
        if (element == null) {
            BaseModel.$$$reportNull$$$0(10);
        }
        this.doingAnyModification();
        if (element instanceof BasicSourceAware || element instanceof BasicNamespace) {
            this.myTextStorage.queueDelete(element);
        }
        this.myLastRemovedElements.add((Object)element);
    }

    private void doingAnyModification() {
    }

    @Override
    public void addListener(BasicModelListener listener) {
        this.myListeners.add(listener);
    }

    @Override
    public void removeListener(BasicModelListener listener) {
        this.myListeners.remove(listener);
    }

    @Override
    public void writeSources(@NotNull Runnable r) {
        if (r == null) {
            BaseModel.$$$reportNull$$$0(11);
        }
        this.myTextStorage.writeSession(r);
    }

    private void compactListeners() {
        this.myLastCreatedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastRemovedElements);
        this.myLastModifiedElements.removeAll(this.myLastCreatedElements);
    }

    private void notifyListeners() {
        if (this.myLastCreatedElements.isEmpty() && this.myLastModifiedElements.isEmpty() && this.myLastRemovedElements.isEmpty()) {
            return;
        }
        Set<BasicElement> lastCreatedElements = Collections.unmodifiableSet(this.myLastCreatedElements);
        Set<BasicElement> lastModifiedElements = Collections.unmodifiableSet(this.myLastModifiedElements);
        Set<BasicElement> lastRemovedElements = Collections.unmodifiableSet(this.myLastRemovedElements);
        for (BasicModelListener listener : this.myListeners) {
            listener.modified(lastCreatedElements, lastModifiedElements, lastRemovedElements);
        }
    }

    private void removeDroppedSources() {
        this.myTextStorage.processDeleteQueue();
    }

    private void clearModifications() {
        this.myLastCreatedElements.clear();
        this.myLastModifiedElements.clear();
        this.myLastRemovedElements.clear();
    }

    @Override
    public void saveSourceText(@NotNull BasicSourceAware object, @Nullable CompositeText sourceText) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(12);
        }
        this.myTextStorage.save(object, sourceText);
    }

    @Override
    @Nullable
    public CompositeText loadSourceText(@NotNull BasicSourceAware object) {
        if (object == null) {
            BaseModel.$$$reportNull$$$0(13);
        }
        return this.myTextStorage.load(object);
    }

    @Override
    public void setSchemaSourcesVersion(@NotNull BasicSchema schema, @Nullable Long version) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(14);
        }
        this.myTextStorage.setVersion(schema, version);
    }

    @Override
    @Nullable
    public Long getSchemaSourcesVersion(@NotNull BasicSchema schema) {
        if (schema == null) {
            BaseModel.$$$reportNull$$$0(15);
        }
        return this.myTextStorage.getVersion(schema);
    }

    @Override
    public void setTextStorage(@NotNull ModelTextStorage textStorage) {
        if (textStorage == null) {
            BaseModel.$$$reportNull$$$0(16);
        }
        this.myTextStorage = textStorage;
    }

    @Override
    @NotNull
    public ModelTextStorage getTextStorage() {
        ModelTextStorage modelTextStorage = this.myTextStorage;
        if (modelTextStorage == null) {
            BaseModel.$$$reportNull$$$0(17);
        }
        return modelTextStorage;
    }

    @NotNull
    static String deduplicate(@NotNull String str) {
        if (str == null) {
            BaseModel.$$$reportNull$$$0(18);
        }
        String string = str == ModelConsts.NO_NAME ? ModelConsts.NO_NAME : DbUtil.intern((String)str);
        if (string == null) {
            BaseModel.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Nullable
    @Contract(value="null,_ -> null", pure=true)
    protected static <X> X findFirst(@Nullable Iterable<X> items, @NotNull Predicate<X> predicate) {
        if (predicate == null) {
            BaseModel.$$$reportNull$$$0(20);
        }
        if (items == null) {
            return null;
        }
        for (X item : items) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    protected static boolean eq(@Nullable Object value1, @Nullable Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    public int hashCode() {
        return this.myModelInstanceNumber;
    }

    public String toString() {
        return String.format("%s model [instance %d]", this.getRdbms(), this.myModelInstanceNumber);
    }

    @Deprecated
    @NotNull
    public JBIterable<? extends BasicForeignKey> getExportedKeys(DasTable t) {
        BasicTable table = (BasicTable)ObjectUtils.tryCast((Object)(t instanceof DbTable ? ((DbTable)t).getDelegate() : t), BasicTable.class);
        JBIterable<BasicForeignKey> jBIterable = table != null ? ModModelFun.findReferencingForeignKeys(table) : JBIterable.empty();
        if (jBIterable == null) {
            BaseModel.$$$reportNull$$$0(21);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootClass";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textStorage";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/impl/BaseModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/impl/BaseModel";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextStorage";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "deduplicate";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectCreate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectModify";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doingObjectRemove";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeSources";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saveSourceText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadSourceText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setSchemaSourcesVersion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSchemaSourcesVersion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTextStorage";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deduplicate";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class BaseNamingIdentifyingFamily<E extends BaseElement & BasicModIdentifiedElement>
    extends BaseNamingFamily<E>
    implements ModNamingIdentifyingFamily<E> {
        public BaseNamingIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String string) {
            void name;
            if (string == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(1);
            }
            E e = this.renew(objectId, (String)name, (String s, String s2) -> {});
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(2);
            }
            return e;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public E renew(long objectId, @NotNull String name, @NotNull BiConsumer<String, String> biConsumer) {
            List elements;
            if (name == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(3);
            }
            if (biConsumer == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(4);
            }
            if ((elements = this.myElements) != null) {
                BaseElement e;
                int i2;
                int n = elements.size();
                if (objectId != Long.MIN_VALUE) {
                    for (i2 = 0; i2 < n; ++i2) {
                        e = (BaseElement)elements.get(i2);
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != objectId) continue;
                        String oldName = ((BasicNamedElement)((Object)e)).getName();
                        ((BasicModNamedElement)((Object)e)).setName(name);
                        e.resetSyncPending();
                        String newName = ((BasicNamedElement)((Object)e)).getName();
                        if (!Strings.eq((String)oldName, (String)newName)) {
                            void renameHandler;
                            renameHandler.accept(oldName, newName);
                        }
                        BaseElement baseElement = e;
                        if (baseElement == null) {
                            BaseNamingIdentifyingFamily.$$$reportNull$$$0(5);
                        }
                        return (E)baseElement;
                    }
                }
                if (name != ModelConsts.NO_NAME) {
                    for (i2 = 0; i2 < n; ++i2) {
                        e = (BaseElement)elements.get(i2);
                        if (((BasicIdentifiedElement)((Object)e)).getObjectId() != Long.MIN_VALUE || !((BasicNamedElement)((Object)e)).getName().equals(name)) continue;
                        ((BasicModIdentifiedElement)((Object)e)).setObjectId(objectId);
                        e.resetSyncPending();
                        BaseElement baseElement = e;
                        if (baseElement == null) {
                            BaseNamingIdentifyingFamily.$$$reportNull$$$0(6);
                        }
                        return (E)baseElement;
                    }
                }
            }
            BasicModElement e = this.createNewOne();
            ((BasicModIdentifiedElement)e).setObjectId(objectId);
            ((BasicModNamedElement)e).setName(name);
            BasicModElement basicModElement = e;
            if (basicModElement == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(7);
            }
            return (E)basicModElement;
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element = this.getByObjectId(objectId);
            if (element == null) {
                element = this.createNewOne();
                ((BasicModIdentifiedElement)element).setObjectId(objectId);
            }
            E e = element;
            if (e == null) {
                BaseNamingIdentifyingFamily.$$$reportNull$$$0(8);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i2 = 0; i2 < n; ++i2) {
                BaseElement element = (BaseElement)elements.get(i2);
                if (((BasicIdentifiedElement)((Object)element)).getObjectId() != objectId) continue;
                return (E)element;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renameHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseNamingIdentifyingFamily";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "renew";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "renew";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BasePositioningNamingFamily<E extends BaseElement & BasicModNamedElement>
    extends BaseNamingFamily<E>
    implements ModPositioningNamingFamily<E> {
        public BasePositioningNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E renewAt(short position, @NotNull String name) {
            List elements;
            BasicModElement e;
            if (name == null) {
                BasePositioningNamingFamily.$$$reportNull$$$0(1);
            }
            if ((e = BaseModel.findFirst(elements = this.myElements, x -> {
                if (name == null) {
                    BasePositioningNamingFamily.$$$reportNull$$$0(3);
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName().equals(name);
            })) != null) {
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> ((BasicArrangedElement)((Object)x)).getPosition() == position && ((BasicNamedElement)((Object)x)).getName() == ModelConsts.NO_NAME);
            if (e != null) {
                ((BasicModNamedElement)e).setName(name);
                e.resetSyncPending();
                return (E)e;
            }
            e = BaseModel.findFirst(elements, x -> {
                if (name == null) {
                    BasePositioningNamingFamily.$$$reportNull$$$0(2);
                }
                return ((BasicArrangedElement)((Object)x)).getPosition() == 0 && ((BasicNamedElement)((Object)x)).getName().equals(name);
            });
            if (e != null) {
                ((BasicModArrangedElement)e).setPosition(position);
                e.resetSyncPending();
                return (E)e;
            }
            e = this.createNewOne();
            ((BasicModArrangedElement)e).setPosition(position);
            ((BasicModNamedElement)e).setName(name);
            return (E)e;
        }

        @Override
        public E createOrGetAt(short position) {
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element = this.createNewOne();
                ((BasicModArrangedElement)element).setPosition(position);
                CopyOnWriteArrayList<BasicModElement> newElements = new CopyOnWriteArrayList<BasicModElement>();
                newElements.add(element);
                this.myElements = newElements;
                return (E)element;
            }
            for (BaseElement element : elements) {
                if (((BasicArrangedElement)((Object)element)).getPosition() != position) continue;
                element.resetSyncPending();
                return (E)element;
            }
            BasicModElement element = this.createNewOne();
            ((BasicModArrangedElement)element).setPosition(position);
            return (E)element;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            return (E)BaseModel.findFirst(elements, e -> ((BasicArrangedElement)((Object)e)).getPosition() == position);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BasePositioningNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renewAt";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$renewAt$2";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$renewAt$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BaseIdentifyingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModIdentifyingFamily<E> {
        public BaseIdentifyingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @NotNull
        public E createOrGet(long objectId) {
            Object element = this.getByObjectId(objectId);
            if (element == null) {
                element = this.createNewOne();
                ((BasicModIdentifiedElement)element).setObjectId(objectId);
            }
            E e = element;
            if (e == null) {
                BaseIdentifyingFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @Nullable
        public E getByObjectId(long objectId) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i2 = 0; i2 < n; ++i2) {
                BaseElement element = (BaseElement)elements.get(i2);
                if (((BasicIdentifiedElement)((Object)element)).getObjectId() != objectId) continue;
                return (E)element;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseIdentifyingFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseIdentifyingFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseNamingFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModNamingFamily<E> {
        public BaseNamingFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseNamingFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E createOrGet(@NotNull String name) {
            Object element;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(1);
            }
            if ((element = this.get(name)) == null) {
                element = this.createNewOne();
                ((BasicModNamedElement)element).setName(name);
            } else {
                element.resetSyncPending();
            }
            return element;
        }

        @Override
        @Nullable
        public E get(@NotNull String name) {
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(2);
            }
            return this.get(name, true);
        }

        @Override
        @Nullable
        public E get(@NotNull String name, boolean caseSensitive) {
            List elements;
            if (name == null) {
                BaseNamingFamily.$$$reportNull$$$0(3);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            int n = elements.size();
            for (int i2 = 0; i2 < n; ++i2) {
                boolean matched;
                BaseElement element = (BaseElement)elements.get(i2);
                boolean bl = matched = caseSensitive ? ((BasicNamedElement)((Object)element)).getName().equals(name) : ((BasicNamedElement)((Object)element)).getName().equalsIgnoreCase(name);
                if (!matched) continue;
                return (E)element;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseNamingFamily";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createOrGet";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "get";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class BasePositioningFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModPositioningFamily<E> {
        public BasePositioningFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BasePositioningFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        public E createOrGetAt(short position) {
            List elements = this.myElements;
            if (elements == null) {
                BasicModElement element = this.createNewOne();
                ((BasicModArrangedElement)element).setPosition(position);
                CopyOnWriteArrayList<BasicModElement> newElements = new CopyOnWriteArrayList<BasicModElement>();
                newElements.add(element);
                this.myElements = newElements;
                return (E)element;
            }
            for (BaseElement element : elements) {
                if (((BasicArrangedElement)((Object)element)).getPosition() != position) continue;
                element.resetSyncPending();
                return (E)element;
            }
            BasicModElement element = this.createNewOne();
            ((BasicModArrangedElement)element).setPosition(position);
            return (E)element;
        }

        @Override
        @Nullable
        public E getByNaturalPosition(short position) {
            List elements = this.myElements;
            if (elements == null) {
                return null;
            }
            int n = elements.size();
            for (int i2 = 0; i2 < n; ++i2) {
                BaseElement element = (BaseElement)elements.get(i2);
                if (((BasicArrangedElement)((Object)element)).getPosition() != position) continue;
                return (E)element;
            }
            return null;
        }

        @Override
        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.POSITIONS_COMPARATOR;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/database/model/impl/BaseModel$BasePositioningFamily", "<init>"));
        }
    }

    public static abstract class BaseSingletonFamily<E extends BaseElement>
    extends BaseFamily<E>
    implements ModSingletonFamily<E> {
        public BaseSingletonFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseSingletonFamily.$$$reportNull$$$0(0);
            }
            super(owner);
        }

        @Override
        @Nullable
        public E get() {
            List elements = this.myElements;
            return (E)(elements == null ? null : (BaseElement)elements.get(0));
        }

        @Override
        @NotNull
        public E createNewOne() {
            this.owner.modifying();
            assert (this.myElements == null);
            Object newOne = this.instantiate();
            this.myElements = Collections.singletonList(newOne);
            Object e = newOne;
            if (e == null) {
                BaseSingletonFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @NotNull
        public E createOrGet() {
            if (this.isEmpty()) {
                BasicModElement basicModElement = this.createNewOne();
                if (basicModElement == null) {
                    BaseSingletonFamily.$$$reportNull$$$0(2);
                }
                return (E)basicModElement;
            }
            BasicElement basicElement = this.first();
            if (basicElement == null) {
                BaseSingletonFamily.$$$reportNull$$$0(3);
            }
            return (E)basicElement;
        }

        @Override
        public void sort() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseSingletonFamily";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseSingletonFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOrGet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class BaseFamily<E extends BaseElement>
    implements ModFamily<E> {
        @NotNull
        protected final BaseElement owner;
        @Nullable
        protected volatile List<E> myElements;

        public BaseFamily(@NotNull BaseElement owner) {
            if (owner == null) {
                BaseFamily.$$$reportNull$$$0(0);
            }
            this.myElements = null;
            this.owner = owner;
        }

        @NotNull
        protected abstract E instantiate();

        @Override
        @NotNull
        public E createNewOne() {
            BaseModel model = (BaseModel)this.owner.getModel();
            this.owner.modifying();
            E newOne = this.instantiate();
            if (this.myElements == null) {
                this.myElements = new CopyOnWriteArrayList();
            }
            this.myElements.add(newOne);
            model.doingObjectCreate((BaseElement)newOne);
            E e = newOne;
            if (e == null) {
                BaseFamily.$$$reportNull$$$0(1);
            }
            return e;
        }

        @Override
        @NotNull
        public BasicModModel getModel() {
            BasicModModel basicModModel = this.owner.getModel();
            if (basicModModel == null) {
                BaseFamily.$$$reportNull$$$0(2);
            }
            return basicModModel;
        }

        @Override
        @NotNull
        public E first() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(0);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(3);
            }
            return (E)baseElement;
        }

        @Override
        @NotNull
        public E last() {
            List<E> elements = this.myElements;
            if (elements == null || elements.isEmpty()) {
                throw new IllegalStateException("Family is empty");
            }
            BaseElement baseElement = (BaseElement)elements.get(elements.size() - 1);
            if (baseElement == null) {
                BaseFamily.$$$reportNull$$$0(4);
            }
            return (E)baseElement;
        }

        @Override
        public int indexOf(@Nullable BasicElement element) {
            if (element == null) {
                return -1;
            }
            List<E> elements = this.myElements;
            if (elements == null) {
                return -1;
            }
            return elements.indexOf(element);
        }

        @Override
        public boolean hasChildren() {
            List<E> elements = this.myElements;
            return elements != null && !elements.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            List<E> elements = this.myElements;
            return elements == null || elements.isEmpty();
        }

        @Override
        public int size() {
            List<E> elements = this.myElements;
            return elements != null ? elements.size() : 0;
        }

        @Override
        @Nullable
        public E find(@NotNull Predicate<? super E> predicate) {
            List<E> elements;
            if (predicate == null) {
                BaseFamily.$$$reportNull$$$0(5);
            }
            if ((elements = this.myElements) == null) {
                return null;
            }
            for (BaseElement element : elements) {
                if (!predicate.test(element)) continue;
                return (E)element;
            }
            return null;
        }

        @Override
        public Iterator<E> iterator() {
            List<E> elements = this.myElements;
            if (elements != null) {
                return elements.iterator();
            }
            return Collections.emptyListIterator();
        }

        @Override
        public void remove(@NotNull Predicate<? super E> condition) {
            List<E> elements;
            if (condition == null) {
                BaseFamily.$$$reportNull$$$0(6);
            }
            if ((elements = this.myElements) == null) {
                return;
            }
            int n = elements.size();
            boolean modificationSent = false;
            for (int i2 = n - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                if (!condition.test(e)) continue;
                if (!modificationSent) {
                    modificationSent = true;
                    this.owner.modifying();
                }
                e.internalDrop(false);
                if (elements.size() >= 2) {
                    elements.remove(i2);
                    continue;
                }
                this.myElements = null;
            }
            if (elements.isEmpty()) {
                this.myElements = null;
            }
        }

        @Override
        public void sort() {
            List<E> elements = this.myElements;
            if (elements == null || elements.size() < 2) {
                return;
            }
            this.owner.modifying();
            if (!(elements instanceof ArrayList) && !(elements instanceof CopyOnWriteArrayList)) {
                throw new IllegalStateException("Unknown how to reorder elements inside a " + elements.getClass().getSimpleName());
            }
            Comparator<E> comparator = this.getElementsComparator();
            elements.sort(comparator);
        }

        protected Comparator<? super E> getElementsComparator() {
            return ModelUtil.DISPLAY_ORDER_COMPARATOR;
        }

        @Override
        public void clear() {
            List<E> elements = this.myElements;
            if (elements == null) {
                return;
            }
            this.owner.modifying();
            this.myElements = null;
            for (int i2 = elements.size() - 1; i2 >= 0; --i2) {
                BaseElement e = (BaseElement)elements.get(i2);
                e.internalDrop(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "owner";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseFamily";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseFamily";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewOne";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "first";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "last";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "find";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "remove";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public abstract class BaseRegularNamedElement
    extends BaseRegularElement
    implements BasicModNamedElement {
        @NotNull
        private String myName;
        private short myFlags;

        public BaseRegularNamedElement(BaseFamily<?> parentFamily) {
            if (parentFamily == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(0);
            }
            super(parentFamily);
            this.myName = ModelConsts.NO_NAME;
            this.myFlags = 0;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setName(@NotNull String name) {
            if (name == null) {
                BaseRegularNamedElement.$$$reportNull$$$0(2);
            }
            if (this.myName.equals(name)) {
                return;
            }
            this.modifying();
            this.myName = BaseModel.deduplicate(name);
        }

        @Override
        public boolean isNameSurrogate() {
            return (this.myFlags & 1) != 0;
        }

        @Override
        public boolean isNameScripted() {
            return (this.myFlags & 2) != 0;
        }

        @Override
        public boolean isNameQuoted() {
            return (this.myFlags & 4) != 0;
        }

        @Override
        public void setNameSurrogate(boolean nameSurrogate) {
            if ((this.myFlags & 1) != 0 == nameSurrogate) {
                return;
            }
            this.modifying();
            this.myFlags = nameSurrogate ? (short)(this.myFlags | 1) : (short)(this.myFlags & 0xFFFFFFFE);
        }

        @Override
        public void setNameScripted(boolean nameScripted) {
            if ((this.myFlags & 2) != 0 == nameScripted) {
                return;
            }
            this.modifying();
            this.myFlags = nameScripted ? (short)(this.myFlags | 2) : (short)(this.myFlags & 0xFFFFFFFD);
        }

        @Override
        public void setNameQuoted(boolean nameQuoted) {
            if ((this.myFlags & 4) != 0 == nameQuoted) {
                return;
            }
            this.modifying();
            this.myFlags = nameQuoted ? (short)(this.myFlags | 4) : (short)(this.myFlags & 0xFFFFFFFB);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseRegularNamedElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseRegularNamedElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public abstract class BaseRegularElement
    extends BaseElement {
        @NotNull
        protected final BaseFamily<?> myParentFamily;
        @Nullable
        private transient String myDisplayOrder;
        private transient boolean myDropped;
        private transient boolean mySyncPending;

        public BaseRegularElement(BaseFamily<?> parentFamily) {
            if (parentFamily == null) {
                BaseRegularElement.$$$reportNull$$$0(0);
            }
            this.myDisplayOrder = null;
            this.myDropped = false;
            this.mySyncPending = false;
            this.myParentFamily = parentFamily;
        }

        @Override
        protected void modifying() {
            super.modifying();
            this.myDisplayOrder = null;
        }

        @Override
        @NotNull
        public final String getDisplayOrder() {
            String o = this.myDisplayOrder;
            if (o == null) {
                this.myDisplayOrder = o = this.calculateDisplayOrder();
            }
            String string = o;
            if (string == null) {
                BaseRegularElement.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void setSyncPending(boolean syncPending) {
            this.mySyncPending = syncPending;
        }

        @Override
        public boolean isSyncPending() {
            return this.mySyncPending;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            BaseModel.this.doingObjectRemove(this);
            this.dropChildren();
            if (removeFromParent) {
                this.myParentFamily.remove(e -> e == this);
            }
            this.myDropped = true;
        }

        @Override
        public boolean isDropped() {
            return this.myDropped;
        }

        public String toString() {
            return this.identity(true) + ": " + this.getKind().name().toLowerCase(Locale.ROOT);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentFamily";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/impl/BaseModel$BaseRegularElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/impl/BaseModel$BaseRegularElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayOrder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public abstract class BaseRoot
    extends BaseElement
    implements BasicModRoot {
        @Override
        public void setSyncPending(boolean syncPending) {
            if (syncPending) {
                throw new IllegalStateException("Cannot set the root element as sync pending");
            }
        }

        @Override
        public boolean isSyncPending() {
            return false;
        }

        @Override
        public final void internalDrop(boolean removeFromParent) {
            throw new IllegalStateException("Cannot drop a root element");
        }

        @Override
        public boolean isDropped() {
            return false;
        }

        @Override
        @NotNull
        public String calculateDisplayOrder() {
            if ("ROOT" == null) {
                BaseRoot.$$$reportNull$$$0(0);
            }
            return "ROOT";
        }

        public String toString() {
            return "ROOT";
        }

        @Override
        @NotNull
        public @NotNull @NotNull List<String> getDbPath() {
            List<String> list = Collections.emptyList();
            if (list == null) {
                BaseRoot.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/database/model/impl/BaseModel$BaseRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateDisplayOrder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbPath";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public abstract class BaseElement
    implements BasicModElement {
        @Override
        @NotNull
        public BasicModModel getModel() {
            BaseModel baseModel = BaseModel.this;
            if (baseModel == null) {
                BaseElement.$$$reportNull$$$0(0);
            }
            return baseModel;
        }

        protected void modifying() {
            BaseModel.this.doingObjectModify(this);
        }

        @Override
        public void drop() {
            this.internalDrop(true);
        }

        abstract void internalDrop(boolean var1);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/impl/BaseModel$BaseElement", "getModel"));
        }
    }
}

