/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.wm.FocusCommand;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridCellEditorsUtil {
    private GridCellEditorsUtil() {
    }

    public static void showCellEditorPopup(final DataGrid grid, final Component component, int x, int y) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup popupActions = (ActionGroup)actionManager.getAction("Console.TableResult.CellEditor.Popup");
        JPopupMenu popup = actionManager.createActionPopupMenu("EditorPopup", popupActions).getComponent();
        popup.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                final IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)component);
                fm.requestFocus(new FocusCommand(){

                    @NotNull
                    public ActionCallback run() {
                        ActionCallback actionCallback = grid.isEditing() ? ActionCallback.REJECTED : fm.requestFocus((Component)grid.getPreferredFocusedComponent(), true);
                        if (actionCallback == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return actionCallback;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$1$1", "run"));
                    }
                }, true);
            }
        });
        popup.show(component, x, y);
    }

    @Nullable
    public static TextCompletionProvider createCompletionProvider(final @NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> column) {
        GridModel model;
        DataConsumer.Column c;
        if (grid == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(0);
        }
        if (column == null) {
            GridCellEditorsUtil.$$$reportNull$$$0(1);
        }
        return GridCellEditorsUtil.canComplete(c = (model = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS)).getColumn(column)) ? new TextFieldWithAutoCompletion.StringsCompletionProvider(null, null){

            @NotNull
            public Collection<String> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                List rows = model.getRows();
                ArrayList objects = ContainerUtil.newArrayListWithCapacity((int)rows.size());
                DatabaseDialectEx dialect = DataGridUtil.getDatabaseDialect(grid);
                for (DataConsumer.Row r : rows) {
                    Object v = c.getValue(r);
                    if (v == null) continue;
                    objects.add(grid.getObjectFormatter().getPlainValue(c, r, (DatabaseDialect)dialect));
                }
                ArrayList arrayList = objects;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil$2", "getItems"));
            }
        } : null;
    }

    private static boolean canComplete(@Nullable DataConsumer.Column c) {
        return c != null && !DbImplUtil.canInsertBlob(c) && (JdbcUtil.isNumberType((int)c.type) || !c.clazz.equals("java.lang.Integer") || JdbcUtil.isStringType((int)c.type));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "grid";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "column";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorsUtil";
        objectArray[2] = "createCompletionProvider";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

