/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicConstraint;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.basic.BasicTableOrView;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.mssql.MsCheck;
import com.intellij.database.model.mssql.MsDatabase;
import com.intellij.database.model.mssql.MsIndex;
import com.intellij.database.model.mssql.MsKey;
import com.intellij.database.model.mssql.MsLikeTable;
import com.intellij.database.model.mssql.MsModel;
import com.intellij.database.model.mssql.MsSchema;
import com.intellij.database.model.mssql.MsSourceAware;
import com.intellij.database.model.mssql.MsStoredTable;
import com.intellij.database.model.mssql.MsTableOrView;
import com.intellij.database.model.mssql.MsTableType;
import com.intellij.database.model.mssql.MsTableTypeColumn;
import com.intellij.database.model.mssql.MsTrigger;
import com.intellij.database.scripting.AbstractCodeGenerator;
import com.intellij.database.scripting.BaseCreatingGenerator;
import com.intellij.database.scripting.BaseEnableDisableGenerator;
import com.intellij.database.scripting.CodeTextBuilder;
import com.intellij.database.scripting.MsScriptingService$MsEnableDisableGenerator$WhenMappings;
import com.intellij.database.scripting.ScriptLocus;
import com.intellij.database.scripting.ScriptingContext;
import com.intellij.database.scripting.ScriptingTask;
import com.intellij.database.scripting.TsqlScriptingService;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003\r\u000e\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/scripting/MsScriptingService;", "Lcom/intellij/database/scripting/TsqlScriptingService;", "Lcom/intellij/database/model/mssql/MsModel;", "Lcom/intellij/database/model/mssql/MsDatabase;", "Lcom/intellij/database/model/mssql/MsSchema;", "model", "database", "(Lcom/intellij/database/model/mssql/MsModel;Lcom/intellij/database/model/mssql/MsDatabase;)V", "createCreatingGenerator", "Lcom/intellij/database/scripting/AbstractCodeGenerator;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "createEnableDisableGenerator", "MsCreatingGenerator", "MsEnableDisableGenerator", "VERSION", "database-scripting"})
public final class MsScriptingService
extends TsqlScriptingService<MsModel, MsDatabase, MsSchema> {
    @Override
    @NotNull
    protected AbstractCodeGenerator createCreatingGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new MsCreatingGenerator(this.getContext(), task);
    }

    @Override
    @NotNull
    protected AbstractCodeGenerator createEnableDisableGenerator(@NotNull ScriptingTask task) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        return new MsEnableDisableGenerator(this.getContext(), task);
    }

    public MsScriptingService(@NotNull MsModel model, @NotNull MsDatabase database) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
        super((BasicModel)model, (BasicDatabase)database);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0014J\n\u0010)\u001a\u00020\"*\u00020\"\u00a8\u0006*"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$MsCreatingGenerator;", "Lcom/intellij/database/scripting/BaseCreatingGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MsScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateAliasType", "", "aliasType", "Lcom/intellij/database/model/mssql/MsAliasType;", "generateColumnComment", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "generateDisableTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateElement", "element", "Lcom/intellij/database/model/basic/BasicElement;", "generateEncryptedTrigger", "Lcom/intellij/database/model/mssql/MsTrigger;", "generateSourceAwareUsingSources", "Lcom/intellij/database/model/basic/BasicSourceAware;", "generateTableComment", "table", "Lcom/intellij/database/model/basic/BasicTableOrView;", "generateTableType", "tableType", "Lcom/intellij/database/model/mssql/MsTableType;", "generateTrigger", "getSingleColumnElements", "", "makeColumnSpecification", "", "makeIndexWord", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "makeKeyWord", "key", "Lcom/intellij/database/model/basic/BasicKey;", "quoteNameAsString", "database-scripting"})
    private final class MsCreatingGenerator
    extends BaseCreatingGenerator {
        @Override
        protected void generateElement(@NotNull BasicElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            BasicElement basicElement = element;
            if (basicElement instanceof MsAliasType) {
                this.generateAliasType((MsAliasType)element);
            } else if (basicElement instanceof MsTableType) {
                this.generateTableType((MsTableType)element);
            } else if (basicElement instanceof MsTrigger) {
                this.generateTrigger((MsTrigger)element);
            } else if (basicElement instanceof MsSourceAware) {
                this.generateSourceAwareElement((BasicSourceAware)element, true);
            } else {
                super.generateElement(element);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void generateAliasType(MsAliasType aliasType) {
            void statement;
            String name = this.currentScopeName(aliasType);
            String type = aliasType.getDataType().getSpecification();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "create type " + name + " from " + type;
            if (aliasType.isNotNull()) {
                statement.element = (String)statement.element + " not null";
            }
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, (Ref.ObjectRef)statement){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ Ref.ObjectRef $statement;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), (String)this.$statement.element, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$statement = objectRef;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateTableType(MsTableType tableType) {
            String name = this.currentScopeName(tableType);
            AbstractCodeGenerator.coding$default(this, ScriptLocus.IN_TABLE, false, (Function0)new Function0<Unit>(this, name, tableType){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $name;
                final /* synthetic */ MsTableType $tableType;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create type " + this.$name + " as table", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "(", null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        if (this.$tableType.getColumns().isEmpty()) {
                            CodeTextBuilder.append$default(this.this$0.getBuilder(), "-- the table type " + this.$tableType.getName() + " has no columns", null, false, 6, null);
                        }
                        Iterator<T> iterator = this.$tableType.getColumns().iterator();
                        while (iterator.hasNext()) {
                            MsTableTypeColumn msTableTypeColumn;
                            MsTableTypeColumn msTableTypeColumn2 = msTableTypeColumn = (MsTableTypeColumn)iterator.next();
                            Intrinsics.checkExpressionValueIsNotNull((Object)msTableTypeColumn2, (String)"column");
                            this.this$0.processElement(msTableTypeColumn2);
                        }
                        for (MsKey msKey : this.$tableType.getKeys()) {
                            if (this.this$0.MsScriptingService.this.getGenerated().contains(msKey)) continue;
                            MsKey msKey2 = msKey;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msKey2, (String)"key");
                            this.this$0.processElement(msKey2);
                        }
                        for (MsCheck msCheck : this.$tableType.getChecks()) {
                            if (this.this$0.MsScriptingService.this.getGenerated().contains(msCheck)) continue;
                            MsCheck msCheck2 = msCheck;
                            Intrinsics.checkExpressionValueIsNotNull((Object)msCheck2, (String)"check");
                            this.this$0.processElement(msCheck2);
                        }
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    this.this$0.getBuilder().removeSuffixFromTheLastLine(',');
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), ")", null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$name = string;
                    this.$tableType = msTableType;
                    super(0);
                }
            }, 2, null);
        }

        @Override
        @NotNull
        protected Iterable<BasicElement> getSingleColumnElements(@NotNull BasicLikeColumn column) {
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            return super.getSingleColumnElements(column);
        }

        @Override
        @Nullable
        protected String makeColumnSpecification(@NotNull BasicLikeColumn column) {
            String s;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            if (Intrinsics.areEqual((Object)column.getName(), (Object)"timestamp") && Intrinsics.areEqual((Object)column.getDataType().typeName, (Object)"timestamp") && !column.getDataType().custom) {
                s = column.isNotNull() ? "not null" : "null";
            } else {
                SequenceIdentity q;
                s = super.makeColumnSpecification(column);
                BasicLikeColumn basicLikeColumn = column;
                if (!(basicLikeColumn instanceof BasicTableColumn)) {
                    basicLikeColumn = null;
                }
                BasicTableColumn basicTableColumn = (BasicTableColumn)basicLikeColumn;
                SequenceIdentity sequenceIdentity = q = basicTableColumn != null ? basicTableColumn.getSequenceIdentity() : null;
                if (q != null) {
                    String identityClause = Intrinsics.areEqual((Object)q.min, (Object)BigInteger.ONE) && Intrinsics.areEqual((Object)q.increment, (Object)BigInteger.ONE) ? " identity" : " identity(" + q.min + ", " + q.increment + ')';
                    s = Intrinsics.stringPlus((String)s, (Object)identityClause);
                }
            }
            return s;
        }

        @Override
        @NotNull
        protected String makeKeyWord(@NotNull BasicKey key2) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
            return key2 instanceof MsKey ? (((MsKey)key2).isPrimary() ? (((MsKey)key2).isClustering() ? "primary key" : "primary key nonclustered") : (((MsKey)key2).isClustering() ? "unique clustered" : "unique")) : super.makeKeyWord(key2);
        }

        @Override
        @NotNull
        protected String makeIndexWord(@NotNull BasicIndex index) {
            Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
            MsIndex i2 = (MsIndex)index;
            if (i2.isUnique()) {
                boolean primary2;
                MsLikeTable table = ((MsIndex)index).getLikeTable();
                boolean bl = primary2 = table instanceof MsStoredTable && ((MsStoredTable)table).getKeys().has((Predicate<? extends MsKey>)new Predicate<MsKey>(i2){
                    final /* synthetic */ MsIndex $i;

                    public final boolean test(MsKey it) {
                        return it.isPrimary() && Intrinsics.areEqual((Object)it.getUnderlyingIndexName(), (Object)this.$i.getName());
                    }
                    {
                        this.$i = msIndex;
                    }
                });
                String word = primary2 ? (i2.isClustering() ? "unique index" : "unique nonclustered index") : (i2.isClustering() ? "unique clustered index" : "unique index");
                return word;
            }
            return i2.isClustering() ? "clustered index" : "index";
        }

        @Override
        protected void generateTableComment(@NotNull BasicTableOrView table) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
            String name = this.quoteNameAsString(table.getName());
            String string2 = table.getComment();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String comment = string2;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + name + "\n              "), null, (int)1, null);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateColumnComment(@NotNull BasicLikeColumn column) {
            String string;
            ObjectKind kind;
            Intrinsics.checkParameterIsNotNull((Object)column, (String)"column");
            BasicLikeTable basicLikeTable = column.getLikeTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String string2 = table.getRealName();
            if (string2 == null || (string2 = this.quoteNameAsString(string2)) == null) {
                return;
            }
            String tableName = string2;
            String string3 = column.getRealName();
            if (string3 == null || (string3 = this.quoteNameAsString(string3)) == null) {
                return;
            }
            String columnName = string3;
            String string4 = column.getComment();
            if (string4 == null || (string4 = this.quoteNameAsString(string4)) == null) {
                return;
            }
            String comment = string4;
            ObjectKind objectKind = kind = table.getKind();
            if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE)) {
                string = "TABLE";
            } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW)) {
                string = "VIEW";
            } else {
                return;
            }
            String tableWord = string;
            String s = StringsKt.trimMargin$default((String)("\n              |declare @sn nvarchar(30)\n              |set @sn = schema_name()\n              |execute sp_addextendedproperty N'MS_Description', N" + comment + ", N'SCHEMA', @sn, N'" + tableWord + "', N" + tableName + ", N'COLUMN', N" + columnName + "\n              "), null, (int)1, null);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, s){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $s;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), this.$s, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$s = string;
                    super(0);
                }
            }, 3, null);
        }

        private final void generateTrigger(MsTrigger trigger) {
            if (trigger.isEncrypted()) {
                this.generateEncryptedTrigger(trigger);
            } else {
                this.generateSourceAwareUsingSources(trigger);
            }
            if (trigger.isDisabled()) {
                this.generateDisableTrigger(trigger);
            }
        }

        private final void generateEncryptedTrigger(MsTrigger trigger) {
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, trigger){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ MsTrigger $trigger;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "create trigger " + this.this$0.currentScopeName(this.$trigger), null, false, 6, null);
                    CodeTextBuilder this_$iv = this.this$0.getBuilder();
                    CodeTextBuilder.indent$default(this_$iv, null, 1, null);
                    try {
                        CodeTextBuilder codeTextBuilder = this.this$0.getBuilder();
                        StringBuilder stringBuilder = new StringBuilder().append("on ");
                        Object object = this.$trigger.getTable();
                        if (object == null || (object = this.this$0.currentScopeName((BasicElement)object)) == null) {
                            object = this.$trigger.getTableName();
                        }
                        CodeTextBuilder.append$default(codeTextBuilder, stringBuilder.append((String)object).toString(), null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "with encryption", null, false, 6, null);
                        CodeTextBuilder.append$default(this.this$0.getBuilder(), "for " + CollectionsKt.joinToString$default((Iterable)this.$trigger.getEvents(), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null), null, false, 6, null);
                    }
                    finally {
                        this_$iv.unindent();
                    }
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "as", null, false, 6, null);
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "select null -- the original source text was encrypted", null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$trigger = msTrigger;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateDisableTrigger(@NotNull BasicTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            String triggerName = this.currentScopeName(trigger);
            DasTable dasTable = trigger.getTable();
            if (dasTable == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.mssql.MsTableOrView");
            }
            String tableName = this.currentScopeName((MsTableOrView)dasTable);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, tableName){
                final /* synthetic */ MsCreatingGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ String $tableName;

                public final void invoke() {
                    CodeTextBuilder.append$default(this.this$0.getBuilder(), "disable trigger " + this.$triggerName + " on " + this.$tableName, null, false, 6, null);
                }
                {
                    this.this$0 = msCreatingGenerator;
                    this.$triggerName = string;
                    this.$tableName = string2;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateSourceAwareUsingSources(@NotNull BasicSourceAware element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            if (element instanceof MsSourceAware && ((MsSourceAware)element).isEncrypted()) {
                BasicSourceAware basicSourceAware = element;
                if (basicSourceAware instanceof MsTrigger) {
                    this.generateEncryptedTrigger((MsTrigger)element);
                }
            } else {
                super.generateSourceAwareUsingSources(element);
            }
        }

        @NotNull
        public final String quoteNameAsString(@NotNull String $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return "'" + StringsKt.replace$default((String)$receiver, (String)"'", (String)"''", (boolean)false, (int)4, null) + "'";
        }

        public MsCreatingGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$MsEnableDisableGenerator;", "Lcom/intellij/database/scripting/BaseEnableDisableGenerator;", "context", "Lcom/intellij/database/scripting/ScriptingContext;", "task", "Lcom/intellij/database/scripting/ScriptingTask;", "(Lcom/intellij/database/scripting/MsScriptingService;Lcom/intellij/database/scripting/ScriptingContext;Lcom/intellij/database/scripting/ScriptingTask;)V", "generateEnableDisableForConstraint", "", "constraint", "Lcom/intellij/database/model/basic/BasicConstraint;", "generateEnableDisableForTrigger", "trigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "generateKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "database-scripting"})
    private final class MsEnableDisableGenerator
    extends BaseEnableDisableGenerator {
        @Override
        protected void generateKey(@NotNull BasicKey key2) {
            Intrinsics.checkParameterIsNotNull((Object)key2, (String)"key");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void generateEnableDisableForConstraint(@NotNull BasicConstraint constraint) {
            void $receiver$iv;
            String string;
            Intrinsics.checkParameterIsNotNull((Object)constraint, (String)"constraint");
            switch (MsScriptingService$MsEnableDisableGenerator$WhenMappings.$EnumSwitchMapping$0[this.getTask().ordinal()]) {
                case 1: {
                    string = "check";
                    break;
                }
                case 2: {
                    string = "nocheck";
                    break;
                }
                default: {
                    return;
                }
            }
            String constraintActionWord = string;
            BasicLikeTable basicLikeTable = constraint.getLikeTable();
            if (basicLikeTable == null) {
                return;
            }
            BasicLikeTable table = basicLikeTable;
            String tableName = this.currentScopeName(table);
            String string2 = constraint.getName();
            MsEnableDisableGenerator this_$iv = this;
            String constraintName = AbstractCodeGenerator.access$getNaming$p(this_$iv).nameToScript((String)$receiver$iv);
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, tableName, constraintActionWord, constraintName){
                final /* synthetic */ MsEnableDisableGenerator this$0;
                final /* synthetic */ String $tableName;
                final /* synthetic */ String $constraintActionWord;
                final /* synthetic */ String $constraintName;

                public final void invoke() {
                    this.this$0.getBuilder().phrase("alter table", this.$tableName, this.$constraintActionWord, "constraint", this.$constraintName);
                }
                {
                    this.this$0 = msEnableDisableGenerator;
                    this.$tableName = string;
                    this.$constraintActionWord = string2;
                    this.$constraintName = string3;
                    super(0);
                }
            }, 3, null);
        }

        @Override
        protected void generateEnableDisableForTrigger(@NotNull BasicTrigger trigger) {
            Intrinsics.checkParameterIsNotNull((Object)trigger, (String)"trigger");
            String triggerName = this.currentScopeName(trigger);
            Object object = trigger.getLikeTable();
            if (object == null || (object = this.currentScopeName((BasicElement)object)) == null) {
                return;
            }
            Object tableName = object;
            AbstractCodeGenerator.coding$default(this, null, false, (Function0)new Function0<Unit>(this, triggerName, (String)tableName){
                final /* synthetic */ MsEnableDisableGenerator this$0;
                final /* synthetic */ String $triggerName;
                final /* synthetic */ String $tableName;

                public final void invoke() {
                    this.this$0.getBuilder().phrase(this.this$0.getActionWord(), "trigger ", this.$triggerName, "on", this.$tableName);
                }
                {
                    this.this$0 = msEnableDisableGenerator;
                    this.$triggerName = string;
                    this.$tableName = string2;
                    super(0);
                }
            }, 3, null);
        }

        public MsEnableDisableGenerator(@NotNull ScriptingContext context, ScriptingTask task) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
            super(context, task);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/database/scripting/MsScriptingService$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "()V", "database-scripting"})
    public static final class VERSION
    extends PerObjectVersion {
        public static final VERSION INSTANCE;

        private VERSION() {
        }

        static {
            VERSION vERSION;
            INSTANCE = vERSION = new VERSION();
        }
    }
}

