/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.scripting.ScriptingHelper;
import com.intellij.database.scripting.SizeAndScale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/scripting/MysqlScriptingHelper;", "Lcom/intellij/database/scripting/ScriptingHelper;", "()V", "defaultPrimitiveSizes", "", "", "Lcom/intellij/database/scripting/SizeAndScale;", "getDefaultPrimitiveSizes", "()Ljava/util/Map;", "influencedByUnsigned", "", "isDefaultSize", "", "d", "Lcom/intellij/database/model/DataType;", "isNullExplicit", "column", "Lcom/intellij/database/model/basic/BasicLikeColumn;", "database-scripting"})
public final class MysqlScriptingHelper
extends ScriptingHelper {
    private static final Set<String> influencedByUnsigned;
    @NotNull
    private static final Map<String, SizeAndScale> defaultPrimitiveSizes;
    public static final MysqlScriptingHelper INSTANCE;

    @Override
    @NotNull
    public Map<String, SizeAndScale> getDefaultPrimitiveSizes() {
        return defaultPrimitiveSizes;
    }

    @Override
    public boolean isNullExplicit(@Nullable BasicLikeColumn column) {
        return true;
    }

    @Override
    protected boolean isDefaultSize(@NotNull DataType d) {
        Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
        String suffix = d.suffix;
        if (suffix != null && StringsKt.contains$default((CharSequence)suffix, (CharSequence)"unsigned", (boolean)false, (int)2, null) && influencedByUnsigned.contains(d.typeName)) {
            SizeAndScale defaults = this.getDefaultPrimitiveSizes().get(d.typeName);
            return defaults != null && d.size + 1 == defaults.getSize() && d.scale == defaults.getScale();
        }
        return super.isDefaultSize(d);
    }

    private MysqlScriptingHelper() {
        super(null);
    }

    static {
        MysqlScriptingHelper mysqlScriptingHelper;
        INSTANCE = mysqlScriptingHelper = new MysqlScriptingHelper();
        influencedByUnsigned = SetsKt.setOf((Object[])new String[]{"tinyint", "smallint", "mediumint", "int"});
        defaultPrimitiveSizes = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"char", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"boolean", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"bit", (Object)new SizeAndScale(1, 0, 2, null)), TuplesKt.to((Object)"tinyint", (Object)new SizeAndScale(4, 0, 2, null)), TuplesKt.to((Object)"smallint", (Object)new SizeAndScale(5, 0, 2, null)), TuplesKt.to((Object)"mediumint", (Object)new SizeAndScale(9, 0, 2, null)), TuplesKt.to((Object)"int", (Object)new SizeAndScale(11, 0, 2, null)), TuplesKt.to((Object)"bigint", (Object)new SizeAndScale(20, 0, 2, null)), TuplesKt.to((Object)"decimal", (Object)new SizeAndScale(10, 0, 2, null)), TuplesKt.to((Object)"year", (Object)new SizeAndScale(4, 0, 2, null))});
    }
}

