/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.postgres.psi.FunctionBodyInjector;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenType;
import com.intellij.sql.psi.impl.lexer.SqlPreprocessingLexer;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlDeepSyntaxHighlighter
extends SqlSyntaxHighlighter {
    private final Map<Language, SyntaxHighlighter> myHighlighters = ConcurrentFactoryMap.createMap(l -> SyntaxHighlighterFactory.getSyntaxHighlighter((Language)l, (Project)this.getProject(), null));
    private final VirtualFile myFile;

    public SqlDeepSyntaxHighlighter(SqlLanguageDialect dialect, Project project, VirtualFile file) {
        super(dialect, project, file);
        this.myFile = file;
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((VirtualFile)this.myFile);
        Language hostLanguage = SqlPreprocessingLexer.getHostLanguage((PsiElement)host);
        MyLayeredLexer myLayeredLexer = new MyLayeredLexer(hostLanguage, new LayersCache());
        if (myLayeredLexer == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return myLayeredLexer;
    }

    protected abstract Lexer createBaseLexer();

    protected IElementType getInjectionToken() {
        return SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN;
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (tokenType instanceof SqlTokenType.SqlInjectionMark) {
            TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(this.getInjectionToken());
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        if (tokenType != null && !(tokenType.getLanguage() instanceof SqlLanguageDialect) && tokenType.getLanguage() != SqlLanguage.INSTANCE && tokenType.getLanguage() != Language.ANY) {
            SyntaxHighlighter highlighter = this.myHighlighters.get(tokenType.getLanguage());
            TextAttributesKey[] textAttributesKeyArray = highlighter == null ? SqlDeepSyntaxHighlighter.pack(null) : highlighter.getTokenHighlights(tokenType);
            if (textAttributesKeyArray == null) {
                SqlDeepSyntaxHighlighter.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            SqlDeepSyntaxHighlighter.$$$reportNull$$$0(3);
        }
        return textAttributesKeyArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/sql/highlighting/SqlDeepSyntaxHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class MyLayeredLexer
    extends SqlSyntaxHighlighter.MyLayeredLexer {
        private final LayersCache myCache;

        public MyLayeredLexer(Language hostLanguage, LayersCache cache) {
            super(SqlPreprocessingLexer.withPreprocessingIfNeeded(SqlDeepSyntaxHighlighter.this.createBaseLexer(), (Language)SqlDeepSyntaxHighlighter.this.getDialect(), hostLanguage, DatabaseSettings.getSettings()), SqlDeepSyntaxHighlighter.this.getDialect().getDatabaseDialect());
            this.myCache = cache;
        }

        @Nullable
        protected Lexer findLayerLexer(IElementType baseTokenType) {
            if (baseTokenType instanceof SqlTokenType.SqlInjectionMark) {
                String injection = ((SqlTokenType.SqlInjectionMark)baseTokenType).getInjection();
                if (injection.equals("sql") || injection.equals("pgsql")) {
                    return (Lexer)this.myCache.recursiveLexers.get((Object)this);
                }
                return this.myCache.terminalLexers.get(injection);
            }
            return null;
        }
    }

    private class LayersCache {
        Map<String, Lexer> terminalLexers = FactoryMap.create(inj -> {
            Pair<Language, String> spec = FunctionBodyInjector.getBlockByLangSpec(inj);
            if (spec == null || spec.first == null) {
                return null;
            }
            LightVirtualFile file = spec.second == null ? null : new LightVirtualFile("inj." + (String)spec.second, (Language)spec.first, (CharSequence)"");
            return SyntaxHighlighterFactory.getSyntaxHighlighter((Language)((Language)spec.first), (Project)SqlDeepSyntaxHighlighter.this.getProject(), (VirtualFile)file).getHighlightingLexer();
        });
        Map<MyLayeredLexer, MyLayeredLexer> recursiveLexers = FactoryMap.create(l -> new MyLayeredLexer((Language)SqlDeepSyntaxHighlighter.this.getDialect(), ((MyLayeredLexer)l).myCache));

        private LayersCache() {
        }
    }
}

