/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.db2.Db2Dialect;
import com.intellij.sql.dialects.derby.DerbyDialect;
import com.intellij.sql.dialects.exasol.ExasolDialect;
import com.intellij.sql.dialects.exasol.ExasolInjectionIdentifyingLexer;
import com.intellij.sql.dialects.generic.GenericDialect;
import com.intellij.sql.dialects.h2.H2Dialect;
import com.intellij.sql.dialects.hsqldb.HsqldbDialect;
import com.intellij.sql.dialects.mssql.MssqlDialect;
import com.intellij.sql.dialects.mysql.MysqlDialect;
import com.intellij.sql.dialects.oracle.OracleDialect;
import com.intellij.sql.dialects.oracle.plus.OrapDialect;
import com.intellij.sql.dialects.postgres.PostgresDialect;
import com.intellij.sql.dialects.postgres.PostgresInjectionIdentifyingLexer;
import com.intellij.sql.dialects.redshift.RedshiftDialect;
import com.intellij.sql.dialects.redshift.RedshiftInjectionIdentifyingLexer;
import com.intellij.sql.dialects.sql92.Sql92Dialect;
import com.intellij.sql.dialects.sqlite.SqliteDialect;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.highlighting.SqlDeepSyntaxHighlighter;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project, @Nullable VirtualFile file) {
        SqlLanguageDialect dialect = this.getDialect(project, file);
        if (dialect == PostgresDialect.INSTANCE) {
            SqlDeepSyntaxHighlighter sqlDeepSyntaxHighlighter = new SqlDeepSyntaxHighlighter(dialect, project, file){

                @Override
                protected Lexer createBaseLexer() {
                    return new PostgresInjectionIdentifyingLexer();
                }
            };
            if (sqlDeepSyntaxHighlighter == null) {
                SqlSyntaxHighlighterFactory.$$$reportNull$$$0(0);
            }
            return sqlDeepSyntaxHighlighter;
        }
        if (dialect == RedshiftDialect.INSTANCE) {
            SqlDeepSyntaxHighlighter sqlDeepSyntaxHighlighter = new SqlDeepSyntaxHighlighter(dialect, project, file){

                @Override
                protected Lexer createBaseLexer() {
                    return new RedshiftInjectionIdentifyingLexer();
                }
            };
            if (sqlDeepSyntaxHighlighter == null) {
                SqlSyntaxHighlighterFactory.$$$reportNull$$$0(1);
            }
            return sqlDeepSyntaxHighlighter;
        }
        if (dialect == ExasolDialect.INSTANCE) {
            SqlDeepSyntaxHighlighter sqlDeepSyntaxHighlighter = new SqlDeepSyntaxHighlighter(dialect, project, file){

                @Override
                protected Lexer createBaseLexer() {
                    return new ExasolInjectionIdentifyingLexer();
                }

                @Override
                protected IElementType getInjectionToken() {
                    return SqlTokens.SQL_RAW_INPUT;
                }
            };
            if (sqlDeepSyntaxHighlighter == null) {
                SqlSyntaxHighlighterFactory.$$$reportNull$$$0(2);
            }
            return sqlDeepSyntaxHighlighter;
        }
        SqlSyntaxHighlighter sqlSyntaxHighlighter = new SqlSyntaxHighlighter(dialect, project, file);
        if (sqlSyntaxHighlighter == null) {
            SqlSyntaxHighlighterFactory.$$$reportNull$$$0(3);
        }
        return sqlSyntaxHighlighter;
    }

    protected SqlLanguageDialect getDialect(@Nullable Project project, @Nullable VirtualFile file) {
        return SqlLanguageSubstitutor.getSqlLanguageDialect(file, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/highlighting/SqlSyntaxHighlighterFactory", "getSyntaxHighlighter"));
    }

    static class Base
    extends SqlSyntaxHighlighterFactory {
        final SqlLanguageDialect dialect;

        public Base(SqlLanguageDialect dialect) {
            this.dialect = dialect;
        }

        @Override
        protected SqlLanguageDialect getDialect(@Nullable Project project, @Nullable VirtualFile file) {
            return this.dialect;
        }
    }

    public static class Exasol
    extends Base {
        public Exasol() {
            super(ExasolDialect.INSTANCE);
        }
    }

    public static class Sybase
    extends Base {
        public Sybase() {
            super(SybaseDialect.INSTANCE);
        }
    }

    public static class Db2
    extends Base {
        public Db2() {
            super(Db2Dialect.INSTANCE);
        }
    }

    public static class H2
    extends Base {
        public H2() {
            super(H2Dialect.INSTANCE);
        }
    }

    public static class Mssql
    extends Base {
        public Mssql() {
            super(MssqlDialect.INSTANCE);
        }
    }

    public static class Hsqldb
    extends Base {
        public Hsqldb() {
            super(HsqldbDialect.INSTANCE);
        }
    }

    public static class Redshift
    extends Base {
        public Redshift() {
            super(RedshiftDialect.INSTANCE);
        }
    }

    public static class Postgres
    extends Base {
        public Postgres() {
            super(PostgresDialect.INSTANCE);
        }
    }

    public static class Derby
    extends Base {
        public Derby() {
            super(DerbyDialect.INSTANCE);
        }
    }

    public static class Orap
    extends Base {
        public Orap() {
            super(OrapDialect.INSTANCE);
        }
    }

    public static class Oracle
    extends Base {
        public Oracle() {
            super(OracleDialect.INSTANCE);
        }
    }

    public static class Sqlite
    extends Base {
        public Sqlite() {
            super(SqliteDialect.INSTANCE);
        }
    }

    public static class Mysql
    extends Base {
        public Mysql() {
            super(MysqlDialect.INSTANCE);
        }
    }

    public static class Generic
    extends Base {
        public Generic() {
            super(GenericDialect.INSTANCE);
        }
    }

    public static class Sql92
    extends Base {
        public Sql92() {
            super(Sql92Dialect.INSTANCE);
        }
    }
}

