/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.j2meplugin.J2MEBundle;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.EmulatorType;
import com.intellij.j2meplugin.emulator.MobileSdk;
import com.intellij.j2meplugin.module.J2MEModuleExtension;
import com.intellij.j2meplugin.module.J2MEModuleProperties;
import com.intellij.j2meplugin.module.J2MEModuleType;
import com.intellij.j2meplugin.module.MobileModuleUtil;
import com.intellij.j2meplugin.module.settings.MobileApplicationType;
import com.intellij.j2meplugin.module.settings.MobileModuleSettings;
import com.intellij.j2meplugin.module.settings.midp.MIDPApplicationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class J2MEModuleBuilder
extends JavaModuleBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2meplugin");
    private String explodedDirPath;
    private boolean excludeFromContent = false;
    private String resourcesDirPath;
    private MobileApplicationType myMobileApplicationType;
    private MobileModuleSettings myMobileModuleSettings;
    private boolean myDefaultRDirectoryModified = false;
    private boolean myDefaultEDirectoryModified = false;

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        super.setupRootModel(rootModel);
        if (this.explodedDirPath != null) {
            String canonicalPath;
            this.createRoot(rootModel, this.explodedDirPath, J2MEBundle.message("exploded.directory.create.command", new Object[0]));
            try {
                canonicalPath = this.explodedDirPath != null && this.explodedDirPath.isEmpty() ? null : new File(this.explodedDirPath).getCanonicalPath();
            }
            catch (IOException e) {
                canonicalPath = this.explodedDirPath;
            }
            String url = canonicalPath == null ? null : VirtualFileManager.constructUrl((String)"file", (String)canonicalPath.replace(File.separatorChar, '/'));
            J2MEModuleExtension extension = (J2MEModuleExtension)((Object)rootModel.getModuleExtension(J2MEModuleExtension.class));
            extension.setExplodedDirectory(url);
            extension.setExcludeExplodedDirectory(this.excludeFromContent);
        }
        if (this.resourcesDirPath != null) {
            String path = FileUtil.toSystemIndependentName((String)this.resourcesDirPath);
            this.createRoot(rootModel, path, J2MEBundle.message("resource.directory.create.command", new Object[0]));
            ApplicationManager.getApplication().runReadAction(() -> {
                VirtualFile contentRootFile;
                File parentDir = new File(path).getParentFile();
                if (parentDir != null && (contentRootFile = LocalFileSystem.getInstance().findFileByIoFile(parentDir)) != null) {
                    ContentEntry contentEntry = rootModel.addContentEntry(contentRootFile);
                    for (int i = 0; i < rootModel.getContentEntries().length; ++i) {
                        VirtualFile virtualFile = rootModel.getContentEntries()[i].getFile();
                        if (virtualFile == null || !path.startsWith(virtualFile.getPath())) continue;
                        contentEntry = rootModel.getContentEntries()[i];
                    }
                    VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                    LOG.assertTrue(fileByPath != null);
                    contentEntry.addSourceFolder(fileByPath, false);
                    J2MEModuleProperties.getInstance(rootModel.getModule()).setResourcePath(this.resourcesDirPath);
                }
            });
        }
        Module module = rootModel.getModule();
        ApplicationManager.getApplication().runReadAction(() -> {
            J2MEModuleProperties.getInstance(module).setMobileApplicationType(this.getMobileApplicationType());
            this.getMobileModuleSettings().copyTo(MobileModuleSettings.getInstance(module));
        });
        ((LanguageLevelModuleExtension)rootModel.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevel.JDK_1_4);
    }

    private void createRoot(ModifiableRootModel rootModel, String path, String commandName) {
        path = FileUtil.toSystemIndependentName((String)path);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null) {
            final File ioFile = new File(path);
            CommandProcessor.getInstance().executeCommand(rootModel.getModule().getProject(), new Runnable(){

                @Override
                public void run() {
                    LocalFileSystem lfs;
                    VirtualFile dir;
                    FileUtil.createParentDirs((File)ioFile);
                    File parentDir = ioFile.getParentFile();
                    if (parentDir != null && (dir = (lfs = LocalFileSystem.getInstance()).refreshAndFindFileByIoFile(parentDir)) != null) {
                        try {
                            dir.createChildDirectory((Object)this, ioFile.getName());
                        }
                        catch (IOException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }, commandName, null);
        }
    }

    public String getExplodedDirPath() {
        return this.explodedDirPath;
    }

    public void setExplodedDirPath(String explodedDirPath) {
        this.explodedDirPath = explodedDirPath;
    }

    public String getResourcesDirPath() {
        return this.resourcesDirPath;
    }

    public void setResourcesDirPath(String resourcesDirPath) {
        this.resourcesDirPath = resourcesDirPath;
    }

    public MobileApplicationType getMobileApplicationType() {
        if (this.myMobileApplicationType == null) {
            MobileApplicationType applicationType = this.getCurrentApplicationType();
            if (applicationType == null) {
                return MIDPApplicationType.getInstance();
            }
            this.myMobileApplicationType = applicationType;
        }
        return this.myMobileApplicationType;
    }

    @Nullable
    private MobileApplicationType getCurrentApplicationType() {
        SdkAdditionalData data;
        Sdk projectJdk = this.getModuleJdk();
        if (projectJdk != null && (data = projectJdk.getSdkAdditionalData()) instanceof Emulator) {
            EmulatorType emulatorType = ((Emulator)data).getEmulatorType();
            LOG.assertTrue(emulatorType != null);
            return MobileModuleUtil.getMobileApplicationTypeByName(emulatorType.getApplicationType());
        }
        return null;
    }

    public void setMobileApplicationType(MobileApplicationType mobileApplicationType) {
        this.myMobileApplicationType = mobileApplicationType;
    }

    public MobileModuleSettings getMobileModuleSettings() {
        if (this.myMobileModuleSettings == null) {
            if (this.myMobileApplicationType != null) {
                this.myMobileModuleSettings = this.myMobileApplicationType.createTempSettings(this);
            } else {
                return this.getMobileApplicationType().createTempSettings(this);
            }
        }
        return this.myMobileModuleSettings;
    }

    public void setMobileModuleSettings(MobileModuleSettings mobileModuleSettings) {
        this.myMobileModuleSettings = mobileModuleSettings;
    }

    public boolean isExcludeFromContent() {
        return this.excludeFromContent;
    }

    public void setExcludeFromContent(boolean excludeFromContent) {
        this.excludeFromContent = excludeFromContent;
    }

    public ModuleType getModuleType() {
        return J2MEModuleType.getInstance();
    }

    public String getParentGroup() {
        return "Java";
    }

    public boolean isDefaultRDirectoryModified() {
        return this.myDefaultRDirectoryModified;
    }

    public void setDefaultRDirectoryModified(boolean defaultRDirectoryModified) {
        this.myDefaultRDirectoryModified = defaultRDirectoryModified;
    }

    public boolean isDefaultEDirectoryModified() {
        return this.myDefaultEDirectoryModified;
    }

    public void setDefaultEDirectoryModified(boolean defaultEDirectoryModified) {
        this.myDefaultEDirectoryModified = defaultEDirectoryModified;
    }

    public void setModuleJdk(Sdk jdk) {
        super.setModuleJdk(jdk);
        MobileApplicationType currentApplicationType = this.getCurrentApplicationType();
        if (currentApplicationType != this.myMobileApplicationType) {
            this.myMobileApplicationType = currentApplicationType;
            this.myMobileModuleSettings = null;
        }
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == MobileSdk.getInstance();
    }

    public int getWeight() {
        return 60;
    }

    public ModuleWizardStep modifyProjectTypeStep(@NotNull SettingsStep settingsStep) {
        if (settingsStep == null) {
            J2MEModuleBuilder.$$$reportNull$$$0(0);
        }
        return StdModuleTypes.JAVA.modifyProjectTypeStep(settingsStep, (ModuleBuilder)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/j2meplugin/module/J2MEModuleBuilder", "modifyProjectTypeStep"));
    }
}

