/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.references;

import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.gwt.uiBinder.GwtUiXmlFileUtil;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class GwtUiFieldReferenceBase<T extends PsiElement>
extends PsiPolyVariantReferenceBase<T> {
    private final boolean mySearchInXml;

    public GwtUiFieldReferenceBase(T element, boolean searchInXml) {
        super(element, true);
        this.mySearchInXml = searchInXml;
    }

    protected abstract String getFieldName();

    @NotNull
    protected abstract List<PsiClass> findUiBinderClasses();

    @NotNull
    protected abstract List<XmlFile> findUiXmlFiles();

    @NotNull
    public Object[] getVariants() {
        List<PsiClass> psiClasses = this.findUiBinderClasses();
        LinkedHashMap<String, LookupElementBuilder> lookupElements = new LinkedHashMap<String, LookupElementBuilder>();
        for (PsiClass psiClass : psiClasses) {
            for (PsiField field : psiClass.getAllFields()) {
                if (!UiBinderUtil.isUiField(field)) continue;
                lookupElements.put(field.getName(), JavaLookupElementBuilder.forField((PsiField)field));
            }
        }
        if (this.mySearchInXml) {
            for (XmlFile xmlFile : this.findUiXmlFiles()) {
                MultiValuesMap<String, XmlAttributeValue> fields = GwtUiXmlFileUtil.getFieldNameToAttributeMap(xmlFile);
                if (fields == null) continue;
                for (String fieldName : fields.keySet()) {
                    XmlAttributeValue attributeValue = (XmlAttributeValue)fields.getFirst((Object)fieldName);
                    XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)attributeValue, XmlTag.class);
                    if (lookupElements.containsKey(fieldName) || tag == null) continue;
                    lookupElements.put(fieldName, LookupElementBuilder.create((Object)tag, (String)fieldName));
                }
            }
        }
        Object[] objectArray = lookupElements.values().toArray(new LookupElementBuilder[lookupElements.size()]);
        if (objectArray == null) {
            GwtUiFieldReferenceBase.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        SmartList result = new SmartList();
        String value = this.getFieldName();
        for (PsiClass psiClass : this.findUiBinderClasses()) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)psiClass.findFieldByName(value, true));
        }
        if (result.isEmpty() && this.mySearchInXml) {
            for (XmlFile xmlFile : this.findUiXmlFiles()) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)GwtUiXmlFileUtil.findTagForField(xmlFile, value));
            }
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)result);
        if (resolveResultArray == null) {
            GwtUiFieldReferenceBase.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/gwt/uiBinder/references/GwtUiFieldReferenceBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

