/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.editor;

import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorTabTitleProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class TraceEditorTabTitleProvider
implements EditorTabTitleProvider {
    @Nullable
    public String getEditorTabTitle(Project project, VirtualFile file) {
        if (!(file instanceof TraceVirtualFile)) {
            return null;
        }
        TraceVirtualFile traceFile = (TraceVirtualFile)file;
        if (traceFile.getProjectFile() == null) {
            return file.getPresentableName();
        }
        String generatedTitle = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, file);
        if (!generatedTitle.endsWith(" trace")) {
            generatedTitle = generatedTitle + " trace";
        }
        return generatedTitle;
    }
}

