/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.code.StaticFuncStart;
import com.intellij.javascript.trace.execution.code.StaticFunctionParameter;
import org.jetbrains.annotations.NotNull;

public class RuntimeFunctionArgument
implements CodeElement {
    private Object myValue;
    private String myName;
    private CodeRange myRange;
    private StaticFuncStart myParent;
    private final boolean hasRange;

    public RuntimeFunctionArgument(int position, StaticFunctionParameter parameter, Object value, StaticFuncStart parent) {
        this.myParent = parent;
        this.myValue = value;
        if (parameter != null) {
            this.myRange = parameter.getRange();
            this.myName = parameter.getName();
            this.hasRange = true;
        } else {
            this.myName = String.valueOf(position);
            this.hasRange = false;
        }
    }

    public String getName() {
        return this.myName;
    }

    public Object getValue() {
        return this.myValue;
    }

    @Override
    @NotNull
    public CodeRange getCodeRange() {
        CodeRange codeRange = this.myRange;
        if (codeRange == null) {
            RuntimeFunctionArgument.$$$reportNull$$$0(0);
        }
        return codeRange;
    }

    @Override
    @NotNull
    public String getFile() {
        String string = this.myParent.getFile();
        if (string == null) {
            RuntimeFunctionArgument.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFunc() {
        String string = this.myParent.getFunc();
        if (string == null) {
            RuntimeFunctionArgument.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean hasRange() {
        return this.hasRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javascript/trace/execution/common/RuntimeFunctionArgument";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunc";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

