/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.systemProxy;

import com.intellij.execution.ExecutionException;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.systemProxy.LinuxProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.MacProxyConfigurator;
import com.intellij.javascript.trace.execution.systemProxy.ProxySettings;
import com.intellij.javascript.trace.execution.systemProxy.WinProxyConfigurator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public abstract class ProxyConfigurator {
    private static final ProxyConfigurator ourInstance = SystemInfo.isMac ? new MacProxyConfigurator() : (SystemInfo.isWindows ? new WinProxyConfigurator() : (SystemInfo.isLinux ? new LinuxProxyConfigurator() : new ProxyConfigurator(){

        @Override
        @NotNull
        protected ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings newSettings) throws ExecutionException {
            if (newSettings == null) {
                1.$$$reportNull$$$0(0);
            }
            ProxySettings proxySettings = newSettings;
            if (proxySettings == null) {
                1.$$$reportNull$$$0(1);
            }
            return proxySettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "updateSettingsReturnExisting";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "updateSettingsReturnExisting";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }));
    private static final Logger LOG = Logger.getInstance(ProxyConfigurator.class);
    private ProxySettings mySettings;
    private Integer myPort;
    private int startRequestCount = 0;

    public static ProxyConfigurator getInstance() {
        return ourInstance;
    }

    public synchronized void requestStart(int port) {
        if (this.myPort == null) {
            try {
                this.mySettings = this.updateSettingsReturnExisting(new ProxySettings(port));
                this.myPort = port;
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.myPort != null && this.myPort == port) {
            ++this.startRequestCount;
        }
    }

    public synchronized void requestStop(int port) {
        if (this.myPort != null && this.myPort == port) {
            --this.startRequestCount;
            if (this.startRequestCount == 0) {
                try {
                    this.updateSettingsReturnExisting(this.mySettings);
                }
                catch (ExecutionException e) {
                    LOG.error((Throwable)e);
                }
                this.myPort = null;
            }
        }
    }

    @NotNull
    protected abstract ProxySettings updateSettingsReturnExisting(@NotNull ProxySettings var1) throws ExecutionException;

    protected String getScriptPath(@NotNull String scriptName) {
        if (scriptName == null) {
            ProxyConfigurator.$$$reportNull$$$0(0);
        }
        return Utils.getServerScriptPath(scriptName, StringUtil.isEmpty((String)System.getenv("DEBUG_SPY_JS")));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptName", "com/intellij/javascript/trace/execution/systemProxy/ProxyConfigurator", "getScriptPath"));
    }
}

