/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableConstants;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.NodeVisitor;
import com.intellij.dsm.ui.RowAnnotation;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Map;
import javax.swing.Icon;

class PaintRowHeaderVisitor<N>
implements NodeVisitor<N> {
    private final Graphics2D g;
    private final DsmTableImpl<N> myDsmTable;

    public PaintRowHeaderVisitor(DsmTableImpl<N> dsmTable, Graphics2D g) {
        this.myDsmTable = dsmTable;
        this.g = g;
    }

    @Override
    public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
        this.visitRow(node, x, y, height, isFirst, isLast, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
        boolean superSmall = this.myDsmTable.isSuperSmall();
        boolean small = this.myDsmTable.isSmall();
        Rectangle oldClipBounds = this.g.getClipBounds();
        Color bg = this.myDsmTable.getHeaderBg(node);
        Color fg = this.myDsmTable.getForeground();
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        if (!oldClipBounds.intersects(r)) {
            return;
        }
        this.g.setClip(new Rectangle(r.x, r.y, r.width + 1, r.height + 1).intersection(oldClipBounds));
        try {
            this.g.setPaint(bg);
            this.g.fill(r);
            if (!superSmall) {
                this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
                this.g.draw(r);
            }
            if (superSmall) {
                return;
            }
            AffineTransform tr = this.g.getTransform();
            this.g.translate(r.x, r.y + r.width);
            this.g.rotate(1.5707963267948966);
            PaintRowHeaderVisitor.paintRowIcon(node, 0, -r.width, r.width, this.myDsmTable, this.g);
            UISettings.setupAntialiasing((Graphics)this.g);
            this.g.setPaint(this.myDsmTable.getHeaderFg(node));
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int baseline = (r.width - fontMetrics.getHeight()) / 2 + fontMetrics.getDescent();
            String shortName = node.getShortName();
            this.g.drawString(shortName, r.width, -baseline);
            this.g.setTransform(tr);
            if (!small) {
                Icon icon = this.myDsmTable.myIconCache.getIcon(AllIcons.Nodes.CollapseNode, r.width);
                int iconX = x + (r.width - icon.getIconWidth()) / 2;
                int iconY = y + (r.width - icon.getIconHeight()) / 2;
                int iconXc = iconX - icon.getIconWidth() / 2;
                int iconYc = iconY + icon.getIconHeight() / 2;
                int iconX2 = iconX + icon.getIconWidth();
                icon.paintIcon(this.myDsmTable, this.g, iconX, iconY);
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)(iconX2 + 1), (int)iconYc, (int)(iconX + r.width), (int)iconYc, (Color)bg, (Color)fg);
                if (!isLast) {
                    int stringWidth = fontMetrics.stringWidth(shortName);
                    int textY2 = r.y + stringWidth + r.width + r.width;
                    UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(textY2 + 5), (int)iconXc, (int)(iconY + height), (Color)bg, (Color)fg);
                }
            }
        }
        finally {
            this.g.setClip(oldClipBounds);
        }
    }

    @Override
    public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
        this.visitRow(node, x, y, height, isFirst, last, true);
    }

    private void visitRow(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast, boolean paintIcon) {
        Rectangle r = this.myDsmTable.myCache.rowHeaderBounds.get(node);
        assert (r != null) : "Null bounds for: " + node;
        Rectangle clipBounds = this.g.getClipBounds();
        if (!clipBounds.intersects(r)) {
            return;
        }
        Color bg = this.myDsmTable.getHeaderBg(node);
        Color fg = this.myDsmTable.getForeground();
        this.g.setPaint(bg);
        this.g.fill(r);
        boolean small = this.myDsmTable.isSmall();
        boolean superSmall = this.myDsmTable.isSuperSmall();
        Map<DsmTreeStructure.TreeNode, RowAnnotation> rowAnnotations = this.myDsmTable.myRowAnnotations;
        if (rowAnnotations.containsKey(node)) {
            Color c;
            RowAnnotation rowAnnotation = rowAnnotations.get(node);
            switch (rowAnnotation) {
                default: {
                    assert (false);
                }
                case BCK_DEP: {
                    c = DsmTableConstants.COLOR_FWD_DEP;
                    break;
                }
                case FWD_DEP: {
                    c = DsmTableConstants.COLOR_BCK_DEP;
                    break;
                }
                case CYCLE_DEP: {
                    c = DsmTableConstants.COLOR_CYCLE;
                }
            }
            this.g.setPaint(c);
            int annotationWidth = Math.max(r.height / 2, 5);
            this.g.fillRect(r.x + r.width - annotationWidth, r.y, annotationWidth, r.height);
            this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
            if (!superSmall) {
                this.g.drawRect(r.x + r.width - annotationWidth, r.y, annotationWidth, r.height);
            }
        }
        this.g.setPaint(DsmTableConstants.COLOR_GRID_COLOR);
        if (!superSmall) {
            this.g.draw(r);
        }
        if (!superSmall) {
            Icon icon = this.myDsmTable.myIconCache.getIcon(AllIcons.Nodes.ExpandNode, height);
            int iconX = x + (r.height - icon.getIconWidth()) / 2;
            int iconY = y + (height - icon.getIconHeight()) / 2;
            int iconXc = iconX + icon.getIconWidth() / 2;
            int iconYc = iconY + icon.getIconHeight() / 2;
            int iconX2 = iconX + icon.getIconWidth();
            int iconY2 = iconY + icon.getIconHeight();
            if (!small) {
                if (paintIcon) {
                    icon.paintIcon(this.myDsmTable, this.g, iconX, iconY);
                } else {
                    UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(isFirst ? iconYc + 1 : iconY), (int)iconXc, (int)(isLast ? iconYc : iconY2), (Color)bg, (Color)fg);
                    UIUtil.drawDottedLine((Graphics2D)this.g, (int)(iconXc + 2), (int)iconYc, (int)iconX2, (int)iconYc, (Color)bg, (Color)fg);
                    if (isFirst) {
                        UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconX, (int)iconYc, (int)(iconXc - 1), (int)iconYc, (Color)bg, (Color)fg);
                    }
                }
            }
            this.g.setPaint(this.myDsmTable.getHeaderFg(node));
            UISettings.setupAntialiasing((Graphics)this.g);
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int baseline = fontMetrics.getAscent() + (r.height - fontMetrics.getHeight()) / 2;
            this.g.drawString(node.getShortName(), r.x + height + height, r.y + baseline);
            PaintRowHeaderVisitor.paintRowIcon(node, r.x + height - 2, y, height, this.myDsmTable, this.g);
            if (!isLast) {
                UIUtil.drawDottedLine((Graphics2D)this.g, (int)iconXc, (int)(iconY2 + 1), (int)iconXc, (int)(iconY + r.height), (Color)bg, (Color)fg);
            }
        }
    }

    static <N> void paintRowIcon(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, DsmTableImpl<N> dsmTable, Graphics2D g) {
        Icon nodeIcon = node.getIcon();
        if (nodeIcon != null) {
            Icon icon = dsmTable.myIconCache.getIcon(nodeIcon, height);
            icon.paintIcon(dsmTable, g, x, y + (height - icon.getIconHeight()) / 2);
        }
    }
}

