/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFix
implements IntentionAction {
    @NotNull
    public String getFamilyName() {
        String name = this.getClass().getSimpleName();
        String string = "XSLT " + name.replaceAll("Fix$", "").replaceAll("(\\p{Lower}+)(\\p{Upper})", "$1 $2");
        if (string == null) {
            AbstractFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return true;
    }

    protected static void moveTo(Editor editor, XmlTag xmlTag) {
        editor.getCaretModel().moveToOffset(xmlTag.getTextRange().getStartOffset());
    }

    protected static TemplateBuilderImpl createTemplateBuilder(XmlTag xmlTag) {
        PsiFile psiFile = PsiFileFactory.getInstance((Project)xmlTag.getProject()).createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)xmlTag.getText(), LocalTimeCounter.currentTime(), true, false);
        return new TemplateBuilderImpl((PsiElement)psiFile);
    }

    public final boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AbstractFix.$$$reportNull$$$0(1);
        }
        if (this.requiresEditor() && editor == null) {
            return false;
        }
        return this.isAvailableImpl(project, editor, file);
    }

    protected abstract boolean isAvailableImpl(@NotNull Project var1, @Nullable Editor var2, PsiFile var3);

    protected abstract boolean requiresEditor();

    @Nullable
    public LocalQuickFix createQuickFix(boolean isOnTheFly) {
        final boolean requiresEditor = this.requiresEditor();
        if (requiresEditor && !isOnTheFly) {
            return null;
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = AbstractFix.this.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = AbstractFix.this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiFile psiFile;
                Editor editor;
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (requiresEditor) {
                    DataContext dataContext = DataManager.getInstance().getDataContext();
                    editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
                    if (editor == null && (editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor()) == null) {
                        return;
                    }
                } else {
                    editor = null;
                }
                if (!AbstractFix.this.isAvailable(project, editor, psiFile = descriptor.getPsiElement().getContainingFile())) {
                    return;
                }
                AbstractFix.this.invoke(project, editor, psiFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static LocalQuickFix[] createFixes(LocalQuickFix ... fixes) {
        List result = ContainerUtil.findAll((Object[])fixes, localQuickFix -> localQuickFix != null);
        return result.toArray(new LocalQuickFix[result.size()]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/AbstractFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

