/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.gradle;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.gradle.service.project.AbstractProjectResolverExtension;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.grails.gradle.GrailsModuleData;
import org.jetbrains.plugins.grails.gradle.tooling.builder.GrailsModule;
import org.jetbrains.plugins.grails.gradle.tooling.builder.GrailsModuleModelBuilderImpl;

@Order(value=1000)
public class GrailsProjectResolverExtension
extends AbstractProjectResolverExtension {
    private static final Logger LOG = Logger.getInstance(GrailsProjectResolverExtension.class);
    private static final String GRAILS_TASK_PREFIX = "grails-";

    public void populateModuleExtraModels(@NotNull IdeaModule gradleModule, @NotNull DataNode<ModuleData> ideModule) {
        GrailsModule grailsModule;
        if (gradleModule == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(0);
        }
        if (ideModule == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(1);
        }
        if ((grailsModule = (GrailsModule)this.resolverCtx.getExtraProject(gradleModule, GrailsModule.class)) != null) {
            ideModule.createChild(GrailsModuleData.KEY, (Object)new GrailsModuleData(GradleConstants.SYSTEM_ID, grailsModule.getGrailsVersion(), grailsModule.getGrailsPluginId(), grailsModule.getShellUrls()));
        }
        this.nextResolver.populateModuleExtraModels(gradleModule, ideModule);
    }

    @NotNull
    public Set<Class> getExtraProjectModelClasses() {
        Set<Class> set = Collections.singleton(GrailsModule.class);
        if (set == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<Class> getToolingExtensionsClasses() {
        Set set = ContainerUtil.set((Object[])new Class[]{GrailsModuleModelBuilderImpl.class, GrailsRtMarker.class});
        if (set == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(3);
        }
        return set;
    }

    public void enhanceRemoteProcessing(@NotNull SimpleJavaParameters parameters) throws ExecutionException {
        if (parameters == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(4);
        }
        parameters.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
    }

    public void enhanceTaskProcessing(@NotNull List<String> taskNames, @Nullable String jvmAgentSetup, @NotNull Consumer<String> initScriptConsumer) {
        String grailsTask;
        if (taskNames == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(5);
        }
        if (initScriptConsumer == null) {
            GrailsProjectResolverExtension.$$$reportNull$$$0(6);
        }
        if ((grailsTask = (String)ContainerUtil.find(taskNames, taskName -> taskName != null && StringUtil.startsWith((CharSequence)taskName, (CharSequence)GRAILS_TASK_PREFIX))) == null) {
            return;
        }
        if (taskNames.contains("grails-test-app")) {
            String grailsRtPath = PathUtil.getCanonicalPath((String)PathUtil.getJarPathForClass(GrailsRtMarker.class));
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task.hasProperty('group') && 'grails'.equals(task?.group)) {", "       if (task.hasProperty('command') && task?.command.equals('test-app')) {", "           task.runtimeClasspath += files(\"" + grailsRtPath + "\")", "           task.jvmOptions.jvmArgs('-Dgrails.build.listeners=org.jetbrains.groovy.grails.rt.GrailsIdeaTestListener')", "       }    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
        if (!StringUtil.isEmpty((String)jvmAgentSetup)) {
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task.hasProperty('group') && 'grails'.equals(task?.group)) {", "        if (task.hasProperty('jvmOptions') && task?.jvmOptions instanceof JavaForkOptions) {", "            task.jvmOptions.jvmArgs = ['" + jvmAgentSetup.trim() + "' , *task.jvmOptions.jvmArgs]", "       }    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initScriptConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/gradle/GrailsProjectResolverExtension";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraProjectModelClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolingExtensionsClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "populateModuleExtraModels";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enhanceRemoteProcessing";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "enhanceTaskProcessing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

