/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references;

import com.intellij.ProjectTopics;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.FindClassUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.groovy.grails.rt.GrailsRtMarker;
import org.jetbrains.plugins.grails.references.EnhancesTraitsCollector;
import org.jetbrains.plugins.grails.service.GrailsExecutorHolder;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsUtils;
import org.jetbrains.plugins.grails.util.SerializableStringMultiMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunConfiguration;

@State(name="TraitInjectorService", storages={@Storage(value="$WORKSPACE_FILE$")})
public class TraitInjectorService
implements PersistentStateComponent<PersistentState> {
    private static final Logger LOG = Logger.getInstance(TraitInjectorService.class);
    private static final String TRAIT_INJECTOR_FQN = "grails.compiler.traits.TraitInjector";
    private static final String MARKER = "--------------------------------------";
    private static final Map<GrailsArtifact, String> ARTEFACT_TO_NAME = ContainerUtil.newHashMap((Pair)Pair.create((Object)((Object)GrailsArtifact.DOMAIN), (Object)"Domain"), (Pair[])new Pair[]{Pair.create((Object)((Object)GrailsArtifact.CONTROLLER), (Object)"Controller"), Pair.create((Object)((Object)GrailsArtifact.SERVICE), (Object)"Service"), Pair.create((Object)((Object)GrailsArtifact.INTERCEPTOR), (Object)"Interceptor"), Pair.create((Object)((Object)GrailsArtifact.TAGLIB), (Object)"TagLibrary")});
    private final AtomicReference<Map<String, StateHolder>> myMapRef = new AtomicReference<HashMap>(ContainerUtil.newHashMap());
    private final Project myProject;
    private final DumbService myDumbService;
    private volatile ProgressIndicator myIndicator;

    public TraitInjectorService(Project project, DumbService service) {
        this.myProject = project;
        this.myDumbService = service;
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                TraitInjectorService.this.cancelIndicator();
            }
        });
        project.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void modulesRenamed(@NotNull Project project, @NotNull List<Module> modules, @NotNull Function<Module, String> oldNameProvider) {
                HashMap newMap;
                Map existingMap;
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (modules == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (oldNameProvider == null) {
                    2.$$$reportNull$$$0(2);
                }
                TraitInjectorService.this.cancelIndicator();
                do {
                    existingMap = (Map)TraitInjectorService.this.myMapRef.get();
                    newMap = ContainerUtil.newHashMap((Map)existingMap);
                    for (Module module : modules) {
                        String oldName = (String)oldNameProvider.fun((Object)module);
                        StateHolder state = (StateHolder)newMap.remove(oldName);
                        if (state == null) continue;
                        newMap.put(module.getName(), state);
                    }
                } while (!TraitInjectorService.this.myMapRef.compareAndSet(existingMap, Collections.unmodifiableMap(newMap)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "modules";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "oldNameProvider";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService$2";
                objectArray[2] = "modulesRenamed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public static TraitInjectorService getInstance(@NotNull Project project) {
        if (project == null) {
            TraitInjectorService.$$$reportNull$$$0(0);
        }
        TraitInjectorService traitInjectorService = (TraitInjectorService)ObjectUtils.notNull((Object)ServiceManager.getService((Project)project, TraitInjectorService.class));
        if (traitInjectorService == null) {
            TraitInjectorService.$$$reportNull$$$0(1);
        }
        return traitInjectorService;
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull GrTypeDefinition clazz) {
        String artefactType;
        if (clazz == null) {
            TraitInjectorService.$$$reportNull$$$0(2);
        }
        if ((artefactType = ARTEFACT_TO_NAME.get((Object)GrailsUtils.calculateArtifactType((PsiClass)clazz))) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TraitInjectorService.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<String> collection = TraitInjectorService.getInjectedTraits((PsiElement)clazz, artefactType);
        if (collection == null) {
            TraitInjectorService.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getInjectedTraits(@NotNull PsiElement context, @NotNull String artefactType) {
        if (context == null) {
            TraitInjectorService.$$$reportNull$$$0(5);
        }
        if (artefactType == null) {
            TraitInjectorService.$$$reportNull$$$0(6);
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        result2.addAll(TraitInjectorService.doGetInjectedTraits(context, artefactType));
        result2.addAll(EnhancesTraitsCollector.doGetEnhancesTraits(context, artefactType));
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            TraitInjectorService.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<String> doGetInjectedTraits(@NotNull PsiElement context, @NotNull String artefactType) {
        Module module;
        if (context == null) {
            TraitInjectorService.$$$reportNull$$$0(8);
        }
        if (artefactType == null) {
            TraitInjectorService.$$$reportNull$$$0(9);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)context)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TraitInjectorService.$$$reportNull$$$0(10);
            }
            return list;
        }
        StateHolder state = TraitInjectorService.getInstance((Project)context.getProject()).myMapRef.get().get(module.getName());
        if (state == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                TraitInjectorService.$$$reportNull$$$0(11);
            }
            return list;
        }
        Collection collection = state.traits.get(artefactType);
        if (collection == null) {
            TraitInjectorService.$$$reportNull$$$0(12);
        }
        return collection;
    }

    public static void queueUpdate(@NotNull Project project) {
        if (project == null) {
            TraitInjectorService.$$$reportNull$$$0(13);
        }
        TraitInjectorService.getInstance(project).queueUpdate();
    }

    public void queueUpdate() {
        if (this.myProject.isDisposed()) {
            return;
        }
        LOG.trace(this.myProject + ": Update requested");
        if (this.myDumbService.isDumb()) {
            LOG.debug(this.myProject + ": Update not queued, project is dumb");
            this.myDumbService.runWhenSmart(this::queueUpdate);
            return;
        }
        this.cancelIndicator();
        ProgressIndicatorUtils.scheduleWithWriteActionPriority((Executor)GrailsExecutorHolder.ourExecutorService, (ReadTask)new ReadTask(){

            public void onCanceled(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                LOG.debug(TraitInjectorService.this.myProject + ": Update canceled");
                TraitInjectorService.this.queueUpdate();
            }

            public ReadTask.Continuation runBackgroundProcess(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                RunDataHolder dataHolder;
                if (indicator == null) {
                    3.$$$reportNull$$$0(1);
                }
                if ((dataHolder = (RunDataHolder)TraitInjectorService.this.myDumbService.runReadActionInSmartMode(() -> TraitInjectorService.this.createRunData())) != null && !dataHolder.dataList.isEmpty()) {
                    indicator.checkCanceled();
                    TraitInjectorService.this.scheduleRunData(dataHolder);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "indicator";
                objectArray2[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onCanceled";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runBackgroundProcess";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LOG.debug(this.myProject + ": Update queued");
    }

    private void cancelIndicator() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
            this.myIndicator = null;
            LOG.debug(this.myProject + ": Indicator cancelled");
        }
    }

    @Nullable
    protected RunDataHolder createRunData() {
        LOG.debug(this.myProject + ": Checking modules and creating run data");
        Collection modules = FindClassUtil.findModulesWithClass((Project)this.myProject, (String)TRAIT_INJECTOR_FQN);
        if (modules.isEmpty()) {
            LOG.debug(this.myProject + ": No modules with TraitInjector");
            return null;
        }
        Map<String, StateHolder> oldMap = this.myMapRef.get();
        HashMap newMap = ContainerUtil.newHashMap();
        ArrayList dataList = ContainerUtil.newArrayList();
        for (Module module : modules) {
            RunData data;
            String key = module.getName();
            StateHolder oldState = oldMap.get(key);
            try {
                data = this.checkIfModuleNeedsUpdate(oldState, module);
            }
            catch (CantRunException e) {
                LOG.debug((Throwable)e);
                data = null;
            }
            if (data == null) {
                if (oldState == null) continue;
                newMap.put(key, oldMap.get(key));
                continue;
            }
            dataList.add(data);
        }
        return new RunDataHolder(dataList, oldMap, newMap);
    }

    @Nullable
    private RunData checkIfModuleNeedsUpdate(@Nullable StateHolder oldState, @NotNull Module module) throws CantRunException {
        if (module == null) {
            TraitInjectorService.$$$reportNull$$$0(14);
        }
        LOG.debug(module + ": Checking module");
        GlobalSearchScope scope2 = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        Collection factories = FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)"grails.factories", (GlobalSearchScope)scope2);
        List<String> factoriesPaths = factories.stream().map(VirtualFile::getPath).collect(Collectors.toList());
        if (oldState != null && oldState.knownFactories.equals(factoriesPaths)) {
            LOG.debug(module + ": Factories not changed");
            return null;
        }
        JavaParameters params = GroovyScriptRunConfiguration.createJavaParametersWithSdk((Module)module);
        DefaultGroovyScriptRunner.configureGenericGroovyRunner((JavaParameters)params, (Module)module, (String)"groovy.ui.GroovyMain", (boolean)false, (boolean)true);
        params.getClassPath().add(PathUtil.getJarPathForClass(GrailsRtMarker.class));
        params.setDefaultCharset(this.myProject);
        params.getProgramParametersList().add(GrailsRtMarker.class.getResource("/idea-injected-traits.groovy").toString());
        params.setUseClasspathJar(true);
        params.setUseDynamicParameters(true);
        params.setUseDynamicClasspath(this.myProject);
        GeneralCommandLine commandLine = params.toCommandLine();
        LOG.debug(module + ": Command line created");
        LOG.trace(module + ": " + commandLine.getCommandLineString());
        return new RunData(module.getName(), module, factoriesPaths, commandLine);
    }

    private void scheduleRunData(@NotNull RunDataHolder dataHolder) {
        if (dataHolder == null) {
            TraitInjectorService.$$$reportNull$$$0(15);
        }
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        this.myIndicator = indicator;
        LOG.debug(this.myProject + ": Scheduling run data");
        GrailsExecutorHolder.ourExecutorService.submit(() -> this.lambda$scheduleRunData$1(dataHolder, (ProgressIndicator)indicator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runData(@NotNull RunDataHolder dataHolder, @NotNull ProgressIndicator indicator) {
        if (dataHolder == null) {
            TraitInjectorService.$$$reportNull$$$0(16);
        }
        if (indicator == null) {
            TraitInjectorService.$$$reportNull$$$0(17);
        }
        boolean needToRestartHighlighting = false;
        try {
            for (RunData data : dataHolder.dataList) {
                MultiMap traits2 = (MultiMap)TraitInjectorService.runAndHandleException(data.module, () -> {
                    if (indicator == null) {
                        TraitInjectorService.$$$reportNull$$$0(24);
                    }
                    return TraitInjectorService.runData(data, indicator);
                });
                if (traits2 == null) continue;
                dataHolder.newMap.put(data.key, new StateHolder(data.knownFactories, (MultiMap<String, String>)traits2));
                StateHolder oldState = dataHolder.oldMap.get(data.key);
                needToRestartHighlighting |= oldState == null || !traits2.equals((Object)oldState.traits);
            }
            indicator.checkCanceled();
            Map<String, StateHolder> newMap = Collections.unmodifiableMap(dataHolder.newMap);
            if (!this.myMapRef.compareAndSet(dataHolder.oldMap, newMap)) {
                LOG.warn(this.myProject + ": State changed, updating anyway");
                this.myMapRef.set(newMap);
            } else {
                LOG.debug(this.myProject + ": State updated");
            }
        }
        finally {
            this.myIndicator = null;
            if (needToRestartHighlighting) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
                    LOG.debug(this.myProject + ": Highlighting restarted");
                }, this.myProject.getDisposed());
            }
        }
    }

    @Nullable
    private static MultiMap<String, String> runData(@NotNull RunData data, @NotNull ProgressIndicator indicator) throws ExecutionException {
        if (data == null) {
            TraitInjectorService.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            TraitInjectorService.$$$reportNull$$$0(19);
        }
        indicator.checkCanceled();
        Module module = data.module;
        GeneralCommandLine commandLine = data.commandLine;
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = handler.runProcessWithProgressIndicator(indicator, 60000);
        if (output.getExitCode() != 0) {
            LOG.debug(module + ": Script exited with " + output.getExitCode() + ". Stderr: '" + output.getStderr() + "'");
            return null;
        }
        String stdout = output.getStdout();
        LOG.debug(module + ": Script output: " + stdout);
        try {
            return TraitInjectorService.doParseOutput(stdout);
        }
        catch (Throwable e) {
            LOG.info(module + ": Error parsing output", e);
            return null;
        }
    }

    @NotNull
    private static MultiMap<String, String> doParseOutput(@NotNull String output) {
        if (output == null) {
            TraitInjectorService.$$$reportNull$$$0(20);
        }
        MultiMap result2 = MultiMap.create();
        LinkedList lines = ContainerUtil.newLinkedList((Object[])output.split("\n"));
        while (!((String)lines.pop()).equals(MARKER)) {
        }
        while (lines.size() > 1) {
            String traitName = (String)lines.pop();
            int artifactCount = Integer.parseInt((String)lines.pop());
            while (artifactCount-- > 0) {
                String artifactName = (String)lines.pop();
                result2.putValue((Object)artifactName, (Object)traitName);
            }
        }
        assert (((String)lines.pop()).equals(MARKER));
        MultiMap multiMap = result2;
        if (multiMap == null) {
            TraitInjectorService.$$$reportNull$$$0(21);
        }
        return multiMap;
    }

    @Nullable
    public PersistentState getState() {
        Map<String, StateHolder> map2 = this.myMapRef.get();
        return map2.isEmpty() ? null : new PersistentState(map2);
    }

    public void loadState(PersistentState persistentState) {
        this.myMapRef.set(Collections.unmodifiableMap(persistentState.state));
    }

    @Nullable
    private static <T> T runAndHandleException(@NotNull Module context, @NotNull ThrowableComputable<T, ? extends ExecutionException> runnable) {
        if (context == null) {
            TraitInjectorService.$$$reportNull$$$0(22);
        }
        if (runnable == null) {
            TraitInjectorService.$$$reportNull$$$0(23);
        }
        try {
            return (T)runnable.compute();
        }
        catch (ExecutionException e) {
            ExecutionUtil.handleExecutionError((Project)context.getProject(), (String)ToolWindowId.RUN, (String)"Collecting Injected Traits", (Throwable)e);
            LOG.debug(context + ": Error executing script", (Throwable)e);
            return null;
        }
    }

    private /* synthetic */ void lambda$scheduleRunData$1(@NotNull RunDataHolder dataHolder, ProgressIndicator indicator) {
        if (dataHolder == null) {
            TraitInjectorService.$$$reportNull$$$0(25);
        }
        ProgressManager.getInstance().runProcess(() -> {
            if (dataHolder == null) {
                TraitInjectorService.$$$reportNull$$$0(26);
            }
            this.runData(dataHolder, indicator);
        }, indicator);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/references/TraitInjectorService";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 5: 
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artefactType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: 
            case 16: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataHolder";
                break;
            }
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedTraits";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetInjectedTraits";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doParseOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedTraits";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doGetInjectedTraits";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkIfModuleNeedsUpdate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRunData";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "runData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doParseOutput";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "runAndHandleException";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runData$2";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$scheduleRunData$1";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PersistentState {
        public HashMap<String, StateHolder> state = new HashMap();

        public PersistentState(Map<String, StateHolder> map2) {
            this.state.putAll(map2);
        }

        public PersistentState() {
        }
    }

    public static class StateHolder {
        @NotNull
        public Collection<String> knownFactories;
        @NotNull
        public SerializableStringMultiMap traits;

        public StateHolder(@NotNull Collection<String> knownFactories, @NotNull MultiMap<String, String> traits2) {
            if (knownFactories == null) {
                StateHolder.$$$reportNull$$$0(0);
            }
            if (traits2 == null) {
                StateHolder.$$$reportNull$$$0(1);
            }
            this.knownFactories = new ArrayList<String>();
            this.traits = new SerializableStringMultiMap();
            this.knownFactories.addAll(knownFactories);
            this.traits.putAllValues(traits2);
        }

        public StateHolder() {
            this.knownFactories = new ArrayList<String>();
            this.traits = new SerializableStringMultiMap();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "knownFactories";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "traits";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService$StateHolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunData {
        @NotNull
        final String key;
        @NotNull
        final Module module;
        @NotNull
        final List<String> knownFactories;
        @NotNull
        final GeneralCommandLine commandLine;

        RunData(@NotNull String key, @NotNull Module module, @NotNull List<String> factories, @NotNull GeneralCommandLine line) {
            if (key == null) {
                RunData.$$$reportNull$$$0(0);
            }
            if (module == null) {
                RunData.$$$reportNull$$$0(1);
            }
            if (factories == null) {
                RunData.$$$reportNull$$$0(2);
            }
            if (line == null) {
                RunData.$$$reportNull$$$0(3);
            }
            this.key = key;
            this.module = module;
            this.knownFactories = factories;
            this.commandLine = line;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "module";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factories";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "line";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService$RunData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RunDataHolder {
        @NotNull
        final List<RunData> dataList;
        @NotNull
        final Map<String, StateHolder> oldMap;
        @NotNull
        final Map<String, StateHolder> newMap;

        RunDataHolder(@NotNull List<RunData> dataList, @NotNull Map<String, StateHolder> oldMap, @NotNull Map<String, StateHolder> newMap) {
            if (dataList == null) {
                RunDataHolder.$$$reportNull$$$0(0);
            }
            if (oldMap == null) {
                RunDataHolder.$$$reportNull$$$0(1);
            }
            if (newMap == null) {
                RunDataHolder.$$$reportNull$$$0(2);
            }
            this.dataList = dataList;
            this.oldMap = oldMap;
            this.newMap = newMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataList";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldMap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newMap";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/grails/references/TraitInjectorService$RunDataHolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

