/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.runner;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.DisposeAwareRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.runner.GrailsConsoleState;
import org.jetbrains.plugins.groovy.mvc.ConsoleProcessDescriptor;

@State(name="GrailsConsole", storages={@Storage(value="$WORKSPACE_FILE$")})
public class GrailsConsole
implements Disposable,
PersistentStateComponent<GrailsConsoleState> {
    private static final Logger LOG = Logger.getInstance(GrailsConsole.class);
    @NonNls
    public static final String TOOL_WINDOW_ID = "Grails Console";
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Grails notifications", (String)"Grails Console");
    private final Project myProject;
    private final ConsoleViewImpl myConsole;
    private final ToolWindowEx myToolWindow;
    private final Content myContent;
    private boolean myIsAutoCloseEnabled = true;
    private final Queue<MyProcessInConsole> myProcessQueue = new LinkedList<MyProcessInConsole>();
    private final MyKillProcessAction myKillAction = new MyKillProcessAction();
    private boolean myExecuting = false;

    public GrailsConsole(Project project, TextConsoleBuilderFactory consoleBuilderFactory) {
        this.myProject = project;
        this.myConsole = (ConsoleViewImpl)consoleBuilderFactory.createBuilder(this.myProject).getConsole();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
        this.myToolWindow = (ToolWindowEx)ToolWindowManager.getInstance((Project)this.myProject).registerToolWindow(TOOL_WINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)this, true);
        this.myToolWindow.setIcon(GrailsFramework.getInstance().getToolWindowIcon());
        this.myToolWindow.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new ToggleAction("Auto Close when Done"){

            public boolean isSelected(AnActionEvent e) {
                return GrailsConsole.this.myIsAutoCloseEnabled;
            }

            public void setSelected(AnActionEvent e, boolean state) {
                GrailsConsole.this.myIsAutoCloseEnabled = state;
            }
        }}));
        RunnerLayoutUi.Factory factory = RunnerLayoutUi.Factory.getInstance((Project)this.myProject);
        RunnerLayoutUi layoutUi = factory.create("", "", "session", (Disposable)this.myProject);
        JComponent uiComponent = layoutUi.getComponent();
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)this.myKillAction);
        group.addSeparator();
        layoutUi.getOptions().setLeftToolbar((ActionGroup)group, "unknown");
        Content console = layoutUi.createContent("Grails Console 111", this.myConsole.getComponent(), "", null, null);
        console.setCloseable(false);
        layoutUi.addContent(console, 0, PlaceInGrid.right, false);
        ContentManager manager = this.myToolWindow.getContentManager();
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        this.myContent = contentFactory.createContent(uiComponent, null, true);
        manager.addContent(this.myContent);
    }

    @Nullable
    public GrailsConsoleState getState() {
        return new GrailsConsoleState(this.myIsAutoCloseEnabled);
    }

    public void loadState(GrailsConsoleState state) {
        this.myIsAutoCloseEnabled = state.getAutoCloseEnabled();
    }

    public static GrailsConsole getInstance(@NotNull Project project) {
        if (project == null) {
            GrailsConsole.$$$reportNull$$$0(0);
        }
        return (GrailsConsole)ServiceManager.getService((Project)project, GrailsConsole.class);
    }

    public void show(@Nullable Runnable runnable, boolean focus) {
        Runnable r = null;
        if (runnable != null) {
            r = DisposeAwareRunnable.create((Runnable)runnable, (Project)this.myProject);
        }
        this.myToolWindow.activate(r, focus);
    }

    @NotNull
    public static ConsoleProcessDescriptor executeProcess(Project project, GeneralCommandLine commandLine, @Nullable Runnable onDone, boolean closeOnDone, String ... input) {
        ConsoleProcessDescriptor consoleProcessDescriptor = GrailsConsole.getInstance(project).executeProcess(commandLine, onDone, true, closeOnDone, input);
        if (consoleProcessDescriptor == null) {
            GrailsConsole.$$$reportNull$$$0(1);
        }
        return consoleProcessDescriptor;
    }

    @NotNull
    public ConsoleProcessDescriptor executeProcess(GeneralCommandLine commandLine, @Nullable Runnable onDone, boolean showConsole, boolean closeOnDone, String ... input) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        MyProcessInConsole process = new MyProcessInConsole(commandLine, onDone, showConsole, closeOnDone, input);
        if (this.isExecuting()) {
            this.myProcessQueue.add(process);
        } else {
            this.executeProcessImpl(process, true);
        }
        MyProcessInConsole myProcessInConsole = process;
        if (myProcessInConsole == null) {
            GrailsConsole.$$$reportNull$$$0(2);
        }
        return myProcessInConsole;
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    private void executeProcessImpl(final MyProcessInConsole pic, boolean toFocus) {
        OSProcessHandler handler;
        boolean modalContext;
        GeneralCommandLine commandLine = pic.commandLine;
        String[] input = pic.input;
        final Runnable onDone = pic.onDone;
        this.myExecuting = true;
        final ModalityState modalityState = ModalityState.current();
        boolean bl = modalContext = modalityState != ModalityState.NON_MODAL;
        if (!modalContext && pic.showConsole) {
            this.show(null, toFocus);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            handler = new OSProcessHandler(commandLine);
            OutputStreamWriter writer = new OutputStreamWriter(handler.getProcess().getOutputStream());
            try {
                for (String s2 : input) {
                    writer.write(s2);
                }
                writer.flush();
            }
            catch (IOException e) {
                LOG.info("Cannot write Grails process input", (Throwable)e);
            }
            final Ref gotError = new Ref((Object)false);
            handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key key) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (key == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (key == ProcessOutputTypes.STDERR) {
                        gotError.set((Object)true);
                    }
                    LOG.debug("got text: " + event.getText());
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    int exitCode;
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if ((exitCode = event.getExitCode()) == 0 && !((Boolean)gotError.get()).booleanValue()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (GrailsConsole.this.myProject.isDisposed()) {
                                    return;
                                }
                                if (pic.closeOnDone && GrailsConsole.this.myIsAutoCloseEnabled) {
                                    GrailsConsole.this.myToolWindow.hide(null);
                                }
                            }
                        }, modalityState);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsConsole$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (ExecutionException ex) {
            ExecutionUtil.handleExecutionError((Project)this.myProject, (String)TOOL_WINDOW_ID, (String)"Grails", (Throwable)ex);
            LOG.info((Throwable)ex);
            try {
                if (onDone != null) {
                    onDone.run();
                }
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            this.myExecuting = false;
            return;
        }
        pic.setHandler(handler);
        this.myKillAction.setHandler(handler);
        this.myContent.setDisplayName("Grails:Executing...");
        this.myConsole.scrollToEnd();
        this.myConsole.attachToProcess((ProcessHandler)handler);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                handler.startNotify();
                handler.waitFor();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (GrailsConsole.this.myProject.isDisposed()) {
                            return;
                        }
                        LocalFileSystem.getInstance().refresh(false);
                        try {
                            if (onDone != null) {
                                onDone.run();
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                        GrailsConsole.this.myConsole.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
                        GrailsConsole.this.myKillAction.setHandler(null);
                        GrailsConsole.this.myContent.setDisplayName("");
                        GrailsConsole.this.myExecuting = false;
                        MyProcessInConsole pic = (MyProcessInConsole)GrailsConsole.this.myProcessQueue.poll();
                        if (pic != null) {
                            GrailsConsole.this.executeProcessImpl(pic, false);
                        }
                    }
                }, modalityState);
            }
        });
    }

    public void dispose() {
    }

    public ConsoleViewImpl getConsole() {
        return this.myConsole;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/runner/GrailsConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/runner/GrailsConsole";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyKillProcessAction
    extends AnAction {
        private OSProcessHandler myHandler;

        public MyKillProcessAction() {
            super("Kill process", "Kill process", AllIcons.Debugger.KillProcess);
            this.myHandler = null;
        }

        public void setHandler(@Nullable OSProcessHandler handler) {
            this.myHandler = handler;
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.isEnabled());
        }

        public void actionPerformed(AnActionEvent e) {
            if (this.myHandler != null) {
                Process process = this.myHandler.getProcess();
                process.destroy();
                GrailsConsole.this.myConsole.print("Process terminated", ConsoleViewContentType.ERROR_OUTPUT);
            }
        }

        public boolean isEnabled() {
            return this.myHandler != null;
        }
    }

    private static class MyProcessInConsole
    implements ConsoleProcessDescriptor {
        final GeneralCommandLine commandLine;
        @Nullable
        final Runnable onDone;
        final boolean closeOnDone;
        final boolean showConsole;
        final String[] input;
        private final List<ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private OSProcessHandler myHandler;

        public MyProcessInConsole(GeneralCommandLine commandLine, @Nullable Runnable onDone, boolean showConsole, boolean closeOnDone, String[] input) {
            this.commandLine = commandLine;
            this.onDone = onDone;
            this.closeOnDone = closeOnDone;
            this.input = input;
            this.showConsole = showConsole;
        }

        public ConsoleProcessDescriptor addProcessListener(@NotNull ProcessListener listener) {
            if (listener == null) {
                MyProcessInConsole.$$$reportNull$$$0(0);
            }
            if (this.myHandler != null) {
                this.myHandler.addProcessListener(listener);
            } else {
                this.myListeners.add(listener);
            }
            return this;
        }

        public ConsoleProcessDescriptor waitWith(ProgressIndicator progressIndicator) {
            if (this.myHandler != null) {
                this.doWait(progressIndicator);
            }
            return this;
        }

        private void doWait(ProgressIndicator progressIndicator) {
            while (!this.myHandler.waitFor(500L)) {
                if (!progressIndicator.isCanceled()) continue;
                this.myHandler.destroyProcess();
                break;
            }
        }

        public void setHandler(OSProcessHandler handler) {
            this.myHandler = handler;
            for (ProcessListener listener : this.myListeners) {
                handler.addProcessListener(listener);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/plugins/grails/runner/GrailsConsole$MyProcessInConsole", "addProcessListener"));
        }
    }
}

