/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.util;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.config.GrailsFramework;
import org.jetbrains.plugins.grails.config.GrailsStructure;
import org.jetbrains.plugins.grails.pluginSupport.webflow.WebFlowUtils;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.grails.runner.GrailsCommandExecutor;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;
import org.jetbrains.plugins.grails.util.GrailsArtifact;
import org.jetbrains.plugins.grails.util.GrailsNameUtils;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.transformations.impl.GroovyObjectTransformationSupport;

public class GrailsUtils {
    private static final Logger LOG = Logger.getInstance(GrailsUtils.class);
    public static final List<String> TEST_FOLDER_NAMES = Arrays.asList("integration", "unit", "functional");
    @NonNls
    public static final String GRAILS_INTEGRATION_TESTS = "test/integration/";
    @NonNls
    public static final String GRAILS_UNIT_TESTS = "test/unit/";
    @NonNls
    public static final String GRAILS_APP_DIRECTORY = "grails-app";
    @NonNls
    public static final String VIEWS_DIRECTORY = "views";
    @NonNls
    public static final String CONF_DIRECTORY = "conf";
    @NonNls
    public static final String BUILD_CONFIG = "BuildConfig.groovy";
    @NonNls
    public static final String CONFIG_GROOVY = "Config.groovy";
    public static final String GRAILS_NOTIFICATION_GROUP = "grails";
    @NonNls
    public static final String SOURCE_ROOT = "src";
    @NonNls
    public static final String JAVA_SOURCE_ROOT = "java";
    @NonNls
    public static final String webAppDir = "web-app";
    @NonNls
    public static final String metaInfDir = "META-INF";
    @NonNls
    public static final String webInfDir = "WEB-INF";
    @NonNls
    public static final String jsDir = "js";
    @NonNls
    public static final String cssDir = "css";
    @NonNls
    public static final String imagecDir = "images";
    @NonNls
    public static final String GRAILS_USER_LIBRARY = "Grails User Library";
    @NonNls
    public static final String GROOVY_EXTENSION = ".groovy";
    @NonNls
    public static final String TEST_DIR = "test";
    @NonNls
    public static final String TEMPLATES_DIR = "templates";
    @NonNls
    public static String GRAILS_RUN_DEFAULT_HOST = "localhost";
    @NonNls
    public static String GRAILS_RUN_DEFAULT_PORT = "8080";
    private static final String[] RESERVED_DIRS = new String[]{"META-INF", "WEB-INF", "js", "css", "images"};
    public static final String ENVIRONMENTS = "environments";
    public static final String ENVIRONMENTS_METHOD_KIND = "grails:environments";
    public static final List<String> ENVIRONMENT_LIST = Arrays.asList("development", "production", "test");
    public static final String COMMON_WEB_PROPERTIES = " private org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap getParams() {} private org.codehaus.groovy.grails.web.servlet.FlashScope getFlash() {} private javax.servlet.http.HttpSession getSession() {} private javax.servlet.http.HttpServletRequest getRequest() {} private javax.servlet.ServletContext getServletContext() {} private javax.servlet.http.HttpServletResponse getResponse() {} private org.codehaus.groovy.grails.web.servlet.GrailsApplicationAttributes getGrailsAttributes() {} private org.codehaus.groovy.grails.commons.GrailsApplication getGrailsApplication() {} private String getActionName() {} private String getControllerName() {} private org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest getWebRequest() {};";

    private GrailsUtils() {
    }

    @Nullable
    public static VirtualFile findParent(VirtualFile virtualFile, String parentFileName) {
        VirtualFile parent;
        for (parent = virtualFile.getParent(); parent != null && !parentFileName.equals(parent.getName()); parent = parent.getParent()) {
        }
        return parent;
    }

    public static boolean isUnderWebAppDirectory(PsiDirectory directory) {
        VirtualFile virtualFile = directory.getVirtualFile();
        if (virtualFile.getName().equals(webAppDir) && virtualFile.isDirectory()) {
            return true;
        }
        VirtualFile parent = GrailsUtils.findParent(virtualFile, webAppDir);
        if (parent == null || ArrayUtil.contains((String)virtualFile.getName(), (String[])RESERVED_DIRS)) {
            return false;
        }
        for (String reservedDir : RESERVED_DIRS) {
            if (GrailsUtils.findParent(virtualFile, reservedDir) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean isConfigGroovyFile(@Nullable PsiElement file) {
        return GrailsUtils.isConfigFile(file, CONFIG_GROOVY);
    }

    public static boolean isConfigFile(@Nullable PsiElement file, String name) {
        if (!(file instanceof GroovyFileBase)) {
            return false;
        }
        VirtualFile virtualFile = ((GroovyFileBase)file).getOriginalFile().getVirtualFile();
        if (virtualFile == null || !name.equals(virtualFile.getName())) {
            return false;
        }
        VirtualFile conf = virtualFile.getParent();
        if (conf == null || !CONF_DIRECTORY.equals(conf.getName())) {
            return false;
        }
        VirtualFile grailsApp = conf.getParent();
        if (grailsApp == null || !GRAILS_APP_DIRECTORY.equals(grailsApp.getName())) {
            return false;
        }
        return ((GroovyFileBase)file).isScript();
    }

    public static boolean isBuildConfigFile(@Nullable PsiFile file) {
        return GrailsUtils.isConfigFile((PsiElement)file, BUILD_CONFIG);
    }

    @Nullable
    public static VirtualFile getViewDirectory(@Nullable VirtualFile gspFile) {
        for (VirtualFile f = gspFile; f != null; f = f.getParent()) {
            VirtualFile parent;
            if (!f.getName().equals(VIEWS_DIRECTORY) || !f.isDirectory() || (parent = f.getParent()) == null || !parent.getName().equals(GRAILS_APP_DIRECTORY)) continue;
            return f;
        }
        return null;
    }

    public static boolean isUnderGrailsViewsDirectory(PsiDirectory directory) {
        return GrailsUtils.getViewDirectory(directory.getVirtualFile()) != null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile findGrailsAppRoot(@Nullable Module module) {
        return GrailsFramework.getInstance().findAppRoot(module);
    }

    public static boolean hasSupport(@NotNull Module module) {
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(0);
        }
        return GrailsCommandExecutor.getGrailsExecutor(GrailsApplicationManager.findApplication(module)) != null;
    }

    public static boolean isGrailsPluginModule(@Nullable Module module) {
        return GrailsUtils.extractGrailsPluginName(module) != null;
    }

    @Nullable
    public static String extractGrailsPluginName(@Nullable Module module) {
        VirtualFile root = GrailsUtils.findGrailsAppRoot(module);
        return GrailsUtils.extractGrailsPluginName(root);
    }

    @Nullable
    public static String extractGrailsPluginName(@Nullable VirtualFile root) {
        if (root == null) {
            return null;
        }
        for (VirtualFile child : root.getChildren()) {
            String name = child.getName();
            if (!name.endsWith("GrailsPlugin.groovy")) continue;
            return StringUtil.trimEnd((String)name, (String)"GrailsPlugin.groovy");
        }
        return null;
    }

    public static boolean isInGrailsTests(@NotNull PsiElement element) {
        PsiFile file;
        VirtualFile virtualFile;
        if (element == null) {
            GrailsUtils.$$$reportNull$$$0(1);
        }
        if ((virtualFile = (file = element.getContainingFile().getOriginalFile()).getVirtualFile()) == null) {
            return false;
        }
        return GrailsUtils.isInGrailsTests(virtualFile, file.getProject());
    }

    public static boolean isInGrailsTests(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        GrailsApplication application;
        if (virtualFile == null) {
            GrailsUtils.$$$reportNull$$$0(2);
        }
        if (project == null) {
            GrailsUtils.$$$reportNull$$$0(3);
        }
        if ((application = GrailsApplicationManager.getInstance(project).findApplication(virtualFile)) == null) {
            return false;
        }
        return application.getScope(false, true).contains(virtualFile) || GlobalSearchScopesCore.projectTestScope((Project)project).contains(virtualFile);
    }

    @Nullable
    public static VirtualFile findViewsDirectory(@Nullable PsiElement element) {
        GrailsApplication application = GrailsApplicationManager.findApplication(element);
        if (application == null) {
            return null;
        }
        return application.getAppRoot().findChild(VIEWS_DIRECTORY);
    }

    @Nullable
    public static VirtualFile findI18nDirectory(@Nullable PsiElement element) {
        VirtualFile appDir = GrailsFramework.getInstance().findAppDirectory(element);
        if (appDir == null) {
            return null;
        }
        return appDir.findChild("i18n");
    }

    @Nullable
    public static VirtualFile findConfDirectory(@Nullable Module module) {
        VirtualFile root = GrailsFramework.getInstance().findAppDirectory(module);
        if (root == null) {
            return null;
        }
        return root.findChild(CONF_DIRECTORY);
    }

    @Nullable
    public static VirtualFile findConfDirectory(@NotNull GrailsApplication application) {
        if (application == null) {
            GrailsUtils.$$$reportNull$$$0(4);
        }
        return application.getAppRoot().findChild(CONF_DIRECTORY);
    }

    @Nullable
    public static String getTemplateName(String fileName) {
        if (fileName.length() > 5 && fileName.charAt(0) == '_' && fileName.endsWith(".gsp")) {
            return fileName.substring(1, fileName.length() - ".gsp".length());
        }
        return null;
    }

    public static String getFileNameByTemplateName(String templateName) {
        return '_' + templateName + ".gsp";
    }

    public static PsiMember toField(@Nullable PsiMethod getter) {
        return getter instanceof GrAccessorMethod ? ((GrAccessorMethod)getter).getProperty() : getter;
    }

    public static Map<String, PsiMethod> getControllerActions(@Nullable String controllerName, @NotNull Module module) {
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(5);
        }
        return GrailsUtils.getControllerActions(GrailsArtifact.CONTROLLER.getInstances(module, controllerName), module);
    }

    public static Map<String, PsiMethod> getControllerActions(Collection<? extends GrTypeDefinition> classes, @NotNull Module module) {
        GrailsStructure structure;
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(6);
        }
        Boolean isGrails1_4 = (structure = GrailsStructure.getInstance(module)) == null || structure.isAtLeastGrails1_4();
        LinkedHashMap<String, PsiMethod> res = new LinkedHashMap<String, PsiMethod>();
        try {
            List allMethods = GrClassImplUtil.getAllMethods(classes);
            List viableMethods = ContainerUtil.filter((Collection)allMethods, m -> !GroovyObjectTransformationSupport.isGroovyObjectSupportMethod((PsiMethod)m));
            for (PsiMethod method : viableMethods) {
                PsiMethod oldValue;
                String name = GrailsUtils.getActionName0((PsiElement)method, false, isGrails1_4);
                if (name == null || (oldValue = res.put(name, method)) == null) continue;
                res.put(name, oldValue);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return res;
    }

    public static Map<String, PsiMethod> collectClosureProperties(Collection<? extends PsiClass> classes) {
        if (classes.isEmpty()) {
            return Collections.emptyMap();
        }
        ClosurePropertiesProcessor processor = new ClosurePropertiesProcessor();
        for (PsiClass psiClass : classes) {
            psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass);
        }
        return processor.getResults();
    }

    @Nullable
    public static PsiMethod getClosureProperty(Collection<? extends PsiClass> classes, @NotNull String propertyName) {
        if (propertyName == null) {
            GrailsUtils.$$$reportNull$$$0(7);
        }
        if (classes.isEmpty()) {
            return null;
        }
        ClosureOnePropertyProcessor processor = new ClosureOnePropertyProcessor(propertyName);
        for (PsiClass psiClass : classes) {
            if (!psiClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, (PsiElement)psiClass)) break;
        }
        return processor.getResult();
    }

    @Nullable
    public static VirtualFile getControllerDirByGsp(VirtualFile gspFile) {
        VirtualFile parent1 = gspFile.getParent();
        if (parent1 == null) {
            return null;
        }
        VirtualFile parent2 = parent1.getParent();
        if (parent2 == null) {
            return null;
        }
        VirtualFile parent3 = parent2.getParent();
        if (parent3 == null) {
            return null;
        }
        while (!GRAILS_APP_DIRECTORY.equals(parent3.getName()) || !VIEWS_DIRECTORY.equals(parent2.getName())) {
            parent1 = parent2;
            parent2 = parent3;
            if ((parent3 = parent3.getParent()) != null) continue;
            return null;
        }
        return parent1;
    }

    @Nullable
    public static String getExistingControllerNameDirByGsp(VirtualFile gspFile, Project project) {
        String controllerName = GrailsUtils.getControllerNameByGsp(gspFile);
        if (controllerName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)gspFile, (Project)project);
        if (module != null && !GrailsArtifact.CONTROLLER.getInstances(module, controllerName).isEmpty()) {
            return controllerName;
        }
        return null;
    }

    @Nullable
    public static String getControllerNameByGsp(@NotNull VirtualFile gspFile) {
        VirtualFile controllerFolder;
        if (gspFile == null) {
            GrailsUtils.$$$reportNull$$$0(8);
        }
        return (controllerFolder = GrailsUtils.getControllerDirByGsp(gspFile)) == null ? null : controllerFolder.getName();
    }

    public static Object[] createPluginVariants(@NotNull Module module, boolean withVersion) {
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(9);
        }
        Collection<VirtualFile> roots = GrailsFramework.getInstance().getAllPluginRoots(module, false);
        Object[] res = new Object[roots.size()];
        int i = 0;
        for (VirtualFile root : roots) {
            String pluginName = GrailsUtils.extractGrailsPluginName(root);
            if (pluginName == null) continue;
            pluginName = withVersion ? root.getName() : GrailsNameUtils.getScriptName(pluginName);
            res[i++] = LookupElementBuilder.create((String)pluginName).withIcon(JetgroovyIcons.Mvc.Groovy_mvc_plugin);
        }
        return res;
    }

    public static boolean isControllerAction(@Nullable PsiElement element) {
        return GrailsUtils.getActionName(element) != null;
    }

    @Nullable
    public static String getActionName(@Nullable PsiElement element) {
        return GrailsUtils.getActionName0(element, true, null);
    }

    @Nullable
    public static String getActionName0(@Nullable PsiElement element, boolean needCheckArtifact, @Nullable Boolean isGrails1_4) {
        GrMember member;
        if (element instanceof GrAccessorMethod) {
            if (((GrAccessorMethod)element).isSetter()) {
                return null;
            }
            member = ((GrAccessorMethod)element).getProperty();
        } else {
            if (!(element instanceof GrMember)) {
                return null;
            }
            member = (GrMember)element;
        }
        if (needCheckArtifact && !GrailsArtifact.CONTROLLER.isInstance(member.getContainingClass())) {
            return null;
        }
        if (member.hasModifierProperty("static")) {
            return null;
        }
        if (member instanceof GrField) {
            GrField field = (GrField)member;
            if (!(field.getInitializerGroovy() instanceof GrClosableBlock)) {
                return null;
            }
            GrModifierList modifierList = field.getModifierList();
            if (modifierList == null || modifierList.hasExplicitVisibilityModifiers() && !member.hasModifierProperty("public")) {
                return null;
            }
            String fieldName = element instanceof GrAccessorMethod ? GroovyPropertyUtils.getPropertyNameByGetterName((String)((GrAccessorMethod)element).getName(), (boolean)false) : member.getName();
            if (fieldName != null && fieldName.endsWith("Flow") && fieldName.length() > "Flow".length() && WebFlowUtils.isWebFlowEnabled(GrailsStructure.getInstance((PsiElement)member))) {
                return fieldName.substring(0, fieldName.length() - "Flow".length());
            }
            return fieldName;
        }
        if (member instanceof GrMethod) {
            if (isGrails1_4 == null) {
                GrailsStructure structure = GrailsStructure.getInstance((PsiElement)member);
                isGrails1_4 = structure == null || structure.isAtLeastGrails1_4();
            }
            if (!isGrails1_4.booleanValue()) {
                return null;
            }
            if (!member.hasModifierProperty("public")) {
                return null;
            }
            return member.getName();
        }
        return null;
    }

    @Nullable
    public static VirtualFile getControllerGspDir(@NotNull PsiClass controllerClass) {
        VirtualFile grailsApp;
        if (controllerClass == null) {
            GrailsUtils.$$$reportNull$$$0(10);
        }
        if ((grailsApp = GrailsArtifact.CONTROLLER.getGrailsApp(controllerClass)) == null) {
            return null;
        }
        VirtualFile viewDirectory = grailsApp.findChild(VIEWS_DIRECTORY);
        if (viewDirectory == null) {
            return null;
        }
        String categoryName = GrailsArtifact.CONTROLLER.getArtifactName(controllerClass);
        return viewDirectory.findChild(categoryName);
    }

    @NotNull
    public static List<VirtualFile> getViewsByAction(@NotNull PsiElement action) {
        String name;
        if (action == null) {
            GrailsUtils.$$$reportNull$$$0(11);
        }
        if ((name = GrailsUtils.getActionName(action)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GrailsUtils.$$$reportNull$$$0(12);
            }
            return list;
        }
        PsiClass aClass = ((GrMember)action).getContainingClass();
        assert (aClass != null);
        List<VirtualFile> list = GrailsUtils.getViewsByAction(aClass, name);
        if (list == null) {
            GrailsUtils.$$$reportNull$$$0(13);
        }
        return list;
    }

    @NotNull
    public static List<PsiFile> getViewPsiByAction(@NotNull PsiElement action) {
        if (action == null) {
            GrailsUtils.$$$reportNull$$$0(14);
        }
        List<VirtualFile> files = GrailsUtils.getViewsByAction(action);
        List list = ContainerUtil.mapNotNull(files, file -> {
            if (action == null) {
                GrailsUtils.$$$reportNull$$$0(29);
            }
            return action.getManager().findFile(file);
        });
        if (list == null) {
            GrailsUtils.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static List<VirtualFile> getViewsByAction(@NotNull PsiClass controllerClass, String actionName) {
        VirtualFile controllerViewFolder;
        if (controllerClass == null) {
            GrailsUtils.$$$reportNull$$$0(16);
        }
        if ((controllerViewFolder = GrailsUtils.getControllerGspDir(controllerClass)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GrailsUtils.$$$reportNull$$$0(17);
            }
            return list;
        }
        List result2 = ContainerUtil.newSmartList();
        ContainerUtil.addIfNotNull((Collection)result2, (Object)controllerViewFolder.findChild(actionName + ".gsp"));
        ContainerUtil.addIfNotNull((Collection)result2, (Object)controllerViewFolder.findChild(actionName + ".gson"));
        ContainerUtil.addIfNotNull((Collection)result2, (Object)controllerViewFolder.findChild(actionName + ".jsp"));
        List list = result2;
        if (list == null) {
            GrailsUtils.$$$reportNull$$$0(18);
        }
        return list;
    }

    public static boolean isBootStrapClass(@NotNull PsiClass aClass) {
        String className;
        if (aClass == null) {
            GrailsUtils.$$$reportNull$$$0(19);
        }
        if ((className = aClass.getName()) == null || !className.endsWith("BootStrap")) {
            return false;
        }
        PsiFile psiFile = aClass.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        VirtualFile vfile = psiFile.getOriginalFile().getVirtualFile();
        if (vfile == null) {
            return false;
        }
        VirtualFile confDir = vfile.getParent();
        if (confDir == null || !confDir.getName().equals(CONF_DIRECTORY)) {
            return false;
        }
        VirtualFile grailsApp = confDir.getParent();
        return grailsApp != null && grailsApp.getName().equals(GRAILS_APP_DIRECTORY);
    }

    @Nullable
    public static TldDescriptor getTldDescriptor(@Nullable XmlFile xmlFile) {
        if (xmlFile == null) {
            return null;
        }
        XmlDocument document = xmlFile.getDocument();
        if (document == null) {
            return null;
        }
        PsiMetaData metaData = document.getMetaData();
        if (!(metaData instanceof TldDescriptor)) {
            return null;
        }
        return (TldDescriptor)metaData;
    }

    public static int getPluginDependenciesCrc(@NotNull Module module) {
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(20);
        }
        ArrayList<Integer> crcList = new ArrayList<Integer>();
        CRC32 crc = new CRC32();
        for (VirtualFile pluginRoot : GrailsFramework.getInstance().getCommonPluginRoots(module, false)) {
            VirtualFile dependenciesFile = pluginRoot.findChild("dependencies.groovy");
            if (dependenciesFile == null) continue;
            try {
                String fileText = VfsUtilCore.loadText((VirtualFile)dependenciesFile).trim();
                if (fileText.isEmpty()) continue;
                crc.reset();
                crc.update(fileText.getBytes(CharsetToolkit.UTF8_CHARSET));
                crcList.add((int)crc.getValue());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (crcList.isEmpty()) {
            return 0;
        }
        Collections.sort(crcList);
        return crcList.hashCode();
    }

    public static int getPluginsCrc(@NotNull Module module) {
        if (module == null) {
            GrailsUtils.$$$reportNull$$$0(21);
        }
        ArrayList<Integer> crcList = new ArrayList<Integer>();
        CRC32 crc = new CRC32();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
            if (!(entry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)entry;
            for (VirtualFile root : libraryOrderEntry.getFiles(OrderRootType.CLASSES)) {
                VirtualFile dependenciesFile = (VirtualFile)ContainerUtil.find((Object[])root.getChildren(), file -> !file.isDirectory() && StringUtil.equals((CharSequence)file.getExtension(), (CharSequence)"groovy") && file.getName().endsWith("GrailsPlugin.groovy"));
                if (dependenciesFile == null) continue;
                try {
                    String fileText = VfsUtilCore.loadText((VirtualFile)dependenciesFile).trim();
                    if (fileText.isEmpty()) continue;
                    crc.reset();
                    crc.update(fileText.getBytes(CharsetToolkit.UTF8_CHARSET));
                    crcList.add((int)crc.getValue());
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        if (crcList.isEmpty()) {
            return 0;
        }
        Collections.sort(crcList);
        return crcList.hashCode();
    }

    @Nullable
    public static GrClosableBlock getClosureArgument(@NotNull GrMethodCall callExpression) {
        GrArgumentList argumentList;
        GroovyPsiElement[] allArguments;
        if (callExpression == null) {
            GrailsUtils.$$$reportNull$$$0(22);
        }
        if ((allArguments = (argumentList = callExpression.getArgumentList()).getAllArguments()).length == 0) {
            GrClosableBlock[] closureArguments = callExpression.getClosureArguments();
            if (closureArguments.length == 1) {
                return closureArguments[0];
            }
        } else if (allArguments.length == 1 && allArguments[0] instanceof GrClosableBlock) {
            return (GrClosableBlock)allArguments[0];
        }
        return null;
    }

    public static boolean isGrailsPluginClass(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        String className = aClass.getName();
        if (className == null || !className.endsWith("GrailsPlugin")) {
            return false;
        }
        String qname = aClass.getQualifiedName();
        return qname != null && (!qname.contains(".") || qname.startsWith("org.codehaus.groovy.grails.plugins."));
    }

    public static <K, V> Map<K, V> createMap(Object ... data) {
        int length = data.length;
        assert ((length & 1) == 0);
        if (length == 0) {
            return Collections.emptyMap();
        }
        if (length == 2) {
            return Collections.singletonMap(data[0], data[1]);
        }
        HashMap<Object, Object> res = new HashMap<Object, Object>();
        for (int i = 0; i < length; i += 2) {
            res.put(data[i], data[i + 1]);
        }
        return res;
    }

    public static <K, V> Map<K, V> createEnumMap(Object ... data) {
        int length = data.length;
        assert ((length & 1) == 0);
        if (length == 0) {
            return Collections.emptyMap();
        }
        if (length == 2) {
            return Collections.singletonMap(data[0], data[1]);
        }
        EnumMap res = new EnumMap(data[0].getClass());
        for (int i = 0; i < length; i += 2) {
            res.put(data[i], data[i + 1]);
        }
        return res;
    }

    public static boolean isValidatedClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GrailsUtils.$$$reportNull$$$0(23);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)aClass, () -> {
            if (aClass == null) {
                GrailsUtils.$$$reportNull$$$0(28);
            }
            boolean value = GrailsUtils.isCommandClass(aClass) || InheritanceUtil.isInheritor((PsiClass)aClass, (String)"grails.validation.Validateable") || TypesUtil.isAnnotatedCheckHierarchyWithCache((PsiClass)aClass, (String)"org.codehaus.groovy.grails.validation.Validateable") || TypesUtil.isAnnotatedCheckHierarchyWithCache((PsiClass)aClass, (String)"grails.validation.Validateable");
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    public static boolean isCommandClass(@NotNull PsiClass aClass) {
        String name;
        if (aClass == null) {
            GrailsUtils.$$$reportNull$$$0(24);
        }
        if ((name = aClass.getName()) == null || !name.endsWith("Command")) {
            return false;
        }
        PsiFile file = aClass.getContainingFile().getOriginalFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile sourceRoot = ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().getSourceRootForFile(virtualFile);
        if (sourceRoot == null || !sourceRoot.getName().equals("controllers")) {
            return false;
        }
        VirtualFile appRoot = sourceRoot.getParent();
        return appRoot != null && appRoot.getName().equals(GRAILS_APP_DIRECTORY);
    }

    @Nullable
    public static GrailsArtifact calculateArtifactByAnnotation(@NotNull PsiClass aClass) {
        PsiAnnotation annotation;
        PsiModifierList modifierList;
        if (aClass == null) {
            GrailsUtils.$$$reportNull$$$0(25);
        }
        if ((modifierList = aClass.getModifierList()) != null && (annotation = modifierList.findAnnotation("grails.artefact.Artefact")) != null) {
            String s2 = GrAnnotationUtil.inferStringAttribute((PsiAnnotation)annotation, (String)"value");
            if ("TagLibrary".equals(s2)) {
                return GrailsArtifact.TAGLIB;
            }
            if ("Controller".equals(s2)) {
                return GrailsArtifact.CONTROLLER;
            }
            if ("Domain".equals(s2)) {
                return GrailsArtifact.DOMAIN;
            }
        }
        return null;
    }

    @Nullable
    public static GrailsArtifact calculateArtifactType(@NotNull PsiClass aClass) {
        GrailsArtifact res;
        if (aClass == null) {
            GrailsUtils.$$$reportNull$$$0(26);
        }
        if ((res = GrailsArtifact.getType(aClass)) != null) {
            return res;
        }
        if (GormUtils.isStandaloneGormBean(aClass)) {
            return GrailsArtifact.DOMAIN;
        }
        return GrailsUtils.calculateArtifactByAnnotation(aClass);
    }

    @Nullable
    public static File findLatestJarInIvyRepository(String artifactFolderPath, String jarPrefix) {
        File[] files;
        File jarDirectory = new File(artifactFolderPath, "jars");
        if (!jarDirectory.exists()) {
            File artifactFolderFile = new File(artifactFolderPath);
            Object[] versions = artifactFolderFile.list();
            if (versions == null || versions.length == 0) {
                return null;
            }
            Arrays.sort(versions);
            jarDirectory = new File(artifactFolderFile, (String)versions[versions.length - 1] + "/jar");
        }
        if ((files = jarDirectory.listFiles()) == null) {
            return null;
        }
        File res = null;
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith(jarPrefix) || !name.endsWith(".jar") || res != null && name.compareTo(res.getName()) <= 0) continue;
            res = file;
        }
        return res;
    }

    public static void addSystemPropertyIfNotExists(ParametersList parametersList, @NotNull String property) {
        if (property == null) {
            GrailsUtils.$$$reportNull$$$0(27);
        }
        int idx = property.indexOf(61);
        assert (idx > 0);
        String leftPart = property.substring(0, idx + 1);
        for (String param : parametersList.getParameters()) {
            if (param == null || !param.startsWith(leftPart)) continue;
            return;
        }
        parametersList.add(property);
    }

    private static boolean isAlreadyInsideEnvironmentDefinition(GrReferenceExpression ref) {
        PsiElement parent = ref.getParent();
        if (parent instanceof GrMethodCall) {
            parent = parent.getParent();
        }
        GrMethodCall call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)parent, GrMethodCall.class);
        while (call != null) {
            GrExpression[] arguments;
            String methodName = PsiUtil.getUnqualifiedMethodName((GrMethodCall)call);
            if (ENVIRONMENTS.equals(methodName) && (arguments = PsiUtil.getAllArguments((GrCall)call)).length == 1 && arguments[0] instanceof GrClosableBlock) {
                return true;
            }
            call = (GrMethodCall)PsiTreeUtil.getParentOfType((PsiElement)call, GrMethodCall.class);
        }
        return false;
    }

    public static boolean processEnvironmentDefinition(PsiScopeProcessor processor, GrReferenceExpression ref) {
        String nameHint = ResolveUtil.getNameHint((PsiScopeProcessor)processor);
        if (nameHint == null || nameHint.equals(ENVIRONMENTS)) {
            ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
            if (!ResolveUtil.shouldProcessMethods((ElementClassHint)classHint)) {
                return true;
            }
            if (ref.isQualified()) {
                return true;
            }
            if (GrailsUtils.isAlreadyInsideEnvironmentDefinition(ref)) {
                return true;
            }
            GrLightMethodBuilder envMethod = new GrLightMethodBuilder(ref.getManager(), ENVIRONMENTS);
            envMethod.setMethodKind((Object)ENVIRONMENTS_METHOD_KIND);
            envMethod.addParameter("closure", "groovy.lang.Closure", false);
            return processor.execute((PsiElement)envMethod, ResolveState.initial());
        }
        return true;
    }

    @Nullable
    public static PsiClass findApplicationClass(final Module module) {
        final Project project = module.getProject();
        return (PsiClass)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<PsiClass>(){
            private final PsiShortNamesCache myNamesCache;
            {
                this.myNamesCache = PsiShortNamesCache.getInstance((Project)project);
            }

            @Nullable
            public CachedValueProvider.Result<PsiClass> compute() {
                return CachedValueProvider.Result.create((Object)this.doCompute(), (Object[])new Object[]{ModuleManager.getInstance((Project)project), PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }

            private PsiClass doCompute() {
                PsiClass[] classes;
                for (PsiClass clazz : classes = this.myNamesCache.getClassesByName("Application", module.getModuleScope())) {
                    if (!PsiClassUtil.isRunnableClass((PsiClass)clazz, (boolean)true) || !InheritanceUtil.isInheritor((PsiClass)clazz, (String)"grails.boot.config.GrailsAutoConfiguration")) continue;
                    return clazz;
                }
                return null;
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gspFile";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerClass";
                break;
            }
            case 11: 
            case 14: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/grails/util/GrailsUtils";
                break;
            }
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsUtils";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewsByAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewPsiByAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasSupport";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInGrailsTests";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConfDirectory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getControllerActions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getClosureProperty";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getControllerNameByGsp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPluginVariants";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getControllerGspDir";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getViewsByAction";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getViewPsiByAction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isBootStrapClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDependenciesCrc";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getPluginsCrc";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClosureArgument";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isValidatedClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isCommandClass";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateArtifactByAnnotation";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "calculateArtifactType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addSystemPropertyIfNotExists";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isValidatedClass$3";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getViewPsiByAction$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClosureOnePropertyProcessor
    extends BaseScopeProcessor
    implements ElementClassHint,
    NameHint {
        private final String myGetterName;
        private final String myPropertyName;
        private PsiMethod result;

        public ClosureOnePropertyProcessor(@NotNull String propertyName) {
            if (propertyName == null) {
                ClosureOnePropertyProcessor.$$$reportNull$$$0(0);
            }
            this.myGetterName = GroovyPropertyUtils.getGetterNameNonBoolean((String)propertyName);
            this.myPropertyName = propertyName;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                ClosureOnePropertyProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                ClosureOnePropertyProcessor.$$$reportNull$$$0(2);
            }
            if (element instanceof PsiMethod && PsiUtil.isClosurePropertyGetter((PsiMethod)(method = (PsiMethod)element)) && this.myPropertyName.equals(GroovyPropertyUtils.getPropertyNameByGetterName((String)method.getName(), (boolean)false))) {
                this.result = method;
                return false;
            }
            return true;
        }

        public PsiMethod getResult() {
            return this.result;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                ClosureOnePropertyProcessor.$$$reportNull$$$0(3);
            }
            if (hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY) {
                return (T)((Object)this);
            }
            return null;
        }

        public boolean shouldProcess(ElementClassHint.DeclarationKind resolveKind) {
            return resolveKind == ElementClassHint.DeclarationKind.METHOD;
        }

        public String getName(@NotNull ResolveState state) {
            if (state == null) {
                ClosureOnePropertyProcessor.$$$reportNull$$$0(4);
            }
            return this.myGetterName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsUtils$ClosureOnePropertyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ClosurePropertiesProcessor
    extends BaseScopeProcessor
    implements ElementClassHint {
        private Map<String, PsiMethod> results;

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            PsiMethod method;
            if (element == null) {
                ClosurePropertiesProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                ClosurePropertiesProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiMethod && PsiUtil.isClosurePropertyGetter((PsiMethod)(method = (PsiMethod)element))) {
                String name;
                PsiMethod oldValue;
                if (this.results == null) {
                    this.results = new HashMap<String, PsiMethod>();
                }
                if ((oldValue = this.results.put(name = GroovyPropertyUtils.getPropertyNameByGetterName((String)method.getName(), (boolean)false), method)) != null) {
                    this.results.put(name, oldValue);
                }
            }
            return true;
        }

        public Map<String, PsiMethod> getResults() {
            return this.results == null ? Collections.emptyMap() : this.results;
        }

        public <T> T getHint(@NotNull Key<T> hintKey) {
            if (hintKey == null) {
                ClosurePropertiesProcessor.$$$reportNull$$$0(2);
            }
            if (hintKey == ElementClassHint.KEY) {
                return (T)((Object)this);
            }
            return null;
        }

        public boolean shouldProcess(ElementClassHint.DeclarationKind resolveKind) {
            return resolveKind == ElementClassHint.DeclarationKind.METHOD;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hintKey";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/grails/util/GrailsUtils$ClosurePropertiesProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

