/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.breakpoints.JavaScriptTemplateLanguageHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Url;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xml.util.HtmlUtil;
import java.io.File;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImpl;

public class JsFileUtil {
    public static final int MAX_TITLE_LENGTH = 150;

    private JsFileUtil() {
    }

    @NotNull
    public static String getShortenedFilePath(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JsFileUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JsFileUtil.$$$reportNull$$$0(1);
        }
        if (!file.isInLocalFileSystem()) {
            String string = file.getUrl();
            if (string == null) {
                JsFileUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        String name = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)project.getBaseDir(), (char)File.separatorChar);
        String string = name == null ? FileUtil.getLocationRelativeToUserHome((String)file.getPath()) : name;
        if (string == null) {
            JsFileUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String trimTitle(@NotNull String url) {
        if (url == null) {
            JsFileUtil.$$$reportNull$$$0(4);
        }
        String string = StringUtil.trimMiddle((String)url, (int)150);
        if (string == null) {
            JsFileUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Contract(value="_, null -> null")
    public static OpenFileDescriptor createNavigatable(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JsFileUtil.$$$reportNull$$$0(6);
        }
        return file == null ? null : new OpenFileDescriptor(project, file);
    }

    public static boolean isOnBuiltInWebServer(@NotNull Url url) {
        if (url == null) {
            JsFileUtil.$$$reportNull$$$0(7);
        }
        return BuiltInServerManager.getInstance().isOnBuiltInWebServer(url);
    }

    public static boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        if (authority == null) {
            JsFileUtil.$$$reportNull$$$0(8);
        }
        return BuiltInServerManagerImpl.isOnBuiltInWebServerByAuthority((String)authority);
    }

    public static boolean isScript(@NotNull FileType fileType) {
        if (fileType == null) {
            JsFileUtil.$$$reportNull$$$0(9);
        }
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType) || fileType.getName().equals("Dart") && fileType.getDefaultExtension().equals("dart");
    }

    public static boolean isHtmlOrJavaScript(@NotNull VirtualFile file) {
        if (file == null) {
            JsFileUtil.$$$reportNull$$$0(10);
        }
        FileType fileType = file.getFileType();
        return HtmlUtil.isHtmlFile((VirtualFile)file) || DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType);
    }

    public static boolean isHtmlOrTemplateFile(@NotNull VirtualFile file) {
        if (file == null) {
            JsFileUtil.$$$reportNull$$$0(11);
        }
        return HtmlUtil.isHtmlFile((VirtualFile)file) || JsFileUtil.isTemplateFileType(file.getFileType());
    }

    public static boolean isTemplateFileType(FileType fileType) {
        for (JavaScriptTemplateLanguageHandler handler : (JavaScriptTemplateLanguageHandler[])JavaScriptTemplateLanguageHandler.EP_NAME.getExtensions()) {
            if (!handler.isTemplateFileType(fileType)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsDebuggableElement(int line, @NotNull Project project, @NotNull Document document, boolean inEventHandler, boolean requireJsElement) {
        if (project == null) {
            JsFileUtil.$$$reportNull$$$0(12);
        }
        if (document == null) {
            JsFileUtil.$$$reportNull$$$0(13);
        }
        Ref result = Ref.create((Object)false);
        XDebuggerUtil.getInstance().iterateLine(project, document, line, element -> {
            if (element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                return true;
            }
            if (requireJsElement) {
                JSElement jsElement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSElement.class, (boolean)false);
                if (jsElement != null && (!inEventHandler || JsFileUtil.isInEventHandler(jsElement))) {
                    result.set((Object)true);
                    return false;
                }
            } else {
                result.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)result.get();
    }

    private static boolean isInEventHandler(@NotNull JSElement element) {
        if (element == null) {
            JsFileUtil.$$$reportNull$$$0(14);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class) != null;
    }

    public static boolean isWebKitRuntime(@NotNull WebBrowser browser) {
        if (browser == null) {
            JsFileUtil.$$$reportNull$$$0(15);
        }
        if (browser.getFamily() != BrowserFamily.CHROME) {
            return false;
        }
        String browserPath = browser.getPath();
        return browserPath != null && (browserPath.equals("node-webkit") || browserPath.endsWith("/node-webkit") || browserPath.equals("nw") || browserPath.endsWith("/nw") || browserPath.equals("nwjs") || browserPath.endsWith("/nwjs") || browserPath.endsWith("/nw.exe"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/JsFileUtil";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authority";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/JsFileUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortenedFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortenedFilePath";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "trimTitle";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNavigatable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOnBuiltInWebServer";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isOnBuiltInWebServerByAuthority";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isScript";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlOrJavaScript";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isHtmlOrTemplateFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "containsDebuggableElement";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInEventHandler";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isWebKitRuntime";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

