/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import junit.framework.ComparisonFailure;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    private static QuickFixTestCase myWrapper;

    @Override
    protected void tearDown() throws Exception {
        myWrapper = null;
        super.tearDown();
    }

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    private static void doTestFor(@NotNull String testName, @NotNull QuickFixTestCase quickFixTestCase) {
        if (testName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(0);
        }
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(1);
        }
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/" + BEFORE_PREFIX + testName;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            if (quickFixTestCase == null) {
                LightQuickFixTestCase.$$$reportNull$$$0(20);
            }
            if (testName == null) {
                LightQuickFixTestCase.$$$reportNull$$$0(21);
            }
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)CharsetToolkit.UTF8_CHARSET));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                ActionHint actionHint = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                quickFixTestCase.beforeActionStarted(testName, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(actionHint, testFullPath, testName);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName, contents);
                }
            }
            catch (ComparisonFailure e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                Assert.fail((String)(testName + " failed"));
            }
        }, "", "");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    public static void doAction(@NotNull ActionHint actionHint, String testFullPath, String testName, QuickFixTestCase quickFix) throws Exception {
        IntentionAction action;
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(2);
        }
        if ((action = actionHint.findAndCheck(quickFix.getAvailableActions(), () -> LightQuickFixTestCase.getTestInfo(testFullPath, quickFix))) != null) {
            IntentionAction afterAction;
            String text = action.getText();
            quickFix.invoke(action);
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/" + AFTER_PREFIX + testName;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
            String familyName = action.getFamilyName();
            if (StringUtil.isEmptyOrSpaces((String)familyName)) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' provides empty family name which means that user would see action with empty presentable text in Inspection Results"));
            }
        }
    }

    private static String getTestInfo(String testFullPath, QuickFixTestCase quickFix) {
        String infos = ((StreamEx)StreamEx.of(quickFix.doHighlighting()).filter(info -> info.getSeverity() != HighlightInfoType.SYMBOL_TYPE_SEVERITY)).map(info -> {
            String fixes = "";
            if (info.quickFixActionRanges != null) {
                fixes = StreamEx.of((Collection)info.quickFixActionRanges).map(p -> p.getSecond() + " " + p.getFirst()).mapLastOrElse("|- "::concat, "\\- "::concat).map(str -> "        " + str + "\n").joining();
            }
            return info.getSeverity() + ": (" + info.getStartOffset() + "," + info.getEndOffset() + ") '" + info.getText() + "': " + info.getDescription() + "\n" + fixes;
        }).joining((CharSequence)"       ");
        return "Test: " + testFullPath + "\nLanguage level: " + (Object)((Object)PsiUtil.getLanguageLevel(quickFix.getProject())) + "\n" + (quickFix.getProject().equals(LightQuickFixTestCase.getProject()) ? "SDK: " + ModuleRootManager.getInstance(LightQuickFixTestCase.getModule()).getSdk() + "\n" : "") + "Infos: " + infos;
    }

    protected void doAction(@NotNull ActionHint actionHint, String testFullPath, String testName) throws Exception {
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(3);
        }
        LightQuickFixTestCase.doAction(actionHint, testFullPath, testName, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        if (actionName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(4);
        }
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + available), (Object)action);
        LightQuickFixTestCase.invoke(action);
    }

    protected static void invoke(@NotNull IntentionAction action) throws IncorrectOperationException {
        if (action == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(5);
        }
        CodeInsightTestFixtureImpl.invokeIntention((IntentionAction)action, (PsiFile)LightQuickFixTestCase.getFile(), (Editor)LightQuickFixTestCase.getEditor(), (String)action.getText());
    }

    protected IntentionAction findActionAndCheck(@NotNull ActionHint hint, String testFullPath) {
        if (hint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(6);
        }
        return hint.findAndCheck(this.getAvailableActions(), () -> "Test: " + testFullPath);
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(7);
        }
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<IntentionAction> actions, @NotNull String text) {
        if (actions == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(8);
        }
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(9);
        }
        for (IntentionAction action : actions) {
            if (!text.equals(action.getText())) continue;
            return action;
        }
        return null;
    }

    protected void doAllTests() {
        LightQuickFixTestCase.doAllTests(this.createWrapper());
    }

    public static void doAllTests(QuickFixTestCase testCase) {
        File[] files;
        for (File file : files = LightQuickFixTestCase.getBeforeTestFiles(testCase)) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase);
        }
    }

    @NotNull
    public static File[] getBeforeTestFiles(@NotNull QuickFixTestCase testCase) {
        if (testCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(10);
        }
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase.getBasePath());
        String testDirPath = testCase.getTestDataPath().replace(File.separatorChar, '/') + testCase.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        if (files == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(11);
        }
        return files;
    }

    protected void doSingleTest(@NotNull String fileSuffix) {
        if (fileSuffix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(12);
        }
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(String fileSuffix, String testDataPath) {
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
        if (file == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(13);
        }
        if (contents == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(14);
        }
        return ActionHint.parse(file, contents);
    }

    @NotNull
    protected QuickFixTestCase createWrapper() {
        QuickFixTestCase quickFixTestCase = this.createWrapper(null);
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(15);
        }
        return quickFixTestCase;
    }

    @NotNull
    protected QuickFixTestCase createWrapper(final String testDataPath) {
        QuickFixTestCase quickFixTestCase = new QuickFixTestCase(){
            public String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            @NotNull
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                String string = this.myTestDataPath;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(2);
                }
                ActionHint actionHint = LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
                if (actionHint == null) {
                    1.$$$reportNull$$$0(3);
                }
                return actionHint;
            }

            @Override
            public void beforeActionStarted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(5);
                }
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(7);
                }
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName) throws Exception {
                if (actionHint == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (testFullPath == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (testName == null) {
                    1.$$$reportNull$$$0(10);
                }
                LightQuickFixTestCase.this.doAction(actionHint, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(@NotNull String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) throws Exception {
                if (message == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (expectedFilePath == null) {
                    1.$$$reportNull$$$0(12);
                }
                LightQuickFixTestCase.this.checkResultByFile(message, expectedFilePath, ignoreTrailingSpaces);
            }

            @Override
            public IntentionAction findActionWithText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(13);
                }
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(@NotNull IntentionAction action) {
                if (action == null) {
                    1.$$$reportNull$$$0(14);
                }
                LightQuickFixTestCase.invoke(action);
            }

            @Override
            @NotNull
            public List<HighlightInfo> doHighlighting() {
                List list = LightQuickFixTestCase.this.doHighlighting();
                if (list == null) {
                    1.$$$reportNull$$$0(15);
                }
                return list;
            }

            @Override
            @NotNull
            public List<IntentionAction> getAvailableActions() {
                List<IntentionAction> list = LightQuickFixTestCase.this.getAvailableActions();
                if (list == null) {
                    1.$$$reportNull$$$0(16);
                }
                return list;
            }

            @Override
            public void configureFromFileText(@NotNull String name, @NotNull String contents) throws IOException {
                if (name == null) {
                    1.$$$reportNull$$$0(17);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(18);
                }
                LightQuickFixTestCase.configureFromFileText((String)name, (String)contents, (boolean)true);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.getFile();
            }

            @Override
            public Project getProject() {
                return LightPlatformTestCase.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.bringRealEditorBack();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: 
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contents";
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testName";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionHint";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testFullPath";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedFilePath";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 17: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestDataPath";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseActionHintImpl";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doHighlighting";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAvailableActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "parseActionHintImpl";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeActionStarted";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "afterActionCompleted";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "doAction";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "checkResultByFile";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "findActionWithText";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 17: 
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "configureFromFileText";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 17: 
                    case 18: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(16);
        }
        return quickFixTestCase;
    }

    protected List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(LightQuickFixTestCase.getEditor(), LightQuickFixTestCase.getFile());
    }

    @NotNull
    public static List<IntentionAction> getAvailableActions(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(17);
        }
        if (file == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(18);
        }
        List list = CodeInsightTestFixtureImpl.getAvailableIntentions((Editor)editor, (PsiFile)file);
        if (list == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixTestCase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuffix";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTestFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapper";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTestFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findActionAndCheck";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findActionWithText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeTestFiles";
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doSingleTest";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseActionHintImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableActions";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTestFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 15: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

