/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.DeletedState;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.revision.TFSContentRevision;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.exceptions.TfsException;

public class TFSDiffProvider
implements DiffProvider {
    @NotNull
    private final Project myProject;

    public TFSDiffProvider(@NotNull Project project) {
        if (project == null) {
            TFSDiffProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile virtualFile) {
        FilePath localPath = TfsFileUtil.getFilePath(virtualFile);
        return this.getLastRevision(localPath);
    }

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber vcsRevisionNumber, VirtualFile virtualFile) {
        if (VcsRevisionNumber.NULL.equals(vcsRevisionNumber)) {
            return null;
        }
        FilePath path = TfsFileUtil.getFilePath(virtualFile);
        try {
            Pair<WorkspaceInfo, ExtendedItem> workspaceAndItem = TfsUtil.getWorkspaceAndExtendedItem(path, this.myProject, TFSBundle.message("loading.item", new Object[0]));
            if (workspaceAndItem == null || workspaceAndItem.second == null) {
                return null;
            }
            TfsRevisionNumber revisionNumber = (TfsRevisionNumber)vcsRevisionNumber;
            int itemId = revisionNumber.getItemId() != Integer.MIN_VALUE ? revisionNumber.getItemId() : ((ExtendedItem)workspaceAndItem.second).getItemid();
            return TFSContentRevision.create(this.myProject, (WorkspaceInfo)workspaceAndItem.first, revisionNumber.getValue(), itemId);
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException((Throwable)e), "TFS");
            return null;
        }
    }

    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile virtualFile) {
        return TfsUtil.getCurrentRevisionNumber(TfsFileUtil.getFilePath(virtualFile), this.myProject, TFSBundle.message("loading.item", new Object[0]));
    }

    public ItemLatestState getLastRevision(FilePath localPath) {
        try {
            Collection<WorkspaceInfo> workspaces = Workstation.getInstance().findWorkspaces(localPath, false, this.myProject);
            if (workspaces.isEmpty()) {
                return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
            }
            WorkspaceInfo workspace = workspaces.iterator().next();
            ExtendedItem extendedItem = workspace.getServer().getVCS().getExtendedItem(workspace.getName(), workspace.getOwnerName(), localPath, RecursionType.None, DeletedState.Any, this.myProject, TFSBundle.message("loading.item", new Object[0]));
            if (extendedItem == null) {
                return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
            }
            Item item = workspace.getServer().getVCS().queryItem(workspace.getName(), workspace.getOwnerName(), extendedItem.getSitem(), LatestVersionSpec.INSTANCE, DeletedState.Any, false, this.myProject, TFSBundle.message("loading.item", new Object[0]));
            if (item != null) {
                TfsRevisionNumber revisionNumber = new TfsRevisionNumber(item.getCs(), item.getItemid());
                return new ItemLatestState((VcsRevisionNumber)revisionNumber, item.getDid() == Integer.MIN_VALUE, false);
            }
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(e.getMessage(), (Throwable)e), "TFS");
            return new ItemLatestState(VcsRevisionNumber.NULL, false, false);
        }
    }

    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile vcsRoot) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/core/TFSDiffProvider", "<init>"));
    }
}

