/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.servertree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.PlatformIcons;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import icons.TFSIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.servertree.TfsErrorTreeNode;
import org.jetbrains.tfsIntegration.ui.servertree.TfsTreeContext;

public class TfsTreeNode
extends SimpleNode {
    private static final SimpleTextAttributes VIRTUAL_ATTRS = SimpleTextAttributes.SYNTHETIC_ATTRIBUTES;
    private final TfsTreeContext myTreeContext;
    private final String myPath;
    private final boolean myIsDirectory;
    private final boolean myVirtual;
    private final Collection<TfsTreeNode> myVirtualChildren;

    public TfsTreeNode(@NotNull Object projectOrComponent, ServerInfo server, boolean foldersOnly, @Nullable Condition<String> pathFilter) {
        if (projectOrComponent == null) {
            TfsTreeNode.$$$reportNull$$$0(0);
        }
        super(projectOrComponent instanceof Project ? (Project)projectOrComponent : null);
        this.myVirtualChildren = new ArrayList<TfsTreeNode>();
        this.myTreeContext = new TfsTreeContext(server, foldersOnly, projectOrComponent, pathFilter);
        this.myPath = "$/";
        this.myIsDirectory = true;
        this.myVirtual = false;
    }

    private TfsTreeNode(TfsTreeNode parent, String path, boolean isDirectory, boolean virtual) {
        super((SimpleNode)parent);
        this.myVirtualChildren = new ArrayList<TfsTreeNode>();
        this.myPath = path;
        this.myIsDirectory = isDirectory;
        this.myVirtual = virtual;
        this.myTreeContext = parent.myTreeContext;
    }

    public SimpleNode[] getChildren() {
        List<Item> children;
        if (!this.myIsDirectory) {
            return NO_CHILDREN;
        }
        try {
            children = this.myTreeContext.getChildItems(this.myPath);
        }
        catch (TfsException e) {
            return new SimpleNode[]{new TfsErrorTreeNode(this, e.getMessage())};
        }
        ArrayList<TfsTreeNode> result = new ArrayList<TfsTreeNode>(this.myVirtualChildren);
        for (Item childItem : children) {
            result.add(new TfsTreeNode(this, childItem.getItem(), childItem.getType() == ItemType.Folder, false));
        }
        return result.toArray(new SimpleNode[result.size()]);
    }

    protected void update(PresentationData presentation) {
        if (this.isRoot()) {
            presentation.addText(this.myTreeContext.myServer.getPresentableUri(), this.getPlainAttributes());
            presentation.setIcon(TFSIcons.Teamserver);
        } else {
            if (this.isDirectory()) {
                presentation.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
            } else {
                presentation.setIcon(FileTypeManager.getInstance().getFileTypeByFileName(this.getFileName()).getIcon());
            }
            SimpleTextAttributes attrs = this.myVirtual ? VIRTUAL_ATTRS : (this.myTreeContext.isAccepted(this.myPath) ? this.getPlainAttributes() : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            presentation.addText(this.getFileName(), attrs);
        }
    }

    public String getFileName() {
        return VersionControlPath.getLastComponent(this.myPath);
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isRoot() {
        return "$/".equals(this.myPath);
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            TfsTreeNode.$$$reportNull$$$0(1);
        }
        return string;
    }

    private TfsTreeNode createFakeChild(String name) {
        String childPath = VersionControlPath.getCombinedServerPath(this.myPath, name);
        return new TfsTreeNode(this, childPath, false, false);
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myPath};
        if (objectArray == null) {
            TfsTreeNode.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    @Nullable
    public TfsTreeNode createForSelection(String serverPath) {
        if (StringUtil.isEmpty((String)serverPath) || "$/".equals(serverPath)) {
            return this;
        }
        TfsTreeNode result = this;
        String[] components = VersionControlPath.getPathComponents(serverPath);
        for (int i = 1; i < components.length; ++i) {
            result = result.createFakeChild(components[i]);
        }
        return result;
    }

    public TfsTreeNode createVirtualSubfolder(String folderName) {
        String childPath = VersionControlPath.getCombinedServerPath(this.myPath, folderName);
        TfsTreeNode child = new TfsTreeNode(this, childPath, true, true);
        this.myVirtualChildren.add(child);
        return child;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectOrComponent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/tfsIntegration/ui/servertree/TfsTreeNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqualityObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

