/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.attributetotag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.attributetotag.AttributeToTagUsageViewDescriptor;
import com.sixrr.xrp.attributetotag.ReplaceAttributeWithTag;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.psi.XMLMutationUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AttributeToTagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String tagName;
    private final Context context;

    AttributeToTagProcessor(XmlAttribute attribute, String tagName, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.tagName = tagName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(0);
        }
        AttributeToTagUsageViewDescriptor attributeToTagUsageViewDescriptor = new AttributeToTagUsageViewDescriptor(this.attribute, usageInfos);
        if (attributeToTagUsageViewDescriptor == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(1);
        }
        return attributeToTagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            AttributeToTagProcessor.$$$reportNull$$$0(2);
        }
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        XmlTag parentTag = this.attribute.getParent();
        String existingTagName = parentTag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(existingTagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute foundAttribute;
            if (XMLMutationUtils.isSpecialJSPTag(xmlTag) || (foundAttribute = xmlTag.getAttribute(attributeName, attributeNamespace)) == null) continue;
            usages.add(new ReplaceAttributeWithTag(xmlTag, this.tagName, attributeName, attributeNamespace));
        }
    }

    protected String getCommandName() {
        return "Replace attribute " + this.attribute.getName() + " with tag";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/attributetotag/AttributeToTagProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/attributetotag/AttributeToTagProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

