/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml;

import com.intellij.diagram.DataProviderFactory;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.Utils;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.uml.UmlGraphBuilder;
import com.intellij.uml.UmlVirtualFileSystem;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphBuilderFactory {
    private UmlGraphBuilderFactory() {
    }

    public static UmlGraphBuilder create(@NotNull Project project, @NotNull DiagramProvider provider, @Nullable Object element, @Nullable VirtualFile file) {
        if (project == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            UmlGraphBuilderFactory.$$$reportNull$$$0(1);
        }
        Graph2D graph = GraphManager.getGraphManager().createGraph2D();
        Graph2DView view = GraphManager.getGraphManager().createGraph2DView(graph);
        DiagramPresentationModel presentationModel = provider.createPresentationModel(project, graph);
        if (presentationModel == null) {
            presentationModel = new DiagramPresentationModelImpl(graph, project, provider);
        }
        DiagramDataModel model = provider.createDataModel(project, element, file, presentationModel);
        final UmlGraphBuilder builder = new UmlGraphBuilder(project, graph, view, model, presentationModel);
        graph.addDataProvider((Object)"PROJECT", DataProviderFactory.create((Object)project));
        graph.addDataProvider((Object)"ORIGINAL_ELEMENT", DataProviderFactory.create((Object)element));
        graph.addDataProvider((Object)"GRAPH_BUILDER", DataProviderFactory.create((Object)((Object)builder)));
        builder.putUserData(Utils.UML_PROVIDER, provider);
        model.putUserData(Utils.GRAPH_BUILDER, (Object)builder);
        if (file instanceof UmlVirtualFileSystem.UmlVirtualFile) {
            ((UmlVirtualFileSystem.UmlVirtualFile)file).addBuilder(builder);
            builder.putUserData(UmlGraphBuilder.EDITOR_FILE, file);
        }
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                if (e.isNodeSelection()) {
                    builder.getGraphPresentationModel().onSelectionChanged(e);
                }
            }
        });
        return builder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
        }
        objectArray[1] = "com/intellij/uml/UmlGraphBuilderFactory";
        objectArray[2] = "create";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

