/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.javascript.debugger.nashorn.NashornArray;
import com.intellij.javascript.debugger.nashorn.NashornDebuggerSupportWrapper;
import com.intellij.javascript.debugger.nashorn.NashornFunction;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

class NashornObject
extends ObjectValueBase<JdiValueManager> {
    protected final ObjectReference objectReference;
    private final String valueString;
    protected final ThreadReference threadReference;
    private final VariablesHost<JdiValueManager> childrenManager;

    @NotNull
    protected VariablesHost<JdiValueManager> getChildrenManager() {
        VariablesHost<JdiValueManager> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            NashornObject.$$$reportNull$$$0(0);
        }
        return variablesHost;
    }

    public NashornObject(@NotNull ValueType type, @NotNull ObjectReference objectReference, @Nullable String valueString, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager) {
        if (type == null) {
            NashornObject.$$$reportNull$$$0(1);
        }
        if (objectReference == null) {
            NashornObject.$$$reportNull$$$0(2);
        }
        if (threadReference == null) {
            NashornObject.$$$reportNull$$$0(3);
        }
        if (valueManager == null) {
            NashornObject.$$$reportNull$$$0(4);
        }
        super(type);
        this.objectReference = objectReference;
        this.threadReference = threadReference;
        this.valueString = valueString;
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                final AsyncPromise promise = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new DebuggerContextCommandImpl(((JdiValueManager)this.valueManager).getDebugProcess().getDebuggerContext()){

                    public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                        if (suspendContext == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.updateCacheStamp();
                        try {
                            promise.setResult(NashornObject.loadVariables(new ArrayList<Variable>(), NashornObject.this.objectReference, NashornObject.this.threadReference, (JdiValueManager)valueManager, null));
                        }
                        catch (Exception e) {
                            promise.setError((Throwable)e);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/javascript/debugger/nashorn/NashornObject$1$1", "threadAction"));
                    }
                });
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    1.$$$reportNull$$$0(0);
                }
                return asyncPromise;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/NashornObject$1", "load"));
            }
        };
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    @Nullable
    public String getValueString() {
        return this.valueString;
    }

    static List<Variable> loadVariables(@NotNull List<Variable> variables, @NotNull ObjectReference parent, @NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager, @Nullable Set<String> existingVariables) throws Exception {
        NashornDebuggerSupportWrapper debuggerSupport;
        ArrayReference properties;
        if (variables == null) {
            NashornObject.$$$reportNull$$$0(5);
        }
        if (parent == null) {
            NashornObject.$$$reportNull$$$0(6);
        }
        if (threadReference == null) {
            NashornObject.$$$reportNull$$$0(7);
        }
        if (valueManager == null) {
            NashornObject.$$$reportNull$$$0(8);
        }
        if ((properties = (debuggerSupport = NashornDebuggerSupportWrapper.get(threadReference, valueManager)).getProperties(parent, threadReference)).length() == 0) {
            return Collections.emptyList();
        }
        for (com.sun.jdi.Value valueDescription : properties.getValues()) {
            Map<Field, com.sun.jdi.Value> fieldToValue = debuggerSupport.getValues((ObjectReference)valueDescription);
            String name = debuggerSupport.getName(fieldToValue);
            if (existingVariables != null && existingVariables.contains(name)) continue;
            variables.add((Variable)new VariableImpl(name, NashornObject.createValue(threadReference, valueManager, debuggerSupport, fieldToValue), null));
        }
        return variables;
    }

    static Value createValue(@NotNull ThreadReference threadReference, @NotNull JdiValueManager valueManager, @NotNull NashornDebuggerSupportWrapper debuggerSupport, @NotNull Map<Field, com.sun.jdi.Value> fieldToValue) {
        int type;
        if (threadReference == null) {
            NashornObject.$$$reportNull$$$0(9);
        }
        if (valueManager == null) {
            NashornObject.$$$reportNull$$$0(10);
        }
        if (debuggerSupport == null) {
            NashornObject.$$$reportNull$$$0(11);
        }
        if (fieldToValue == null) {
            NashornObject.$$$reportNull$$$0(12);
        }
        if ((type = debuggerSupport.getType(fieldToValue)) == -1) {
            return valueManager.createValue(debuggerSupport.getValue(fieldToValue));
        }
        ValueType valueType = ValueType.Companion.fromIndex(type);
        switch (valueType) {
            case BOOLEAN: 
            case NUMBER: 
            case STRING: {
                return new PrimitiveValue(valueType, debuggerSupport.getStringValue(fieldToValue));
            }
            case NULL: {
                return PrimitiveValue.NULL;
            }
            case UNDEFINED: {
                return PrimitiveValue.UNDEFINED;
            }
            case OBJECT: 
            case FUNCTION: 
            case ARRAY: {
                ObjectReference reference = debuggerSupport.getValue(fieldToValue);
                Object value = valueManager.getCachedValue(reference);
                if (value == null) {
                    value = valueType == ValueType.OBJECT ? new NashornObject(valueType, reference, null, threadReference, valueManager) : (valueType == ValueType.ARRAY ? new NashornArray(debuggerSupport.getLength(fieldToValue), reference, null, threadReference, valueManager) : new NashornFunction(reference, debuggerSupport.getStringValue(fieldToValue), threadReference, valueManager));
                    value = valueManager.getOrCacheValue(reference, (Value)value);
                }
                return value;
            }
        }
        throw new IllegalArgumentException(valueType.name());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/debugger/nashorn/NashornObject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectReference";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadReference";
                break;
            }
            case 4: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerSupport";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldToValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/debugger/nashorn/NashornObject";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadVariables";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

