/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.weblogic.beaInstallation;

import com.intellij.javaee.weblogic.beaInstallation.BeaDomain;
import com.intellij.javaee.weblogic.beaInstallation.BeaServer;
import com.intellij.javaee.weblogic.model.WeblogicEjbJar;
import com.intellij.javaee.weblogic.model.WeblogicEnterpriseBean;
import com.intellij.javaee.weblogic.model.persistence.FieldGroup;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsBean;
import com.intellij.javaee.weblogic.model.persistence.WeblogicRdbmsJar;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeblogicUtil {
    @NonNls
    private static final String CONFIG_DIR = "config";
    @NonNls
    private static final String CONFIG_XML = "config.xml";
    private static final File[] CANDIDATES = new File[]{new File("/bea"), new File("C:/bea"), new File("D:/bea"), new File("/usr/local/bea")};
    @NonNls
    private static final String DOMAIN_ELEMENT_NAME = "Domain";
    @NonNls
    private static final String DOMAIN_9X_ELEMENT_NAME = "domain";
    @NonNls
    private static final String SERVER_ELEMENT_NAME = "Server";
    @NonNls
    private static final String SERVER_9X_ELEMENT_NAME = "server";
    @NonNls
    private static final String NAME_9X_ELEMENT_NAME = "name";
    @NonNls
    private static final String CONFIGURATION_VERSION_9X_ELEMENT_NAME = "configuration-version";
    @NonNls
    private static final String CONFIGURATION_VERSION_ATTRIBUTE_NAME = "ConfigurationVersion";
    @NonNls
    private static final String NAME2_ATTR = "Name";
    @NonNls
    private static final String LISTEN_PORT_ATTR = "ListenPort";
    @NonNls
    private static final String LISTEN_PORT_9X_ELEMENT_NAME = "listen-port";
    @NonNls
    private static final String ADMIN_SERVER_NAME_CHILD = "admin-server-name";
    private static final Set<Namespace> WL9_OR_LATER_CONFIG_NAMESPACES = new HashSet<Namespace>(Arrays.asList(Namespace.getNamespace((String)"http://xmlns.oracle.com/weblogic/domain"), Namespace.getNamespace((String)"http://www.bea.com/ns/weblogic/config"), Namespace.getNamespace((String)"http://www.bea.com/ns/weblogic/90/domain"), Namespace.getNamespace((String)"http://www.bea.com/ns/weblogic/920/domain")));
    @NonNls
    private static final String APPLICATIONS_DIR_7x8x = "applications";
    @NonNls
    private static final String SERVERS_DIR = "servers";
    @NonNls
    private static final String LOGS_DIR = "logs";
    @NonNls
    private static final String LOG_SUFFIX = ".log";
    @NonNls
    private static final String ADMIN_CMD_FILE = "startWebLogic.cmd";
    @NonNls
    private static final String ADMIN_SH_FILE = "startWebLogic.sh";
    @NonNls
    private static final String MANAGED_CMD_FILE = "bin" + File.separator + "startManagedWebLogic.cmd";
    @NonNls
    private static final String MANAGED_SH_FILE = "bin" + File.separator + "startManagedWebLogic.sh";
    @NonNls
    private static final String ADMIN_SHUTDOWN_CMD_FILE = "bin" + File.separator + "stopWebLogic.cmd";
    @NonNls
    private static final String ADMIN_SHUTDOWN_SH_FILE = "bin" + File.separator + "stopWebLogic.sh";
    @NonNls
    private static final String MANAGED_SHUTDOWN_CMD_FILE = "bin" + File.separator + "stopManagedWebLogic.cmd";
    @NonNls
    private static final String MANAGED_SHUTDOWN_SH_FILE = "bin" + File.separator + "stopManagedWebLogic.sh";
    @NonNls
    private static final String APPLICATIONS_DIR_9x = "autodeploy";
    private static File[] ourBeaRootCandidates;
    private static final Map<File, Pair<Long, BeaDomain>> ourCachedDomains;

    private WeblogicUtil() {
    }

    private static File[] getBeaRootCandidates() {
        if (ourBeaRootCandidates == null) {
            ArrayList<File> roots = new ArrayList<File>();
            HashSet<String> rootPaths = new HashSet<String>();
            for (File candidate : CANDIDATES) {
                try {
                    String newPath = candidate.getCanonicalPath();
                    if (rootPaths.contains(newPath)) continue;
                    rootPaths.add(newPath);
                    roots.add(candidate);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourBeaRootCandidates = roots.toArray(new File[roots.size()]);
        }
        return ourBeaRootCandidates;
    }

    public static BeaDomain[] loadDomains(File location) {
        HashSet<File> configXmlFiles = new HashSet<File>();
        File userProjects = new File(location, "user_projects");
        if (userProjects.isDirectory()) {
            WeblogicUtil.findAllConfigs(configXmlFiles, userProjects, 2);
        }
        HashSet<BeaDomain> domains = new HashSet<BeaDomain>();
        for (File configXmlFile : configXmlFiles) {
            BeaDomain validDomain = WeblogicUtil.createValidDomainByConfigFile(configXmlFile);
            if (validDomain == null) continue;
            domains.add(validDomain);
        }
        return domains.toArray(new BeaDomain[domains.size()]);
    }

    @Nullable
    public static BeaDomain createValidDomain(File domainLocation) {
        File configXml = new File(domainLocation, CONFIG_XML);
        if (configXml.exists()) {
            return WeblogicUtil.createValidDomainByConfigFile(configXml);
        }
        configXml = new File(domainLocation, CONFIG_DIR + File.separator + CONFIG_XML);
        if (configXml.exists()) {
            return WeblogicUtil.createValidDomainByConfigFile(configXml);
        }
        return null;
    }

    @NotNull
    public static BeaDomain createDomain(File domainLocation) {
        BeaDomain validDomain = WeblogicUtil.createValidDomain(domainLocation);
        if (validDomain == null) {
            String name = domainLocation.getName();
            validDomain = WeblogicUtil.createBeaDomain7xOr8x(name, null, domainLocation, WeblogicUtil.createServer(domainLocation, name, null, false, true));
        }
        BeaDomain beaDomain = validDomain;
        if (beaDomain == null) {
            WeblogicUtil.$$$reportNull$$$0(0);
        }
        return beaDomain;
    }

    @Nullable
    public static BeaDomain createValidDomainByConfigFile(File configFile) {
        if (!configFile.isFile()) {
            return null;
        }
        Pair<Long, BeaDomain> pair = ourCachedDomains.get(configFile);
        if (pair != null && configFile.lastModified() == ((Long)pair.getFirst()).longValue()) {
            return (BeaDomain)pair.getSecond();
        }
        BeaDomain beaDomain = WeblogicUtil.computeValidDomainByConfigFile(configFile);
        if (beaDomain != null) {
            ourCachedDomains.put(configFile, (Pair<Long, BeaDomain>)Pair.create((Object)configFile.lastModified(), (Object)beaDomain));
        }
        return beaDomain;
    }

    @Nullable
    private static BeaDomain computeValidDomainByConfigFile(File configFile) {
        try {
            Element rootElement = JDOMUtil.load((File)configFile);
            if (WL9_OR_LATER_CONFIG_NAMESPACES.contains(rootElement.getNamespace())) {
                return WeblogicUtil.createValidDomainFor9x(configFile, rootElement);
            }
            return WeblogicUtil.createValidDomainFor7xOr8x(configFile, rootElement);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    private static BeaDomain createValidDomainFor7xOr8x(File configFile, Element rootElement) {
        if (!rootElement.getName().equals(DOMAIN_ELEMENT_NAME)) {
            return null;
        }
        String name = rootElement.getAttributeValue(NAME2_ATTR);
        if (name == null) {
            return null;
        }
        File location = configFile.getParentFile();
        List serverElements = rootElement.getChildren(SERVER_ELEMENT_NAME);
        ArrayList<BeaServer> servers = new ArrayList<BeaServer>(serverElements.size());
        for (Element serverElement : serverElements) {
            String listenPort = serverElement.getAttributeValue(LISTEN_PORT_ATTR);
            String serverName = serverElement.getAttributeValue(NAME2_ATTR);
            if (serverName == null || listenPort == null) continue;
            servers.add(WeblogicUtil.createServer(location, serverName, listenPort, false, true));
        }
        if (servers.isEmpty()) {
            return null;
        }
        String version = rootElement.getAttributeValue(CONFIGURATION_VERSION_ATTRIBUTE_NAME);
        return WeblogicUtil.createBeaDomain7xOr8x(name, version, location, servers.toArray(new BeaServer[servers.size()]));
    }

    @Nullable
    private static BeaDomain createValidDomainFor9x(File configFile, Element rootElement) {
        Namespace namespace = rootElement.getNamespace();
        if (!rootElement.getName().equals(DOMAIN_9X_ELEMENT_NAME)) {
            return null;
        }
        String name = rootElement.getChildText(NAME_9X_ELEMENT_NAME, namespace);
        if (name == null) {
            return null;
        }
        String version = rootElement.getChildText(CONFIGURATION_VERSION_9X_ELEMENT_NAME, namespace);
        String adminServerName = rootElement.getChildText(ADMIN_SERVER_NAME_CHILD, namespace);
        List serverElements = rootElement.getChildren(SERVER_9X_ELEMENT_NAME, namespace);
        File domainHome = configFile.getParentFile().getParentFile();
        ArrayList<BeaServer> servers = new ArrayList<BeaServer>();
        for (Element serverElement : serverElements) {
            String serverName = serverElement.getChildText(NAME_9X_ELEMENT_NAME, namespace);
            String listenPort = serverElement.getChildText(LISTEN_PORT_9X_ELEMENT_NAME, namespace);
            if (serverName == null) continue;
            boolean isAdmin = serverName.equals(adminServerName);
            servers.add(WeblogicUtil.createServer(domainHome, serverName, listenPort, true, isAdmin));
        }
        if (servers.isEmpty()) {
            return null;
        }
        return WeblogicUtil.createBeaDomain9x(name, version, domainHome, servers.toArray(new BeaServer[servers.size()]));
    }

    private static BeaServer createServer(File domainHome, String name, String port, boolean is9x, boolean isAdmin) {
        String pathToLog = is9x ? SERVERS_DIR + File.separator + name + File.separator + LOGS_DIR + File.separator + name + LOG_SUFFIX : name + File.separator + name + LOG_SUFFIX;
        int listenPort = port == null ? 7001 : Integer.parseInt(port);
        return new BeaServer(name, listenPort, isAdmin, new File(domainHome, pathToLog));
    }

    private static BeaDomain createBeaDomain9x(String name, String version, File domainHome, BeaServer[] servers) {
        return new BeaDomain(name, version, domainHome, new File(domainHome, LOGS_DIR + File.separator + name + LOG_SUFFIX), new File(domainHome, WeblogicUtil.getDefaultAdminStartupFileName()), new File(domainHome, WeblogicUtil.getDefaultManagedStartupFileName()), new File(domainHome, WeblogicUtil.getDefaultAdminShutdownFileName()), new File(domainHome, WeblogicUtil.getDefaultManagedShutdownFileName()), new File(domainHome, APPLICATIONS_DIR_9x), servers);
    }

    private static BeaDomain createBeaDomain7xOr8x(String name, String version, File location, BeaServer ... servers) {
        return new BeaDomain(name, version, location, new File(location, LOGS_DIR + File.separator + name + LOG_SUFFIX), new File(location, WeblogicUtil.getDefaultAdminStartupFileName()), new File(location, WeblogicUtil.getDefaultAdminStartupFileName()), null, null, new File(location, APPLICATIONS_DIR_7x8x), servers);
    }

    private static void findAllConfigs(Collection<File> result, File location, int level) {
        if (level < 0) {
            return;
        }
        File[] files = location.listFiles();
        if (files == null) {
            return;
        }
        File configFile = new File(new File(location, CONFIG_DIR), CONFIG_XML);
        if (configFile.exists()) {
            result.add(configFile);
            return;
        }
        configFile = new File(location, CONFIG_XML);
        if (configFile.exists()) {
            result.add(configFile);
            return;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            WeblogicUtil.findAllConfigs(result, file, level - 1);
        }
    }

    private static String getDefaultAdminStartupFileName() {
        return SystemInfo.isWindows ? ADMIN_CMD_FILE : ADMIN_SH_FILE;
    }

    private static String getDefaultManagedStartupFileName() {
        return SystemInfo.isWindows ? MANAGED_CMD_FILE : MANAGED_SH_FILE;
    }

    public static String getDefaultAdminShutdownFileName() {
        return SystemInfo.isWindows ? ADMIN_SHUTDOWN_CMD_FILE : ADMIN_SHUTDOWN_SH_FILE;
    }

    public static String getDefaultManagedShutdownFileName() {
        return SystemInfo.isWindows ? MANAGED_SHUTDOWN_CMD_FILE : MANAGED_SHUTDOWN_SH_FILE;
    }

    @Nullable
    public static WeblogicRdbmsBean findRdbmsBean(@Nullable WeblogicRdbmsJar rdbmsRootDescriptor, @Nullable String ejbName) {
        if (ejbName == null || rdbmsRootDescriptor == null) {
            return null;
        }
        return (WeblogicRdbmsBean)ContainerUtil.find(rdbmsRootDescriptor.getWeblogicRdbmsBeans(), object -> ejbName.equals(object.getEjbName().getStringValue()));
    }

    @Nullable
    public static WeblogicEnterpriseBean findEnterpriseBean(WeblogicEjbJar ejbRootDescriptor, String ejbName) {
        return ejbName == null ? null : (WeblogicEnterpriseBean)ContainerUtil.find(ejbRootDescriptor.getWeblogicEnterpriseBeans(), object -> ejbName.equals(object.getEjbName().getStringValue()));
    }

    public static void setCmpFields(FieldGroup fieldGroup, List<String> fields) {
        for (GenericDomValue<String> value : fieldGroup.getCmpFields()) {
            value.undefine();
        }
        for (String field : fields) {
            fieldGroup.addCmpField().setValue((Object)field);
        }
    }

    static {
        ourCachedDomains = new HashMap<File, Pair<Long, BeaDomain>>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/weblogic/beaInstallation/WeblogicUtil", "createDomain"));
    }
}

