/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.javafx;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import javax.swing.JComponent;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.settings.MarkdownApplicationSettings;
import org.intellij.plugins.markdown.settings.MarkdownPreviewSettings;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanelProvider;
import org.intellij.plugins.markdown.ui.preview.javafx.JavaFxHtmlPanelProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFxCouldBeEnabledNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"Markdown JavaFX Preview Could Be Enabled");
    private static final String DONT_ASK_TO_CHANGE_PROVIDER_TYPE_KEY = "markdown.do.not.ask.to.change.preview.provider";

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            JavaFxCouldBeEnabledNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            JavaFxCouldBeEnabledNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            JavaFxCouldBeEnabledNotificationProvider.$$$reportNull$$$0(2);
        }
        if (file.getFileType() != MarkdownFileType.INSTANCE) {
            return null;
        }
        if (PropertiesComponent.getInstance().getBoolean(DONT_ASK_TO_CHANGE_PROVIDER_TYPE_KEY)) {
            return null;
        }
        MarkdownApplicationSettings markdownApplicationSettings = MarkdownApplicationSettings.getInstance();
        MarkdownPreviewSettings oldPreviewSettings = markdownApplicationSettings.getMarkdownPreviewSettings();
        if (oldPreviewSettings.getHtmlPanelProviderInfo().getClassName().equals(JavaFxHtmlPanelProvider.class.getName())) {
            return null;
        }
        MarkdownHtmlPanelProvider.AvailabilityInfo availabilityInfo = new JavaFxHtmlPanelProvider().isAvailable();
        if (availabilityInfo == MarkdownHtmlPanelProvider.AvailabilityInfo.UNAVAILABLE) {
            return null;
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(MarkdownBundle.message("markdown.javafx.inspection.description", new Object[0]));
        panel.createActionLabel(MarkdownBundle.message("markdown.javafx.inspection.description.yes", new Object[0]), () -> {
            boolean isSuccess = availabilityInfo.checkAvailability((JComponent)panel);
            if (isSuccess) {
                markdownApplicationSettings.setMarkdownPreviewSettings(new MarkdownPreviewSettings(oldPreviewSettings.getSplitEditorLayout(), new JavaFxHtmlPanelProvider().getProviderInfo(), oldPreviewSettings.isUseGrayscaleRendering(), oldPreviewSettings.isAutoScrollPreview()));
                EditorNotifications.updateAll();
            } else {
                Logger.getInstance(JavaFxCouldBeEnabledNotificationProvider.class).warn("Could not install and apply OpenJFX");
            }
        });
        panel.createActionLabel(MarkdownBundle.message("markdown.javafx.inspection.description.hide", new Object[0]), () -> panel.setVisible(false));
        panel.createActionLabel(MarkdownBundle.message("markdown.javafx.inspection.description.dont.ask.again", new Object[0]), () -> {
            PropertiesComponent.getInstance().setValue(DONT_ASK_TO_CHANGE_PROVIDER_TYPE_KEY, true);
            EditorNotifications.updateAll();
        });
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxCouldBeEnabledNotificationProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/javafx/JavaFxCouldBeEnabledNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

