/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.idea.RareLogger;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.execution.TsLintOutputJsonParser;
import com.intellij.lang.javascript.linter.tslint.execution.TsLinterError;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintFixErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.commands.TsLintGetErrorsCommand;
import com.intellij.lang.javascript.linter.tslint.service.protocol.TsLintLanguageServiceProtocol;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TsLintLanguageService
extends JSLanguageServiceBase {
    @NotNull
    private static final Logger LOG = RareLogger.wrap((Logger)Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService"), (boolean)false);
    @NotNull
    private final TsLintConfigFileSearcher myConfigFileSearcher;

    @NotNull
    public static TsLintLanguageService getService(@NotNull Project project) {
        if (project == null) {
            TsLintLanguageService.$$$reportNull$$$0(0);
        }
        TsLintLanguageService tsLintLanguageService = (TsLintLanguageService)((Object)ServiceManager.getService((Project)project, TsLintLanguageService.class));
        if (tsLintLanguageService == null) {
            TsLintLanguageService.$$$reportNull$$$0(1);
        }
        return tsLintLanguageService;
    }

    public TsLintLanguageService(@NotNull Project project) {
        if (project == null) {
            TsLintLanguageService.$$$reportNull$$$0(2);
        }
        super(project);
        this.myConfigFileSearcher = new TsLintConfigFileSearcher();
    }

    @NotNull
    protected String getProcessName() {
        if ("TSLint" == null) {
            TsLintLanguageService.$$$reportNull$$$0(3);
        }
        return "TSLint";
    }

    public final Future<List<TsLinterError>> highlight(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config, @Nullable String content) {
        MyParameters parameters = MyParameters.checkParameters(virtualFile, config);
        if (parameters.getErrors() != null) {
            return new FixedFuture(parameters.getErrors());
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture(Collections.singletonList(new TsLinterError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)this))));
        }
        TsLintGetErrorsCommand command = new TsLintGetErrorsCommand(parameters.getPath(), parameters.getConfigPath(), StringUtil.notNullize((String)content));
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(parameters.getPath()));
    }

    public final Future<List<TsLinterError>> highlightAndFix(@Nullable VirtualFile virtualFile, @NotNull TsLintState state) {
        VirtualFile config;
        MyParameters parameters;
        if (state == null) {
            TsLintLanguageService.$$$reportNull$$$0(4);
        }
        if ((parameters = MyParameters.checkParameters(virtualFile, config = virtualFile == null ? null : this.myConfigFileSearcher.getConfig(state, virtualFile))).getErrors() != null) {
            return new FixedFuture(parameters.getErrors());
        }
        JSLanguageServiceQueue process = this.getProcess();
        if (process == null) {
            return new FixedFuture(Collections.singletonList(new TsLinterError(JSLanguageServiceUtil.getLanguageServiceCreationError((LinterLanguageServiceClient)this))));
        }
        TsLintFixErrorsCommand command = new TsLintFixErrorsCommand(parameters.getPath(), parameters.getConfigPath());
        return process.execute((JSLanguageServiceCommand)command, TsLintLanguageService.createHighlightProcessor(parameters.getPath()));
    }

    @NotNull
    private static JSLanguageServiceCommandProcessor<List<TsLinterError>> createHighlightProcessor(@NotNull String path) {
        if (path == null) {
            TsLintLanguageService.$$$reportNull$$$0(5);
        }
        JSLanguageServiceCommandProcessor jSLanguageServiceCommandProcessor = (object, answer) -> {
            if (path == null) {
                TsLintLanguageService.$$$reportNull$$$0(10);
            }
            return TsLintLanguageService.parseResults(answer, path);
        };
        if (jSLanguageServiceCommandProcessor == null) {
            TsLintLanguageService.$$$reportNull$$$0(6);
        }
        return jSLanguageServiceCommandProcessor;
    }

    @Nullable
    private static List<TsLinterError> parseResults(@NotNull JSLanguageServiceAnswer answer, @NotNull String path) {
        JsonObject element;
        JsonElement error;
        if (answer == null) {
            TsLintLanguageService.$$$reportNull$$$0(7);
        }
        if (path == null) {
            TsLintLanguageService.$$$reportNull$$$0(8);
        }
        if ((error = (element = answer.getElement()).get("error")) != null) {
            return Collections.singletonList(new TsLinterError(error.getAsString()));
        }
        JsonElement body = TsLintLanguageService.parseBody(element);
        if (body == null) {
            return null;
        }
        String version = element.get("version").getAsString();
        SemVer tsLintVersion = SemVer.parseFromText((String)version);
        boolean isZeroBased = TsLintOutputJsonParser.isVersionZeroBased(tsLintVersion);
        TsLintOutputJsonParser parser = new TsLintOutputJsonParser(path, body, isZeroBased);
        return ContainerUtil.newArrayList(parser.getErrors());
    }

    private static JsonElement parseBody(@NotNull JsonObject element) {
        JsonElement body;
        if (element == null) {
            TsLintLanguageService.$$$reportNull$$$0(9);
        }
        if ((body = element.get("body")) == null) {
            return null;
        }
        if (body.isJsonPrimitive() && body.getAsJsonPrimitive().isString()) {
            String bodyContent = StringUtil.unquoteString((String)body.getAsJsonPrimitive().getAsString());
            if (!StringUtil.isEmptyOrSpaces((String)bodyContent)) {
                try {
                    return new JsonParser().parse(bodyContent);
                }
                catch (JsonParseException e) {
                    LOG.info(String.format("Problem parsing body: '%s'\n%s", body, e.getMessage()), (Throwable)e);
                }
            }
        } else {
            LOG.info(String.format("Error body type, should be a string with json inside. Body:'%s'", body.getAsString()));
        }
        return null;
    }

    protected final JSLanguageServiceQueue createLanguageServiceQueue() {
        TsLintLanguageServiceProtocol protocol = new TsLintLanguageServiceProtocol(this.myProject, el -> {});
        return new JSLanguageServiceQueueImpl(this.myProject, (JSLanguageServiceProtocol)protocol, this.myProcessConnector, this.myDefaultReporter, (JSLanguageServiceCacheData)new JSLanguageServiceDefaultCacheData());
    }

    protected final boolean needInitToolWindow() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "highlightAndFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseResults";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseBody";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createHighlightProcessor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyParameters {
        @NotNull
        private final String myConfigPath;
        @NotNull
        private final String myPath;
        @Nullable
        private final List<TsLinterError> myErrors;

        private MyParameters(@NotNull String path, @NotNull String configPath, @Nullable List<TsLinterError> errors) {
            if (path == null) {
                MyParameters.$$$reportNull$$$0(0);
            }
            if (configPath == null) {
                MyParameters.$$$reportNull$$$0(1);
            }
            this.myConfigPath = configPath;
            this.myPath = path;
            this.myErrors = errors;
        }

        public static MyParameters checkParameters(@Nullable VirtualFile virtualFile, @Nullable VirtualFile config) {
            String error;
            if (config == null) {
                error = "Config file was not found.";
            } else if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
                error = "Path not specified";
            } else {
                String configPath = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)config);
                String path = JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks((VirtualFile)virtualFile);
                if (configPath != null && path != null) {
                    return new MyParameters(path, configPath, null);
                }
                error = "Can not work with the path: " + (path != null ? path : configPath);
            }
            return new MyParameters("", "", Collections.singletonList(new TsLinterError(error)));
        }

        @NotNull
        public String getConfigPath() {
            String string = this.myConfigPath;
            if (string == null) {
                MyParameters.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getPath() {
            String string = this.myPath;
            if (string == null) {
                MyParameters.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public List<TsLinterError> getErrors() {
            return this.myErrors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/service/TsLintLanguageService$MyParameters";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

