/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.actions.ruleset.CreateStyleCallback;
import com.intellij.psi.css.actions.ruleset.CssSelectTargetPopupFactory;
import com.intellij.psi.css.actions.ruleset.StyleCreator;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.HtmlUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractInlineCssAction
extends BaseRefactoringIntentionAction {
    public static final Key<StyleCreator> EXPLICITLY_CHOSEN_STYLE_CREATOR = new Key("EXPLICITLY_CHOSEN_STYLE_CREATOR");
    public static final Key<String> EXPLICITLY_CHOSEN_SELECTOR = new Key("EXPLICITLY_CHOSEN_SELECTOR");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.css.actions.extract.ExtractInlineCssAction");
    private static final String EXTRACT_INLINE_CSS_ID_STRING = "extractInlineCss";

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile containingFile;
        if (project == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(1);
        }
        if ((containingFile = element.getContainingFile()) == null || !CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)containingFile)) {
            return false;
        }
        CssBlock cssBlock = (CssBlock)PsiTreeUtil.getParentOfType((PsiElement)element, CssBlock.class);
        return cssBlock != null && cssBlock.getParent() instanceof XmlAttributeValue;
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(4);
        }
        final PsiFile file = element.getContainingFile();
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssDeclaration.class});
        final CssBlock block = (CssBlock)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{CssBlock.class});
        if (!ApplicationManager.getApplication().isUnitTestMode() && declaration != null && block != null && block.getDeclarations().length > 1) {
            IntroduceTargetChooser.showChooser((Editor)editor, (List)Lists.newArrayList((Object[])new CssElement[]{declaration, block}), (Pass)new Pass<CssElement>(){

                public void pass(CssElement expression) {
                    CssDeclaration[] cssDeclarationArray;
                    if (expression instanceof CssBlock) {
                        cssDeclarationArray = ((CssBlock)expression).getDeclarations();
                    } else {
                        CssDeclaration[] cssDeclarationArray2 = new CssDeclaration[1];
                        cssDeclarationArray = cssDeclarationArray2;
                        cssDeclarationArray2[0] = (CssDeclaration)expression;
                    }
                    ExtractInlineCssAction.this.extractDeclarations(project, editor, file, block, cssDeclarationArray);
                }
            }, PsiElement::getText);
        } else if (block != null) {
            this.extractDeclarations(project, editor, file, block, block.getDeclarations());
        } else {
            this.showExtractErrorMessage(project, editor);
        }
    }

    private void extractDeclarations(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file, @NotNull CssBlock ownerBlock, final @NotNull CssDeclaration[] declarations) {
        if (project == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(6);
        }
        if (file == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(7);
        }
        if (ownerBlock == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(8);
        }
        if (declarations == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(9);
        }
        if (declarations.length == 0) {
            return;
        }
        final List<String> selectorNameCandidates = AbstractTagUtil.getPossibleSelectorsForTag(AbstractTagUtil.findInjectionHostTagByCssElement((CssElement)ownerBlock));
        final String defaultSelectorValue = (String)Iterables.getFirst(selectorNameCandidates, (Object)".class");
        XmlAttribute styleAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)ownerBlock, XmlAttribute.class);
        if (styleAttribute == null) {
            this.showExtractErrorMessage(project, editor);
            return;
        }
        final ExtractInlineCssCallback createStyleCallback = new ExtractInlineCssCallback(project, ownerBlock, declarations, styleAttribute, editor);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StyleCreator styleCreator = (StyleCreator)project.getUserData(EXPLICITLY_CHOSEN_STYLE_CREATOR);
            String selector = StringUtil.notNullize((String)((String)project.getUserData(EXPLICITLY_CHOSEN_SELECTOR)), (String)defaultSelectorValue);
            assert (styleCreator != null);
            styleCreator.createStyleDeclarationInteractively(editor, selector, Lists.newArrayList((Object[])new String[]{selector}), createStyleCallback, declarations);
            return;
        }
        CssSelectTargetPopupFactory.createSelectTargetPopup(this.getText(), file, new Pass<StyleCreator>(){

            public void pass(@Nullable StyleCreator creator) {
                CommandProcessor.getInstance().executeCommand(project, () -> {
                    if (editor == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (declarations == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    LOG.assertTrue(creator != null);
                    creator.createStyleDeclarationInteractively(editor, defaultSelectorValue, selectorNameCandidates, createStyleCallback, declarations);
                }, ExtractInlineCssAction.this.getText(), (Object)ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, editor.getDocument());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "declarations";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/css/actions/ExtractInlineCssAction$2";
                objectArray[2] = "lambda$pass$0";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).showInBestPositionFor(editor);
    }

    @NotNull
    public String getText() {
        String string = CssBundle.message((String)"css.extract.embedded.css.action", (Object[])new Object[0]);
        if (string == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CssBundle.message((String)"css.extract.embedded.css.family", (Object[])new Object[0]);
        if (string == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static void deleteSourceDeclarations(@NotNull CssBlock ownerBlock, CssDeclaration ... declarations) {
        if (ownerBlock == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(12);
        }
        if (declarations == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(13);
        }
        for (CssDeclaration declaration : declarations) {
            PsiElement semicolon = PsiTreeUtil.nextVisibleLeaf((PsiElement)declaration);
            if (semicolon != null && semicolon.getNode().getElementType() == CssElementTypes.CSS_SEMICOLON) {
                ownerBlock.deleteChildRange((PsiElement)declaration, semicolon);
                continue;
            }
            declaration.delete();
        }
    }

    private static void cleanUpXmlAfterExtracting(@NotNull String selectorText, @NotNull XmlAttribute attribute) {
        XmlTag tag;
        if (selectorText == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(14);
        }
        if (attribute == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(15);
        }
        if ((tag = attribute.getParent()) != null) {
            ExtractInlineCssAction.appendMissingIdOrClassDeclarations(tag, selectorText);
            String value = attribute.getValue();
            if (value == null || value.trim().isEmpty()) {
                PsiElement prevSibling = attribute.getPrevSibling();
                if (prevSibling instanceof PsiWhiteSpace) {
                    tag.deleteChildRange(prevSibling, (PsiElement)attribute);
                } else {
                    attribute.delete();
                }
            } else {
                CodeEditUtil.markToReformat((ASTNode)attribute.getNode(), (boolean)true);
            }
        }
    }

    private static void appendMissingIdOrClassDeclarations(@NotNull XmlTag parent, String newSelectorName) {
        if (parent == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(16);
        }
        StringTokenizer st = new StringTokenizer(newSelectorName, "#.", true);
        boolean _class = false;
        boolean _id = false;
        block3: while (st.hasMoreTokens()) {
            String idAttribute;
            String s = st.nextToken();
            if (s.length() == 1) {
                switch (s.charAt(0)) {
                    case '.': {
                        _class = true;
                        continue block3;
                    }
                }
                _id = true;
                continue;
            }
            if (_class) {
                XmlAttribute classAttribute = parent.getAttribute("class");
                if (classAttribute == null) {
                    parent.setAttribute("class", s);
                    continue;
                }
                String classes = Strings.nullToEmpty((String)classAttribute.getValue());
                if (ContainerUtil.newHashSet((Iterable)HtmlUtil.splitClassNames((String)classes)).contains(s)) continue;
                parent.setAttribute("class", classAttribute.getValue() + " " + s);
                continue;
            }
            if (!_id || (idAttribute = parent.getAttributeValue("id")) != null && idAttribute.equals(s)) continue;
            parent.setAttribute("id", s);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private void showExtractErrorMessage(@NotNull Project project, @Nullable Editor editor) {
        if (project == null) {
            ExtractInlineCssAction.$$$reportNull$$$0(17);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.message((String)"introduce.selection.error"), (String)this.getText(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerBlock";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarations";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/ExtractInlineCssAction";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/ExtractInlineCssAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractDeclarations";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deleteSourceDeclarations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpXmlAfterExtracting";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "appendMissingIdOrClassDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showExtractErrorMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExtractInlineCssCallback
    implements CreateStyleCallback {
        private final Project myProject;
        private final CssBlock myOwnerBlock;
        private final CssDeclaration[] myDeclarations;
        private final XmlAttribute myStyleAttribute;
        private final Editor myEditor;

        public ExtractInlineCssCallback(Project project, CssBlock ownerBlock, CssDeclaration[] declarations, XmlAttribute styleAttribute, Editor editor) {
            this.myProject = project;
            this.myOwnerBlock = ownerBlock;
            this.myDeclarations = declarations;
            this.myStyleAttribute = styleAttribute;
            this.myEditor = editor;
        }

        @Override
        public void after(@NotNull String newSelector, @Nullable CssRuleset createdRuleset) {
            if (newSelector == null) {
                ExtractInlineCssCallback.$$$reportNull$$$0(0);
            }
            if (createdRuleset != null) {
                CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
                    if (newSelector == null) {
                        ExtractInlineCssCallback.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        if (newSelector == null) {
                            ExtractInlineCssCallback.$$$reportNull$$$0(2);
                        }
                        ExtractInlineCssAction.deleteSourceDeclarations(this.myOwnerBlock, this.myDeclarations);
                        ExtractInlineCssAction.cleanUpXmlAfterExtracting(newSelector, this.myStyleAttribute);
                    });
                }, ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, (Object)ExtractInlineCssAction.EXTRACT_INLINE_CSS_ID_STRING, this.myEditor.getDocument());
            } else {
                ExtractInlineCssAction.this.showExtractErrorMessage(this.myProject, this.myEditor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "newSelector";
            objectArray2[1] = "com/intellij/psi/css/actions/ExtractInlineCssAction$ExtractInlineCssCallback";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "after";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$after$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$null$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

