/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspectionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction;
import com.intellij.xml.XmlBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CssInvalidHtmlTagReferenceInspection
extends CssBaseInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CssBundle.message((String)"invalid.css.selector", (Object[])new Object[0]);
        if (string == null) {
            CssInvalidHtmlTagReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidHtmlTagReferenceInspection.$$$reportNull$$$0(1);
        }
        UnknownTagVisitor unknownTagVisitor = new UnknownTagVisitor(holder);
        if (unknownTagVisitor == null) {
            CssInvalidHtmlTagReferenceInspection.$$$reportNull$$$0(2);
        }
        return unknownTagVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UnknownTagVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        public UnknownTagVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitCssSelector(CssSelector selector) {
        }

        public void visitCssSimpleSelector(CssSimpleSelector selector) {
            String tagName = selector.getElementName();
            PsiElement element = selector.getNameIdentifier();
            if (element == null || CssUtil.containsStrangeCharacter(tagName) || tagName.isEmpty()) {
                return;
            }
            if (!CssDescriptorsUtil.isPossibleSelector((String)tagName, (PsiElement)selector)) {
                String message = CssBundle.message((String)"css.selector.matches.unknown.element", (Object[])new Object[]{tagName});
                ArrayList<Object> quickFixes = new ArrayList<Object>(CssDescriptorsUtil.getQuickFixesForUnknownSimpleSelector((String)tagName, (PsiElement)selector, (boolean)this.myHolder.isOnTheFly()));
                quickFixes.add(new AddCustomHtmlElementIntentionAction(HtmlUnknownTagInspectionBase.TAG_KEY, tagName, XmlBundle.message((String)"add.custom.html.tag", (Object[])new Object[]{tagName})));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction(tagName, CssSelectorSuffixType.ID));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction(tagName, CssSelectorSuffixType.CLASS));
                LocalQuickFix[] fixes = quickFixes.toArray(new LocalQuickFix[quickFixes.size()]);
                this.myHolder.registerProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
            }
        }
    }
}

