/*
 * Copyright 2000-2017 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.spring.model.jam.stereotype;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.psi.PsiClass;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomSpringComponent extends SpringMetaStereotypeComponent {

  public static final SemKey<JamMemberMeta<PsiClass, CustomSpringComponent>> META_KEY =
    JamService.ALIASING_MEMBER_META_KEY.subKey("CustomSpringComponentMeta");

  public static final SemKey<CustomSpringComponent> JAM_KEY =
    JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY.subKey("CustomSpringComponent");

  public CustomSpringComponent(@NotNull PsiClass psiClassAnchor) {
    super(null, psiClassAnchor);
  }

  public CustomSpringComponent(@Nullable String anno, @NotNull PsiClass psiClassAnchor) {
    super(anno, psiClassAnchor);
  }
}