/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicPropertyDialog;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class DynamicPropertyFix
extends GroovyFix
implements IntentionAction,
LowPriorityAction {
    private final GrReferenceExpression myReferenceExpression;
    private final GrArgumentLabel myArgumentLabel;
    private final PsiClass myTargetClass;

    public DynamicPropertyFix(GrReferenceExpression referenceExpression) {
        this.myReferenceExpression = referenceExpression;
        this.myArgumentLabel = null;
        this.myTargetClass = null;
    }

    public DynamicPropertyFix(GrArgumentLabel argumentLabel, PsiClass targetClass) {
        this.myArgumentLabel = argumentLabel;
        this.myReferenceExpression = null;
        this.myTargetClass = targetClass;
    }

    @NotNull
    public String getText() {
        String string = GroovyBundle.message("add.dynamic.property", this.getRefName());
        if (string == null) {
            DynamicPropertyFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            DynamicPropertyFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private String getRefName() {
        if (this.myReferenceExpression != null) {
            return this.myReferenceExpression.getReferenceName();
        }
        return this.myArgumentLabel.getName();
    }

    @NotNull
    public String getFamilyName() {
        String string = GroovyBundle.message("add.dynamic.element", new Object[0]);
        if (string == null) {
            DynamicPropertyFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            DynamicPropertyFix.$$$reportNull$$$0(3);
        }
        return !(this.myReferenceExpression != null && !this.myReferenceExpression.isValid() || this.myArgumentLabel != null && !this.myArgumentLabel.isValid());
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            DynamicPropertyFix.$$$reportNull$$$0(4);
        }
        this.invokeInner();
    }

    private void invokeInner() {
        DynamicPropertyDialog dialog = this.myReferenceExpression != null ? new DynamicPropertyDialog(this.myReferenceExpression) : new DynamicPropertyDialog(this.myArgumentLabel, this.myTargetClass);
        dialog.show();
    }

    @Override
    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
        if (project == null) {
            DynamicPropertyFix.$$$reportNull$$$0(5);
        }
        if (descriptor2 == null) {
            DynamicPropertyFix.$$$reportNull$$$0(6);
        }
        this.invokeInner();
    }

    public void invoke(Project project) throws IncorrectOperationException {
        DynamicElementSettings settings = this.myReferenceExpression != null ? QuickfixUtil.createSettings(this.myReferenceExpression) : QuickfixUtil.createSettings(this.myArgumentLabel, this.myTargetClass);
        DynamicManager.getInstance(project).addProperty(settings);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public GrReferenceExpression getReferenceExpression() {
        return this.myReferenceExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/annotator/intentions/dynamic/DynamicPropertyFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

