/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.parsing.auxiliary.modifiers.Modifiers;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.declaration.VariableDefinitions;
import org.jetbrains.plugins.groovy.lang.parser.parsing.statements.typeDefinitions.ReferenceElement;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeParameters;
import org.jetbrains.plugins.groovy.lang.parser.parsing.types.TypeSpec;
import org.jetbrains.plugins.groovy.lang.parser.parsing.util.ParserUtils;

public class Declaration {
    public static boolean parse(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser) {
        if (builder == null) {
            Declaration.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(1);
        }
        PsiBuilder.Marker declMarker = builder.mark();
        boolean modifiersParsed = Modifiers.parse(builder, parser);
        boolean methodStart = GroovyTokenTypes.mLT == builder.getTokenType();
        IElementType type = Declaration.parseAfterModifiers(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed);
        if (type == GroovyElementTypes.WRONGWAY) {
            if (modifiersParsed && methodStart) {
                declMarker.error(GroovyBundle.message("method.definitions.expected", new Object[0]));
                return false;
            }
            declMarker.rollbackTo();
            if (modifiersParsed) {
                builder.error(GroovyBundle.message("variable.definitions.expected", new Object[0]));
            }
            return false;
        }
        if (type != null) {
            declMarker.done(type);
        } else {
            declMarker.drop();
        }
        return true;
    }

    @Nullable
    public static IElementType parseAfterModifiers(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed) {
        boolean expressionPossible;
        if (builder == null) {
            Declaration.$$$reportNull$$$0(2);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(3);
        }
        boolean bl = expressionPossible = !isInAnnotation && !isInClass;
        if (modifiersParsed && builder.getTokenType() == GroovyTokenTypes.mLT) {
            return Declaration.parseDeclarationWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible);
        }
        if (modifiersParsed) {
            return Declaration.parseDeclarationWithoutGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible);
        }
        if (typeDefinitionName != null && ParserUtils.lookAhead(builder, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mLPAREN) && typeDefinitionName.equals(builder.getTokenText())) {
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        }
        return Declaration.parsePossibleCallExpression(builder, isInClass, isInAnnotation, typeDefinitionName, parser, expressionPossible);
    }

    private static IElementType parsePossibleCallExpression(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean expressionPossible) {
        IElementType varDef;
        if (builder == null) {
            Declaration.$$$reportNull$$$0(4);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(5);
        }
        if (Declaration.isCall(builder)) {
            return GroovyElementTypes.WRONGWAY;
        }
        boolean typeParsed = false;
        if (!ParserUtils.lookAhead(builder, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mLPAREN)) {
            boolean bl = typeParsed = TypeSpec.parse(builder, true, expressionPossible) != ReferenceElement.ReferenceElementResult.FAIL;
            if (!typeParsed) {
                return GroovyElementTypes.WRONGWAY;
            }
        }
        if ((varDef = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, typeParsed, false, parser)) != GroovyElementTypes.WRONGWAY) {
            return varDef;
        }
        if (isInClass && typeParsed) {
            return null;
        }
        return GroovyElementTypes.WRONGWAY;
    }

    private static boolean isCall(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Declaration.$$$reportNull$$$0(6);
        }
        if (builder.eof()) {
            return false;
        }
        if (TokenSets.BUILT_IN_TYPES.contains(builder.getTokenType())) {
            return false;
        }
        String text = builder.getTokenText();
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        assert (text != null);
        char firstChar = text.charAt(0);
        return !(!Character.isLowerCase(firstChar) && Character.isLetter(firstChar) || !ParserUtils.lookAhead(builder, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mIDENT) && !ParserUtils.lookAhead(builder, GroovyTokenTypes.mIDENT, GroovyTokenTypes.mLPAREN));
    }

    private static IElementType parseDeclarationWithoutGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible) {
        if (builder == null) {
            Declaration.$$$reportNull$$$0(7);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(8);
        }
        PsiBuilder.Marker checkMarker = builder.mark();
        ReferenceElement.ReferenceElementResult typeResult = TypeSpec.parse(builder, false, expressionPossible);
        if (typeResult == ReferenceElement.ReferenceElementResult.FAIL) {
            checkMarker.rollbackTo();
            if (isInAnnotation) {
                builder.error(GroovyBundle.message("type.expected", new Object[0]));
            }
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, true, parser);
        }
        IElementType varDeclarationTop = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        if (varDeclarationTop == GroovyElementTypes.WRONGWAY) {
            if (typeResult == ReferenceElement.ReferenceElementResult.REF_WITH_TYPE_PARAMS) {
                checkMarker.drop();
                return GroovyElementTypes.VARIABLE_DEFINITION_ERROR;
            }
            checkMarker.rollbackTo();
            if (isInAnnotation) {
                builder.error(GroovyBundle.message("type.expected", new Object[0]));
            }
            return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
        }
        checkMarker.drop();
        return varDeclarationTop;
    }

    private static IElementType parseDeclarationWithGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible) {
        if (builder == null) {
            Declaration.$$$reportNull$$$0(9);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(10);
        }
        PsiBuilder.Marker start = builder.mark();
        IElementType type = Declaration.tryParseWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible, true);
        if (type == GroovyElementTypes.WRONGWAY || type == GroovyElementTypes.CONSTRUCTOR_DEFINITION || type == GroovyElementTypes.METHOD_DEFINITION) {
            start.drop();
            return type;
        }
        start.rollbackTo();
        return Declaration.tryParseWithGenerics(builder, isInClass, isInAnnotation, typeDefinitionName, parser, modifiersParsed, expressionPossible, false);
    }

    private static IElementType tryParseWithGenerics(@NotNull PsiBuilder builder, boolean isInClass, boolean isInAnnotation, @Nullable String typeDefinitionName, @NotNull GroovyParser parser, boolean modifiersParsed, boolean expressionPossible, boolean acceptTypeParameters) {
        if (builder == null) {
            Declaration.$$$reportNull$$$0(11);
        }
        if (parser == null) {
            Declaration.$$$reportNull$$$0(12);
        }
        if (acceptTypeParameters) {
            TypeParameters.parse(builder);
        } else {
            PsiBuilder.Marker error = builder.mark();
            TypeParameters.parse(builder);
            error.error(GroovyBundle.message("type.parameters.are.unexpected", new Object[0]));
        }
        PsiBuilder.Marker checkMarker = builder.mark();
        switch (TypeSpec.parse(builder, false, expressionPossible)) {
            case PATH_REF: 
            case REF_WITH_TYPE_PARAMS: {
                checkMarker.drop();
                break;
            }
            case FAIL: {
                checkMarker.rollbackTo();
                break;
            }
            case IDENTIFIER: {
                IElementType result = VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
                if (result == GroovyElementTypes.WRONGWAY) {
                    checkMarker.rollbackTo();
                    break;
                }
                checkMarker.drop();
                return result;
            }
        }
        return VariableDefinitions.parseDefinitions(builder, isInClass, isInAnnotation, typeDefinitionName, modifiersParsed, false, parser);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/parser/parsing/statements/declaration/Declaration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseAfterModifiers";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "parsePossibleCallExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCall";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDeclarationWithoutGenerics";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "parseDeclarationWithGenerics";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "tryParseWithGenerics";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

