/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.noncode;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.light.LightFieldBuilder;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GrDelegatingScopeProcessorWithHints;

public class GrCollectionTypeMembersProvider
extends NonCodeMembersContributor {
    @Override
    public String getParentClassName() {
        return "java.util.Collection";
    }

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        PsiType collectionType;
        if (qualifierType == null) {
            GrCollectionTypeMembersProvider.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            GrCollectionTypeMembersProvider.$$$reportNull$$$0(1);
        }
        if (place == null) {
            GrCollectionTypeMembersProvider.$$$reportNull$$$0(2);
        }
        if (state == null) {
            GrCollectionTypeMembersProvider.$$$reportNull$$$0(3);
        }
        if ((collectionType = PsiUtil.extractIterableTypeParameter((PsiType)qualifierType, (boolean)true)) == null) {
            return;
        }
        PsiClass collectionClass = JavaPsiFacade.getInstance((Project)place.getProject()).findClass("java.util.Collection", place.getResolveScope());
        FieldSearcher fieldSearcher = new FieldSearcher(processor, collectionClass);
        ResolveUtil.processAllDeclarations(collectionType, (PsiScopeProcessor)fieldSearcher, state, place);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifierType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "place";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/GrCollectionTypeMembersProvider";
        objectArray[2] = "processDynamicElements";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FieldSearcher
    extends GrDelegatingScopeProcessorWithHints {
        final PsiClass myCollectionClass;

        public FieldSearcher(PsiScopeProcessor processor, PsiClass collectionClass) {
            super(processor, null, ClassHint.RESOLVE_KINDS_PROPERTY);
            this.myCollectionClass = collectionClass;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                FieldSearcher.$$$reportNull$$$0(0);
            }
            if (state == null) {
                FieldSearcher.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiField) {
                PsiType type = ((PsiField)element).getType();
                String typeText = type instanceof PsiClassType ? "java.util.Collection<" + type.getCanonicalText() + ">" : "java.util.Collection";
                LightFieldBuilder lightField = new LightFieldBuilder(((PsiField)element).getName(), typeText, element);
                lightField.setContainingClass(this.myCollectionClass);
                lightField.setOriginInfo("spread collection field");
                return super.execute((PsiElement)lightField, state);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/groovy/lang/resolve/noncode/GrCollectionTypeMembersProvider$FieldSearcher";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

