/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyNameSuggestionUtil;
import org.jetbrains.plugins.groovy.refactoring.NameValidator;

public abstract class GroovyRefactoringUtil {
    private static final Logger LOG = Logger.getInstance(GroovyRefactoringUtil.class);
    public static final Collection<String> KEYWORDS = ContainerUtil.map((Object[])TokenSets.KEYWORDS.getTypes(), (Function)StringUtil.createToStringFunction(IElementType.class));
    private static final String[] finalModifiers = new String[]{"final"};

    public static PsiElement[] getExpressionOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope) {
        if (expr == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(1);
        }
        ArrayList<PsiElement> occurrences = new ArrayList<PsiElement>();
        Comparator comparator = (element1, element2) -> {
            if (element1 != null && element1.equals(element2)) {
                return 0;
            }
            if (element1 instanceof GrParameter && element2 instanceof GrParameter) {
                String name1 = ((GrParameter)element1).getName();
                String name2 = ((GrParameter)element2).getName();
                return name1.compareTo(name2);
            }
            return 1;
        };
        if (scope instanceof GrLoopStatement) {
            PsiElement son = expr;
            while (son.getParent() != null && !(son.getParent() instanceof GrLoopStatement)) {
                son = son.getParent();
            }
            assert (scope.equals(son.getParent()));
            GroovyRefactoringUtil.collectOccurrences(expr, son, occurrences, comparator, false);
        } else {
            GroovyRefactoringUtil.collectOccurrences(expr, scope, occurrences, comparator, scope instanceof GrTypeDefinition || scope instanceof GroovyFileBase);
        }
        return PsiUtilCore.toPsiElementArray(occurrences);
    }

    private static void collectOccurrences(@NotNull PsiElement expr, @NotNull PsiElement scope, @NotNull ArrayList<PsiElement> acc, Comparator<PsiElement> comparator, boolean goIntoInner) {
        if (expr == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(3);
        }
        if (acc == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(4);
        }
        if (scope.equals(expr)) {
            acc.add(expr);
            return;
        }
        for (PsiElement child : scope.getChildren()) {
            if (!goIntoInner && (child instanceof GrTypeDefinition || child instanceof GrMethod && scope instanceof GroovyFileBase)) continue;
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)child, (PsiElement)expr, comparator, (boolean)false)) {
                acc.add(child);
                continue;
            }
            GroovyRefactoringUtil.collectOccurrences(expr, child, acc, comparator, goIntoInner);
        }
    }

    public static boolean isAppropriateContainerForIntroduceVariable(PsiElement tempContainer) {
        return tempContainer instanceof GrOpenBlock || tempContainer instanceof GrClosableBlock || tempContainer instanceof GroovyFileBase || tempContainer instanceof GrCaseSection || tempContainer instanceof GrLoopStatement || tempContainer instanceof GrIfStatement;
    }

    public static void sortOccurrences(PsiElement[] occurrences) {
        Arrays.sort(occurrences, (elem1, elem2) -> {
            int offset1 = elem1.getTextRange().getStartOffset();
            int offset2 = elem2.getTextRange().getStartOffset();
            return offset1 - offset2;
        });
    }

    public static void highlightOccurrences(Project project, @Nullable Editor editor, PsiElement[] elements) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (elements.length > 0) {
            highlightManager.addOccurrenceHighlights(editor, elements, attributes, false, highlighters);
        }
    }

    public static void highlightOccurrencesByRanges(Project project, Editor editor, TextRange[] ranges) {
        if (editor == null) {
            return;
        }
        ArrayList highlighters = new ArrayList();
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        EditorColorsManager colorsManager = EditorColorsManager.getInstance();
        TextAttributes attributes = colorsManager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        for (TextRange range : ranges) {
            highlightManager.addRangeHighlight(editor, range.getStartOffset(), range.getEndOffset(), attributes, false, highlighters);
        }
    }

    public static void trimSpacesAndComments(Editor editor, PsiFile file, boolean trimComments) {
        int start = editor.getSelectionModel().getSelectionStart();
        int end = editor.getSelectionModel().getSelectionEnd();
        while (file.findElementAt(start) instanceof PsiWhiteSpace || file.findElementAt(start) instanceof PsiComment && trimComments || file.findElementAt(start) != null && GroovyTokenTypes.mNLS.equals(file.findElementAt(start).getNode().getElementType())) {
            ++start;
        }
        while (file.findElementAt(end - 1) instanceof PsiWhiteSpace || file.findElementAt(end - 1) instanceof PsiComment && trimComments || file.findElementAt(end - 1) != null && (GroovyTokenTypes.mNLS.equals(file.findElementAt(end - 1).getNode().getElementType()) || GroovyTokenTypes.mSEMI.equals(file.findElementAt(end - 1).getNode().getElementType()))) {
            --end;
        }
        editor.getSelectionModel().setSelection(start, end);
    }

    @NotNull
    public static PsiElement[] findStatementsInRange(PsiFile file, int startOffset, int endOffset, boolean strict) {
        if (!(file instanceof GroovyFileBase)) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(5);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        GroovyLanguage language = GroovyLanguage.INSTANCE;
        PsiElement element1 = file.getViewProvider().findElementAt(startOffset, (Language)language);
        PsiElement element2 = file.getViewProvider().findElementAt(endOffset - 1, (Language)language);
        if (element1 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element1)) {
            startOffset = element1.getTextRange().getEndOffset();
            element1 = file.findElementAt(startOffset);
        }
        if (element2 instanceof PsiWhiteSpace || PsiUtil.isNewLine(element2)) {
            endOffset = element2.getTextRange().getStartOffset();
            element2 = file.findElementAt(endOffset - 1);
        }
        if (element1 == null || element2 == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(6);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        if (parent == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(7);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        while (!(parent instanceof GrCodeBlock || parent instanceof GroovyFileBase || parent instanceof GrCaseSection)) {
            if (parent instanceof GrStatement) {
                parent = parent.getParent();
                break;
            }
            if (parent == null) {
                if (PsiElement.EMPTY_ARRAY == null) {
                    GroovyRefactoringUtil.$$$reportNull$$$0(8);
                }
                return PsiElement.EMPTY_ARRAY;
            }
            PsiElement prev = parent;
            if (!((parent = parent.getParent()) instanceof GrCodeBlock) || !(prev instanceof LeafPsiElement)) continue;
            parent = parent.getParent();
        }
        if (!parent.equals(element1)) {
            while (!parent.equals(element1.getParent())) {
                element1 = element1.getParent();
            }
        }
        if (startOffset != element1.getTextRange().getStartOffset() && strict) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(9);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (!parent.equals(element2)) {
            while (!parent.equals(element2.getParent())) {
                element2 = element2.getParent();
            }
        }
        if (endOffset != element2.getTextRange().getEndOffset() && strict) {
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(10);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        if (parent instanceof GrCodeBlock && parent.getParent() instanceof GrBlockStatement && element1 == ((GrCodeBlock)parent).getLBrace() && element2 == ((GrCodeBlock)parent).getRBrace()) {
            PsiElement[] psiElementArray = new PsiElement[]{parent.getParent()};
            if (psiElementArray == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(11);
            }
            return psiElementArray;
        }
        PsiElement[] children = PsiElement.EMPTY_ARRAY;
        PsiElement psiChild = parent.getFirstChild();
        if (psiChild != null) {
            ArrayList<PsiElement> result = new ArrayList<PsiElement>();
            while (psiChild != null) {
                result.add(psiChild);
                psiChild = psiChild.getNextSibling();
            }
            children = PsiUtilCore.toPsiElementArray(result);
        }
        ArrayList<PsiElement> possibleStatements = new ArrayList<PsiElement>();
        boolean flag = false;
        for (PsiElement child : children) {
            if (child == element1) {
                flag = true;
            }
            if (flag) {
                possibleStatements.add(child);
            }
            if (child == element2) break;
        }
        for (PsiElement element : possibleStatements) {
            if (element instanceof GrStatement || element instanceof PsiWhiteSpace || element instanceof PsiComment || TokenSets.SEPARATORS.contains(element.getNode().getElementType())) continue;
            if (PsiElement.EMPTY_ARRAY == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(12);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(possibleStatements);
        if (psiElementArray == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    public static boolean isSuperOrThisCall(GrStatement statement, boolean testForSuper, boolean testForThis) {
        if (!(statement instanceof GrConstructorInvocation)) {
            return false;
        }
        GrConstructorInvocation expr = (GrConstructorInvocation)statement;
        return testForSuper && expr.isSuperCall() || testForThis && expr.isThisCall();
    }

    public static boolean hasWrongBreakStatements(PsiElement element) {
        ArrayList<GrBreakStatement> vector = new ArrayList<GrBreakStatement>();
        GroovyRefactoringUtil.addBreakStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addBreakStatements(PsiElement element, ArrayList<GrBreakStatement> vector) {
        if (element instanceof GrBreakStatement) {
            vector.add((GrBreakStatement)element);
        } else if (!(element instanceof GrLoopStatement || element instanceof GrSwitchStatement || element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addBreakStatements(psiElement, vector);
            }
        }
    }

    public static boolean hasWrongContinueStatements(PsiElement element) {
        ArrayList<GrContinueStatement> vector = new ArrayList<GrContinueStatement>();
        GroovyRefactoringUtil.addContinueStatements(element, vector);
        return !vector.isEmpty();
    }

    private static void addContinueStatements(PsiElement element, ArrayList<GrContinueStatement> vector) {
        if (element instanceof GrContinueStatement) {
            vector.add((GrContinueStatement)element);
        } else if (!(element instanceof GrLoopStatement) && !(element instanceof GrClosableBlock)) {
            for (PsiElement psiElement : element.getChildren()) {
                GroovyRefactoringUtil.addContinueStatements(psiElement, vector);
            }
        }
    }

    public static String getMethodSignature(PsiMethod method) {
        PsiType[] types;
        MethodSignature signature = method.getSignature(PsiSubstitutor.EMPTY);
        String s = signature.getName() + "(";
        int i = 0;
        for (PsiType type : types = signature.getParameterTypes()) {
            s = s + type.getPresentableText();
            if (i < types.length - 1) {
                s = s + ", ";
            }
            ++i;
        }
        s = s + ")";
        return s;
    }

    @Nullable
    public static GrCall getCallExpressionByMethodReference(@Nullable PsiElement ref) {
        if (ref == null) {
            return null;
        }
        if (ref instanceof GrEnumConstant) {
            return (GrEnumConstant)ref;
        }
        if (ref instanceof GrConstructorInvocation) {
            return (GrCall)ref;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof GrCall) {
            return (GrCall)parent;
        }
        if (parent instanceof GrAnonymousClassDefinition) {
            return (GrCall)parent.getParent();
        }
        return null;
    }

    public static boolean isMethodUsage(PsiElement ref) {
        return ref instanceof GrEnumConstant || ref.getParent() instanceof GrCall || ref instanceof GrConstructorInvocation;
    }

    public static String createTempVar(GrExpression expr, final GroovyPsiElement context, boolean declareFinal) {
        GrVariableDeclarationOwner block = (GrVariableDeclarationOwner)PsiTreeUtil.getParentOfType((PsiElement)(expr = GroovyRefactoringUtil.addBlockIntoParent(expr)), GrVariableDeclarationOwner.class);
        LOG.assertTrue(block != null);
        PsiElement anchorStatement = PsiTreeUtil.findPrevParent((PsiElement)block, (PsiElement)expr);
        LOG.assertTrue(anchorStatement instanceof GrStatement);
        Project project = expr.getProject();
        String[] suggestedNames = GroovyNameSuggestionUtil.suggestVariableNames(expr, new NameValidator(){

            @Override
            public String validateName(String name, boolean increaseNumber) {
                return name;
            }

            @Override
            public Project getProject() {
                return context.getProject();
            }
        });
        String prefix = suggestedNames[0];
        String id = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName(prefix, (PsiElement)context, true);
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(expr.getProject());
        String[] modifiers = declareFinal ? finalModifiers : ArrayUtil.EMPTY_STRING_ARRAY;
        GrVariableDeclaration decl = factory.createVariableDeclaration(modifiers, (GrExpression)PsiUtil.skipParentheses(expr, false), expr.getType(), id);
        GrStatement statement = ((GrStatementOwner)anchorStatement.getParent()).addStatementBefore(decl, (GrStatement)anchorStatement);
        JavaCodeStyleManager.getInstance((Project)statement.getProject()).shortenClassReferences((PsiElement)statement);
        return id;
    }

    public static int verifySafeCopyExpression(GrExpression expression) {
        return GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(expression);
    }

    private static int verifySafeCopyExpressionSubElement(PsiElement element) {
        PsiElement[] children;
        int result = 0;
        if (element == null) {
            return result;
        }
        if (element instanceof GrNamedElement) {
            return 0;
        }
        if (element instanceof GrMethodCallExpression) {
            result = 1;
        }
        if (element instanceof GrNewExpression) {
            return 2;
        }
        if (element instanceof GrAssignmentExpression) {
            return 2;
        }
        if (element instanceof GrClosableBlock) {
            return 2;
        }
        if (GroovyRefactoringUtil.isPlusPlusOrMinusMinus(element)) {
            return 2;
        }
        for (PsiElement child : children = element.getChildren()) {
            int childResult = GroovyRefactoringUtil.verifySafeCopyExpressionSubElement(child);
            result = Math.max(result, childResult);
        }
        return result;
    }

    public static boolean isPlusPlusOrMinusMinus(PsiElement element) {
        if (element instanceof GrUnaryExpression) {
            IElementType operandSign = ((GrUnaryExpression)element).getOperationTokenType();
            return operandSign == GroovyTokenTypes.mDEC || operandSign == GroovyTokenTypes.mINC;
        }
        return false;
    }

    public static boolean isCorrectReferenceName(String newName, Project project) {
        if (newName.startsWith("'''") || newName.startsWith("\"\"\"") ? newName.length() < 6 || !newName.endsWith("'''") : !(!StringUtil.startsWithChar((CharSequence)newName, (char)'\'') && !StringUtil.startsWithChar((CharSequence)newName, (char)'\"') || newName.length() >= 2 && newName.endsWith("'"))) {
            return false;
        }
        if (KEYWORDS.contains(newName)) {
            return false;
        }
        try {
            GroovyPsiElementFactory.getInstance(project).createReferenceNameFromText(newName);
        }
        catch (IncorrectOperationException e) {
            return false;
        }
        return true;
    }

    public static GrExpression generateArgFromMultiArg(PsiSubstitutor substitutor, List<? extends PsiElement> arguments, @Nullable PsiType type, Project project) {
        StringBuilder argText = new StringBuilder();
        argText.append("[");
        for (PsiElement psiElement : arguments) {
            argText.append(psiElement.getText()).append(", ");
        }
        if (!arguments.isEmpty()) {
            argText.delete(argText.length() - 2, argText.length());
        }
        argText.append("]");
        if (type instanceof PsiArrayType) {
            type = substitutor.substitute(type);
            String typeText = type.getCanonicalText();
            if (type instanceof PsiEllipsisType) {
                typeText = typeText.replace("...", "[]");
            }
            argText.append(" as ").append(typeText);
        }
        return GroovyPsiElementFactory.getInstance(project).createExpressionFromText(argText.toString());
    }

    public static boolean hasSideEffect(@NotNull GroovyPsiElement statement) {
        if (statement == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(14);
        }
        final Ref hasSideEffect = new Ref((Object)false);
        statement.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    2.$$$reportNull$$$0(0);
                }
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitCallExpression(@NotNull GrCallExpression callExpression) {
                if (callExpression == null) {
                    2.$$$reportNull$$$0(1);
                }
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
                if (applicationStatement == null) {
                    2.$$$reportNull$$$0(2);
                }
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    2.$$$reportNull$$$0(3);
                }
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(4);
                }
                hasSideEffect.set((Object)true);
            }

            @Override
            public void visitElement(@NotNull GroovyPsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (((Boolean)hasSideEffect.get()).booleanValue()) {
                    return;
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "applicationStatement";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "closure";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitApplicationStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClosure";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitUnaryExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)hasSideEffect.get();
    }

    @NotNull
    public static <Type extends PsiElement> Type addBlockIntoParent(@NotNull Type statement) throws IncorrectOperationException {
        if (statement == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(15);
        }
        PsiElement parent = statement.getParent();
        Object child = statement;
        while (!(parent instanceof GrLoopStatement || parent instanceof GrIfStatement || parent instanceof GrVariableDeclarationOwner || parent == null)) {
            parent = parent.getParent();
            child = child.getParent();
        }
        if (parent instanceof GrWhileStatement && child == ((GrWhileStatement)parent).getCondition() || parent instanceof GrIfStatement && child == ((GrIfStatement)parent).getCondition()) {
            parent = parent.getParent();
        }
        assert (parent != null);
        if (parent instanceof GrVariableDeclarationOwner) {
            Type Type2 = statement;
            if (Type2 == null) {
                GroovyRefactoringUtil.$$$reportNull$$$0(16);
            }
            return Type2;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(statement.getProject());
        Object tempStmt = statement;
        while (parent != tempStmt.getParent()) {
            tempStmt = tempStmt.getParent();
        }
        GrStatement toAdd = (GrStatement)tempStmt.copy();
        GrBlockStatement blockStatement = factory.createBlockStatement(new GrStatement[0]);
        if (parent instanceof GrLoopStatement) {
            ((GrLoopStatement)parent).replaceBody(blockStatement);
        } else {
            GrIfStatement ifStatement = (GrIfStatement)parent;
            if (tempStmt == ifStatement.getThenBranch()) {
                ifStatement.replaceThenBranch(blockStatement);
            } else if (tempStmt == ifStatement.getElseBranch()) {
                ifStatement.replaceElseBranch(blockStatement);
            }
        }
        GrStatement result = blockStatement.getBlock().addStatementBefore(toAdd, null);
        statement = result instanceof GrReturnStatement ? ((GrReturnStatement)result).getReturnValue() : result;
        Object object = statement;
        if (object == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(17);
        }
        return object;
    }

    public static boolean isDiamondNewOperator(GrExpression expression) {
        PsiElement element = PsiUtil.skipParentheses(expression, false);
        if (!(element instanceof GrNewExpression)) {
            return false;
        }
        if (((GrNewExpression)element).getArrayCount() > 0) {
            return false;
        }
        GrCodeReferenceElement referenceElement = ((GrNewExpression)element).getReferenceElement();
        if (referenceElement == null) {
            return false;
        }
        GrTypeArgumentList typeArgumentList = referenceElement.getTypeArgumentList();
        return typeArgumentList != null && typeArgumentList.isDiamond();
    }

    @Nullable
    public static GrStatementOwner getDeclarationOwner(GrStatement statement) {
        PsiElement parent = statement.getParent();
        return parent instanceof GrStatementOwner ? (GrStatementOwner)parent : null;
    }

    @Nullable
    public static PsiType getType(@Nullable PsiParameter myParameter) {
        if (myParameter == null) {
            return null;
        }
        PsiType type = myParameter.getType();
        return type instanceof PsiEllipsisType ? ((PsiEllipsisType)type).toArrayType() : type;
    }

    @Nullable
    public static PsiType getSubstitutedType(@Nullable GrParameter parameter) {
        if (parameter == null) {
            return null;
        }
        PsiType type = GroovyRefactoringUtil.getType(parameter);
        if (type instanceof PsiArrayType) {
            return type;
        }
        PsiClassType.ClassResolveResult result = com.intellij.psi.util.PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass psiClass = result.getElement();
        if (psiClass == null) {
            return type;
        }
        HashSet<PsiTypeParameter> usedTypeParameters = new HashSet<PsiTypeParameter>();
        GroovyRefactoringUtil.collectTypeParameters(usedTypeParameters, parameter);
        Iterator<PsiTypeParameter> iterator = usedTypeParameters.iterator();
        while (iterator.hasNext()) {
            PsiTypeParameter usedTypeParameter = iterator.next();
            if (parameter.getDeclarationScope() == usedTypeParameter.getOwner()) continue;
            iterator.remove();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)parameter.getProject());
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter usedTypeParameter : usedTypeParameters) {
            subst = subst.put(usedTypeParameter, TypeConversionUtil.typeParameterErasure((PsiTypeParameter)usedTypeParameter));
        }
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        Map typeMap = result.getSubstitutor().getSubstitutionMap();
        Iterator iterator2 = typeMap.keySet().iterator();
        while (iterator2.hasNext()) {
            PsiTypeParameter typeParameter;
            PsiType psiType = (PsiType)typeMap.get(typeParameter = (PsiTypeParameter)iterator2.next());
            substitutor = substitutor.put(typeParameter, psiType != null ? subst.substitute(psiType) : null);
        }
        return psiClass instanceof PsiTypeParameter ? subst.substitute((PsiTypeParameter)psiClass) : elementFactory.createType(psiClass, substitutor);
    }

    public static void collectTypeParameters(final Set<PsiTypeParameter> used, final @NotNull GroovyPsiElement element) {
        if (element == null) {
            GroovyRefactoringUtil.$$$reportNull$$$0(18);
        }
        element.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement reference) {
                PsiTypeParameter typeParameter;
                PsiElement resolved;
                if (reference == null) {
                    3.$$$reportNull$$$0(0);
                }
                super.visitCodeReferenceElement(reference);
                if (reference.getQualifier() == null && (resolved = reference.resolve()) instanceof PsiTypeParameter && PsiTreeUtil.isAncestor((PsiElement)(typeParameter = (PsiTypeParameter)resolved).getOwner(), (PsiElement)element, (boolean)false)) {
                    used.add(typeParameter);
                }
            }

            @Override
            public void visitExpression(@NotNull GrExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(1);
                }
                super.visitExpression(expression);
                PsiType type = expression.getType();
                if (type != null) {
                    TypeParameterSearcher searcher = new TypeParameterSearcher();
                    type.accept((PsiTypeVisitor)searcher);
                    for (PsiTypeParameter typeParam : searcher.myTypeParams) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)typeParam.getOwner(), (PsiElement)element, (boolean)false)) continue;
                        used.add(typeParam);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeReferenceElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            class TypeParameterSearcher
            extends PsiTypeVisitor<Boolean> {
                private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

                TypeParameterSearcher() {
                }

                public Boolean visitType(PsiType type) {
                    return false;
                }

                public Boolean visitArrayType(PsiArrayType arrayType) {
                    return (Boolean)arrayType.getComponentType().accept((PsiTypeVisitor)this);
                }

                public Boolean visitClassType(PsiClassType classType) {
                    PsiType[] types;
                    PsiClass aClass = classType.resolve();
                    if (aClass instanceof PsiTypeParameter) {
                        this.myTypeParams.add((PsiTypeParameter)aClass);
                    }
                    for (PsiType psiType : types = classType.getParameters()) {
                        psiType.accept((PsiTypeVisitor)this);
                    }
                    return false;
                }

                public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                    PsiType bound = wildcardType.getBound();
                    if (bound != null) {
                        bound.accept((PsiTypeVisitor)this);
                    }
                    return false;
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acc";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/GroovyRefactoringUtil";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findStatementsInRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addBlockIntoParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectOccurrences";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasSideEffect";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addBlockIntoParent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

