/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.Resources;
import android.content.res.Resources_Delegate;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater_Delegate;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public final class BridgeTypedArray
extends TypedArray {
    private final Resources mBridgeResources;
    private final BridgeContext mContext;
    private final boolean mPlatformFile;
    private final ResourceValue[] mResourceData;
    private final String[] mNames;
    private final boolean[] mIsFramework;
    private int[] mEmptyIds;

    public BridgeTypedArray(Resources resources, BridgeContext context, int len, boolean platformFile) {
        super(resources, null, null, 0);
        this.mBridgeResources = resources;
        this.mContext = context;
        this.mPlatformFile = platformFile;
        this.mResourceData = new ResourceValue[len];
        this.mNames = new String[len];
        this.mIsFramework = new boolean[len];
    }

    public void bridgeSetValue(int index, String name, boolean isFramework, ResourceValue value) {
        this.mResourceData[index] = value;
        this.mNames[index] = name;
        this.mIsFramework[index] = isFramework;
    }

    public void sealArray() {
        int i;
        int count = 0;
        ArrayList<Integer> emptyIds = null;
        for (i = 0; i < this.mResourceData.length; ++i) {
            ResourceValue data = this.mResourceData[i];
            if (data == null) continue;
            String dataValue = data.getValue();
            if ("@null".equals(dataValue) || "@undefined".equals(dataValue)) {
                this.mResourceData[i] = null;
                continue;
            }
            if ("@empty".equals(dataValue)) {
                this.mResourceData[i] = null;
                if (emptyIds == null) {
                    emptyIds = new ArrayList<Integer>(4);
                }
                emptyIds.add(i);
                continue;
            }
            ++count;
        }
        if (emptyIds != null) {
            this.mEmptyIds = new int[emptyIds.size()];
            for (i = 0; i < emptyIds.size(); ++i) {
                this.mEmptyIds[i] = (Integer)emptyIds.get(i);
            }
        }
        this.mIndices = new int[count + 1];
        this.mIndices[0] = count;
        int index = 1;
        for (int i2 = 0; i2 < this.mResourceData.length; ++i2) {
            if (this.mResourceData[i2] == null) continue;
            this.mIndices[index++] = i2;
        }
    }

    public void setTheme(Resources.Theme theme) {
        this.mTheme = theme;
    }

    @Override
    public int length() {
        return this.mResourceData.length;
    }

    @Override
    public Resources getResources() {
        return this.mBridgeResources;
    }

    @Override
    public CharSequence getText(int index) {
        return this.getString(index);
    }

    @Override
    public String getString(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        Integer v = this.resolveEnumAttribute(index);
        return v == null ? this.mResourceData[index].getValue() : String.valueOf(v);
    }

    @Override
    public boolean getBoolean(int index, boolean defValue) {
        String s = this.getString(index);
        return s == null ? defValue : XmlUtils.convertValueToBoolean(s, defValue);
    }

    @Override
    public int getInt(int index, int defValue) {
        String s = this.getString(index);
        try {
            return BridgeTypedArray.convertValueToInt(s, defValue);
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid integer", s, this.mNames[index]), null);
            return defValue;
        }
    }

    @Override
    public float getFloat(int index, float defValue) {
        String s = this.getString(index);
        try {
            if (s != null) {
                return Float.parseFloat(s);
            }
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to float.", s, this.mNames[index]), null);
        }
        return defValue;
    }

    @Override
    public int getColor(int index, int defValue) {
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        ColorStateList colorStateList = ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext);
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        return defValue;
    }

    @Override
    public ColorStateList getColorStateList(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        return ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext);
    }

    @Override
    public ComplexColor getComplexColor(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        return ResourceHelper.getComplexColor(this.mResourceData[index], this.mContext);
    }

    @Override
    public int getInteger(int index, int defValue) {
        return this.getInt(index, defValue);
    }

    @Override
    public float getDimension(int index, float defValue) {
        String s = this.getString(index);
        if (s == null) {
            return defValue;
        }
        try {
            int i = Integer.parseInt(s);
            if (i == -1 || i == -2) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            return this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
        }
        return defValue;
    }

    @Override
    public int getDimensionPixelOffset(int index, int defValue) {
        return (int)this.getDimension(index, defValue);
    }

    @Override
    public int getDimensionPixelSize(int index, int defValue) {
        try {
            return this.getDimension(index, null);
        }
        catch (RuntimeException e) {
            String s = this.getString(index);
            if (s != null) {
                Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", s, this.mNames[index]), null);
            }
            return defValue;
        }
    }

    @Override
    public int getLayoutDimension(int index, String name) {
        try {
            return this.getDimension(index, name);
        }
        catch (RuntimeException e) {
            if (LayoutInflater_Delegate.sIsInInclude) {
                throw new RuntimeException("Layout Dimension '" + name + "' not found.");
            }
            Bridge.getLog().warning("resources.format", "You must supply a " + name + " attribute.", null);
            return 0;
        }
    }

    @Override
    public int getLayoutDimension(int index, int defValue) {
        return this.getDimensionPixelSize(index, defValue);
    }

    private int getDimension(int index, String name) {
        String s = this.getString(index);
        if (s == null) {
            if (name != null) {
                throw new RuntimeException("Attribute '" + name + "' not found");
            }
            throw new RuntimeException();
        }
        try {
            int i = Integer.parseInt(s);
            if (i == -1 || i == -2) {
                return i;
            }
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            float f = this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (f == 0.0f) {
                return 0;
            }
            if (f > 0.0f) {
                return 1;
            }
        }
        throw new RuntimeException();
    }

    @Override
    public float getFraction(int index, int base, int pbase, float defValue) {
        String value = this.getString(index);
        if (value == null) {
            return defValue;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], value, this.mValue, false)) {
            return this.mValue.getFraction(base, pbase);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to a fraction.", value, this.mNames[index]), null);
        return defValue;
    }

    @Override
    public int getResourceId(int index, int defValue) {
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        ResourceValue resValue = this.mResourceData[index];
        if (resValue == null) {
            return defValue;
        }
        if (resValue instanceof StyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((StyleResourceValue)resValue);
        }
        if (resValue.getResourceType() != null) {
            if (this.mPlatformFile || resValue.isFramework()) {
                return this.mContext.getFrameworkResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
            }
            return this.mContext.getProjectResourceValue(resValue.getResourceType(), resValue.getName(), defValue);
        }
        String value = resValue.getValue();
        if (value == null) {
            return defValue;
        }
        value = value.trim();
        try {
            int i = Integer.parseInt(value);
            if (Integer.toString(i).equals(value)) {
                return i;
            }
        }
        catch (NumberFormatException i) {
            // empty catch block
        }
        if (value.startsWith("#")) {
            return defValue;
        }
        if (value.startsWith("@id/") || value.startsWith("@+") || value.startsWith("@android:id/")) {
            boolean isFrameworkId;
            int pos = value.indexOf(47);
            String idName = value.substring(pos + 1);
            boolean create = value.startsWith("@+");
            boolean bl = isFrameworkId = this.mPlatformFile || value.startsWith("@android") || value.startsWith("@+android");
            if (create) {
                Integer idValue = isFrameworkId ? Bridge.getResourceId(ResourceType.ID, idName) : this.mContext.getLayoutlibCallback().getResourceId(ResourceType.ID, idName);
                return idValue == null ? defValue : idValue;
            }
            if (isFrameworkId) {
                return this.mContext.getFrameworkResourceValue(ResourceType.ID, idName, defValue);
            }
            return this.mContext.getProjectResourceValue(ResourceType.ID, idName, defValue);
        }
        Integer enumValue = this.resolveEnumAttribute(index);
        if (enumValue != null) {
            return enumValue;
        }
        Integer idValue = resValue.isFramework() ? Bridge.getResourceId(resValue.getResourceType(), resValue.getName()) : this.mContext.getLayoutlibCallback().getResourceId(resValue.getResourceType(), resValue.getName());
        if (idValue != null) {
            return idValue;
        }
        Bridge.getLog().warning("resources.resolve", String.format("Unable to resolve id \"%1$s\" for attribute \"%2$s\"", value, this.mNames[index]), (Object)resValue);
        return defValue;
    }

    @Override
    public int getThemeAttributeId(int index, int defValue) {
        return defValue;
    }

    @Override
    public Drawable getDrawable(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue value = this.mResourceData[index];
        return ResourceHelper.getDrawable(value, this.mContext, this.mTheme);
    }

    @Override
    public CharSequence[] getTextArray(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue resVal = this.mResourceData[index];
        if (resVal instanceof ArrayResourceValue) {
            ArrayResourceValue array2 = (ArrayResourceValue)resVal;
            int count = array2.getElementCount();
            return count >= 0 ? Resources_Delegate.fillValues((Resources)this.mBridgeResources, (ArrayResourceValue)array2, (CharSequence[])new CharSequence[count]) : null;
        }
        int id2 = this.getResourceId(index, 0);
        String resIdMessage = id2 > 0 ? " (resource id 0x" + Integer.toHexString(id2) + ')' : "";
        throw new Resources.NotFoundException(String.format("%1$s in %2$s%3$s is not a valid array resource.", resVal.getValue(), this.mNames[index], resIdMessage));
    }

    @Override
    public int[] extractThemeAttrs() {
        return null;
    }

    @Override
    public int getChangingConfigurations() {
        return 0;
    }

    @Override
    public boolean getValue(int index, TypedValue outValue) {
        String s = this.getString(index);
        return s != null && ResourceHelper.parseFloatAttribute(this.mNames[index], s, outValue, false);
    }

    @Override
    public int getType(int index) {
        String value = this.getString(index);
        if (value == null) {
            return 0;
        }
        if (value.startsWith("@")) {
            return 1;
        }
        if (value.startsWith("?")) {
            return 2;
        }
        try {
            BridgeTypedArray.convertValueToInt(value, 0);
            if (value.startsWith("0x") || value.startsWith("0X")) {
                return 17;
            }
            if (value.startsWith("#")) {
                int length = value.length() - 1;
                if (length == 3) {
                    return 31;
                }
                if (length == 4) {
                    return 30;
                }
                if (length == 6) {
                    return 29;
                }
                if (length == 8) {
                    return 28;
                }
            }
            if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                return 18;
            }
            return 16;
        }
        catch (NumberFormatException ignored) {
            try {
                Float.parseFloat(value);
                return 4;
            }
            catch (NumberFormatException numberFormatException) {
                if (ResourceHelper.parseFloatAttribute(null, value, new TypedValue(), false)) {
                    return 5;
                }
                return 3;
            }
        }
    }

    @Override
    public boolean hasValue(int index) {
        return index >= 0 && index < this.mResourceData.length && this.mResourceData[index] != null;
    }

    @Override
    public boolean hasValueOrEmpty(int index) {
        return this.hasValue(index) || index >= 0 && index < this.mResourceData.length && this.mEmptyIds != null && Arrays.binarySearch(this.mEmptyIds, index) >= 0;
    }

    @Override
    public TypedValue peekValue(int index) {
        if (index < 0 || index >= this.mResourceData.length) {
            return null;
        }
        if (this.getValue(index, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    @Override
    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    @Override
    public void recycle() {
    }

    @Override
    public String toString() {
        return Arrays.toString(this.mResourceData);
    }

    private Integer resolveEnumAttribute(int index) {
        Map map = null;
        if (this.mIsFramework[index]) {
            map = Bridge.getEnumValues(this.mNames[index]);
        } else {
            RenderResources res = this.mContext.getRenderResources();
            ResourceValue attr2 = res.getProjectResource(ResourceType.ATTR, this.mNames[index]);
            if (attr2 instanceof AttrResourceValue) {
                map = ((AttrResourceValue)attr2).getAttributeValues();
            }
        }
        if (map != null) {
            String[] keywords;
            int result = 0;
            boolean found = false;
            for (String keyword : keywords = this.mResourceData[index].getValue().split("\\|")) {
                Integer i = (Integer)map.get(keyword.trim());
                if (i == null) continue;
                result |= i.intValue();
                found = true;
            }
            if (found) {
                return result;
            }
        }
        return null;
    }

    private static int convertValueToInt(String charSeq, int defValue) {
        if (null == charSeq || charSeq.isEmpty()) {
            return defValue;
        }
        int sign = 1;
        int index = 0;
        int len = charSeq.length();
        int base = 10;
        if ('-' == charSeq.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == charSeq.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = charSeq.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
            }
        } else {
            if ('#' == charSeq.charAt(index)) {
                return ResourceHelper.getColor(charSeq) * sign;
            }
            if ("true".equals(charSeq) || "TRUE".equals(charSeq)) {
                return -1;
            }
            if ("false".equals(charSeq) || "FALSE".equals(charSeq)) {
                return 0;
            }
        }
        return (int)Long.parseLong(charSeq.substring(index), base) * sign;
    }

    static TypedArray obtain(Resources res, int len) {
        return new BridgeTypedArray(res, null, len, true);
    }
}

