/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ShapeDrawable
extends Drawable {
    private ShapeState mShapeState;
    private PorterDuffColorFilter mTintFilter;
    private boolean mMutated;

    public ShapeDrawable() {
        this(new ShapeState(null), null);
    }

    public ShapeDrawable(Shape s) {
        this(new ShapeState(null), null);
        this.mShapeState.mShape = s;
    }

    public Shape getShape() {
        return this.mShapeState.mShape;
    }

    public void setShape(Shape s) {
        this.mShapeState.mShape = s;
        this.updateShape();
    }

    public void setShaderFactory(ShaderFactory fact) {
        this.mShapeState.mShaderFactory = fact;
    }

    public ShaderFactory getShaderFactory() {
        return this.mShapeState.mShaderFactory;
    }

    public Paint getPaint() {
        return this.mShapeState.mPaint;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if ((left | top | right | bottom) == 0) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(left, top, right, bottom);
        }
        this.invalidateSelf();
    }

    public void setPadding(Rect padding) {
        if (padding == null) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(padding);
        }
        this.invalidateSelf();
    }

    public void setIntrinsicWidth(int width) {
        this.mShapeState.mIntrinsicWidth = width;
        this.invalidateSelf();
    }

    public void setIntrinsicHeight(int height) {
        this.mShapeState.mIntrinsicHeight = height;
        this.invalidateSelf();
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mShapeState.mIntrinsicWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mShapeState.mIntrinsicHeight;
    }

    @Override
    public boolean getPadding(Rect padding) {
        if (this.mShapeState.mPadding != null) {
            padding.set(this.mShapeState.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    private static int modulateAlpha(int paintAlpha, int alpha) {
        int scale = alpha + (alpha >>> 7);
        return paintAlpha * scale >>> 8;
    }

    protected void onDraw(Shape shape, Canvas canvas, Paint paint) {
        shape.draw(canvas, paint);
    }

    @Override
    public void draw(Canvas canvas) {
        Rect r = this.getBounds();
        ShapeState state = this.mShapeState;
        Paint paint = state.mPaint;
        int prevAlpha = paint.getAlpha();
        paint.setAlpha(ShapeDrawable.modulateAlpha(prevAlpha, state.mAlpha));
        if (paint.getAlpha() != 0 || paint.getXfermode() != null || paint.hasShadowLayer()) {
            boolean clearColorFilter;
            if (this.mTintFilter != null && paint.getColorFilter() == null) {
                paint.setColorFilter(this.mTintFilter);
                clearColorFilter = true;
            } else {
                clearColorFilter = false;
            }
            if (state.mShape != null) {
                int count = canvas.save();
                canvas.translate(r.left, r.top);
                this.onDraw(state.mShape, canvas, paint);
                canvas.restoreToCount(count);
            } else {
                canvas.drawRect(r, paint);
            }
            if (clearColorFilter) {
                paint.setColorFilter(null);
            }
        }
        paint.setAlpha(prevAlpha);
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.getChangingConfigurations();
    }

    @Override
    public void setAlpha(int alpha) {
        this.mShapeState.mAlpha = alpha;
        this.invalidateSelf();
    }

    @Override
    public int getAlpha() {
        return this.mShapeState.mAlpha;
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mShapeState.mTint = tint;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, tint, this.mShapeState.mTintMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintMode(PorterDuff.Mode tintMode) {
        this.mShapeState.mTintMode = tintMode;
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mShapeState.mTint, tintMode);
        this.invalidateSelf();
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        this.mShapeState.mPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Override
    public int getOpacity() {
        Paint p;
        if (this.mShapeState.mShape == null && (p = this.mShapeState.mPaint).getXfermode() == null) {
            int alpha = p.getAlpha();
            if (alpha == 0) {
                return -2;
            }
            if (alpha == 255) {
                return -1;
            }
        }
        return -3;
    }

    @Override
    public void setDither(boolean dither) {
        this.mShapeState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateShape();
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        ShapeState state = this.mShapeState;
        if (state.mTint != null && state.mTintMode != null) {
            this.mTintFilter = this.updateTintFilter(this.mTintFilter, state.mTint, state.mTintMode);
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        ShapeState s = this.mShapeState;
        return super.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    protected boolean inflateTag(String name, Resources r, XmlPullParser parser, AttributeSet attrs) {
        if ("padding".equals(name)) {
            TypedArray a = r.obtainAttributes(attrs, R.styleable.ShapeDrawablePadding);
            this.setPadding(a.getDimensionPixelOffset(0, 0), a.getDimensionPixelOffset(1, 0), a.getDimensionPixelOffset(2, 0), a.getDimensionPixelOffset(3, 0));
            a.recycle();
            return true;
        }
        return false;
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int type;
        super.inflate(r, parser, attrs, theme);
        TypedArray a = ShapeDrawable.obtainAttributes(r, theme, attrs, R.styleable.ShapeDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type != 2 || this.inflateTag(name = parser.getName(), r, parser, attrs)) continue;
            Log.w("drawable", "Unknown element: " + name + " for ShapeDrawable " + this);
        }
        this.updateLocalState(r);
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        ShapeState state = this.mShapeState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.ShapeDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        this.updateLocalState(t.getResources());
    }

    private void updateStateFromTypedArray(TypedArray a) {
        ColorStateList tint;
        ShapeState state = this.mShapeState;
        Paint paint = state.mPaint;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        int color2 = paint.getColor();
        color2 = a.getColor(4, color2);
        paint.setColor(color2);
        boolean dither = paint.isDither();
        dither = a.getBoolean(0, dither);
        paint.setDither(dither);
        this.setIntrinsicWidth((int)a.getDimension(3, state.mIntrinsicWidth));
        this.setIntrinsicHeight((int)a.getDimension(2, state.mIntrinsicHeight));
        int tintMode = a.getInt(5, -1);
        if (tintMode != -1) {
            state.mTintMode = Drawable.parseTintMode(tintMode, PorterDuff.Mode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
    }

    private void updateShape() {
        if (this.mShapeState.mShape != null) {
            Rect r = this.getBounds();
            int w = r.width();
            int h = r.height();
            this.mShapeState.mShape.resize(w, h);
            if (this.mShapeState.mShaderFactory != null) {
                this.mShapeState.mPaint.setShader(this.mShapeState.mShaderFactory.resize(w, h));
            }
        }
        this.invalidateSelf();
    }

    @Override
    public void getOutline(Outline outline) {
        if (this.mShapeState.mShape != null) {
            this.mShapeState.mShape.getOutline(outline);
            outline.setAlpha((float)this.getAlpha() / 255.0f);
        }
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState.mPaint = this.mShapeState.mPaint != null ? new Paint(this.mShapeState.mPaint) : new Paint(1);
            this.mShapeState.mPadding = this.mShapeState.mPadding != null ? new Rect(this.mShapeState.mPadding) : new Rect();
            try {
                this.mShapeState.mShape = this.mShapeState.mShape.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    private ShapeDrawable(ShapeState state, Resources res) {
        this.mShapeState = state;
        this.updateLocalState(res);
    }

    private void updateLocalState(Resources res) {
        this.mTintFilter = this.updateTintFilter(this.mTintFilter, this.mShapeState.mTint, this.mShapeState.mTintMode);
    }

    public static abstract class ShaderFactory {
        public abstract Shader resize(int var1, int var2);
    }

    static class ShapeState
    extends Drawable.ConstantState {
        int[] mThemeAttrs;
        int mChangingConfigurations;
        Paint mPaint;
        Shape mShape;
        ColorStateList mTint = null;
        PorterDuff.Mode mTintMode = Drawable.DEFAULT_TINT_MODE;
        Rect mPadding;
        int mIntrinsicWidth;
        int mIntrinsicHeight;
        int mAlpha = 255;
        ShaderFactory mShaderFactory;

        ShapeState(ShapeState orig) {
            if (orig != null) {
                this.mThemeAttrs = orig.mThemeAttrs;
                this.mPaint = orig.mPaint;
                this.mShape = orig.mShape;
                this.mTint = orig.mTint;
                this.mTintMode = orig.mTintMode;
                this.mPadding = orig.mPadding;
                this.mIntrinsicWidth = orig.mIntrinsicWidth;
                this.mIntrinsicHeight = orig.mIntrinsicHeight;
                this.mAlpha = orig.mAlpha;
                this.mShaderFactory = orig.mShaderFactory;
            } else {
                this.mPaint = new Paint(1);
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mTint != null && this.mTint.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new ShapeDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            return new ShapeDrawable(this, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }
    }
}

