/*
 * Decompiled with CFR 0.152.
 */
package com.android.ninepatch;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;

public class GraphicsUtilities {
    public static BufferedImage loadCompatibleImage(URL uRL) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(uRL);
        return GraphicsUtilities.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage loadCompatibleImage(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        return GraphicsUtilities.toCompatibleImage(bufferedImage);
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2);
    }

    public static BufferedImage toCompatibleImage(BufferedImage bufferedImage) {
        if (GraphicsUtilities.isHeadless()) {
            return bufferedImage;
        }
        if (bufferedImage.getColorModel().equals(GraphicsUtilities.getGraphicsConfiguration().getColorModel())) {
            return bufferedImage;
        }
        BufferedImage bufferedImage2 = GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
        Graphics graphics = bufferedImage2.getGraphics();
        graphics.drawImage(bufferedImage, 0, 0, null);
        graphics.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createCompatibleImage(BufferedImage bufferedImage, int n, int n2) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2, bufferedImage.getTransparency());
    }

    private static GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration();
    }

    private static boolean isHeadless() {
        return GraphicsEnvironment.isHeadless();
    }

    public static BufferedImage createTranslucentCompatibleImage(int n, int n2) {
        return GraphicsUtilities.getGraphicsConfiguration().createCompatibleImage(n, n2, 3);
    }

    public static int[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 0 || n4 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        } else if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("Pixels array must have a length >= w * h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }
}

