/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.ApiTask;
import com.intellij.javaee.openshift.agent.cloud.OS3AgentDeploymentImpl;
import com.intellij.javaee.openshift.agent.cloud.OS3AgentTemplate;
import com.intellij.javaee.openshift.agent.cloud.OS3Context;
import com.intellij.javaee.openshift.agent.cloud.OS3ProjectImpl;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3AgentDeployment;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgentDeploymentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ProjectRequestConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Template;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import com.openshift.internal.restclient.ResourceFactory;
import com.openshift.internal.restclient.model.project.OpenshiftProjectRequest;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.AuthorizationClientFactory;
import com.openshift.restclient.authorization.BasicAuthorizationStrategy;
import com.openshift.restclient.authorization.IAuthorizationClient;
import com.openshift.restclient.authorization.IAuthorizationContext;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import com.openshift.restclient.authorization.TokenAuthorizationStrategy;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.List;

public class OS3CloudAgentImpl
implements OS3CloudAgent {
    private static final String OPENSHIFT_BINARY_LOCATION = "openshift.restclient.oc.location";
    private static final String VERSION = "v1";
    private IClient myClient;
    private IResourceFactory myFactory;
    private LogAgentManager myLogManager = new LogAgentManager();
    private CloudAgentLogger myLogger;
    private CloudAgentErrorHandler myErrorHandler;

    public void connect(final OSCloudAgentConfig config, CloudAgentErrorHandler errorHandler, CloudAgentLogger logger) {
        this.myErrorHandler = errorHandler;
        this.myLogger = logger;
        new ApiTask(this.myErrorHandler){

            protected Object doPerform() throws OpenShiftException {
                String binaryLocation = config.getOSBinaryLocation();
                if (binaryLocation != null) {
                    System.setProperty(OS3CloudAgentImpl.OPENSHIFT_BINARY_LOCATION, binaryLocation);
                }
                OS3CloudAgentImpl.this.myClient = new ClientBuilder(config.getLibraServer()).authorizationStrategy((IAuthorizationStrategy)new BasicAuthorizationStrategy(config.getEmail(), config.getPassword(), "")).sslCertificateCallback((ISSLCertificateCallback)new NoopSSLCertificateCallback()).build();
                IAuthorizationClient authClient = new AuthorizationClientFactory().create(OS3CloudAgentImpl.this.myClient);
                IAuthorizationContext context = authClient.getContext(OS3CloudAgentImpl.this.myClient.getBaseURL().toString());
                OS3CloudAgentImpl.this.myClient.setAuthorizationStrategy((IAuthorizationStrategy)new TokenAuthorizationStrategy(context.getToken()));
                OS3CloudAgentImpl.this.myClient.getOpenShiftAPIVersion();
                OS3CloudAgentImpl.this.myFactory = (IResourceFactory)new ResourceFactory(OS3CloudAgentImpl.this.myClient);
                return null;
            }
        }.perform();
    }

    public OS3Project[] getApplications() {
        return (OS3Project[])new ApiTask<OS3Project[]>(this.myErrorHandler){

            @Override
            protected OS3Project[] doPerform() throws OpenShiftException {
                List projects = OS3CloudAgentImpl.this.myClient.list("Project");
                ArrayList<OS3ProjectImpl> result = new ArrayList<OS3ProjectImpl>();
                for (IProject project : projects) {
                    result.add(new OS3ProjectImpl(project, new OS3AgentContextImpl()));
                }
                return result.toArray(new OS3Project[result.size()]);
            }
        }.perform();
    }

    public void createProject(final OS3ProjectRequestConfig config) {
        new ApiTask(this.myErrorHandler){

            protected Object doPerform() throws OpenShiftException {
                OpenshiftProjectRequest projectRequest = (OpenshiftProjectRequest)OS3CloudAgentImpl.this.myFactory.create(OS3CloudAgentImpl.VERSION, "ProjectRequest");
                projectRequest.setName(config.getName());
                projectRequest.setDescription(config.getDescriptions());
                projectRequest.setDisplayName(config.getDisplayName());
                OS3CloudAgentImpl.this.myClient.create((IResource)projectRequest);
                return null;
            }
        }.perform();
    }

    public OS3AgentDeployment createDeployment(OS3CloudAgentDeploymentConfig config) {
        return new OS3AgentDeploymentImpl(config, new OS3AgentContextImpl());
    }

    public OS3Template[] getServerTemplates() {
        return (OS3Template[])new ApiTask<OS3Template[]>(this.myErrorHandler){

            @Override
            protected OS3Template[] doPerform() throws OpenShiftException {
                List templates = OS3CloudAgentImpl.this.myClient.list("Template");
                return (OS3Template[])templates.stream().map(OS3AgentTemplate::new).toArray(OS3Template[]::new);
            }
        }.perform();
    }

    public void uploadDescriptor(final String descriptor) {
        new ApiTask(this.myErrorHandler){

            protected Object doPerform() throws OpenShiftException {
                IClient client = OS3CloudAgentImpl.this.myClient;
                IResource newResource = client.getResourceFactory().create(descriptor);
                client.update(newResource);
                return null;
            }
        }.perform();
    }

    private class OS3AgentContextImpl
    implements OS3Context {
        private OS3AgentContextImpl() {
        }

        @Override
        public IClient getClient() {
            return OS3CloudAgentImpl.this.myClient;
        }

        @Override
        public CloudAgentErrorHandler getErrorHandler() {
            return OS3CloudAgentImpl.this.myErrorHandler;
        }

        @Override
        public LogAgentManager getLogManager() {
            return OS3CloudAgentImpl.this.myLogManager;
        }

        @Override
        public CloudAgentLogger getLogger() {
            return OS3CloudAgentImpl.this.myLogger;
        }
    }
}

