/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.context.DeploymentModelContext;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.ui.packaging.WebApplicationArtifactType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import org.jdom.Element;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.server.TomcatServerModel;

public class TomcatModuleDeploymentModel
extends TomcatDeploymentModelBase
implements DeploymentModelContext {
    public String CONTEXT_PATH = "/";

    public TomcatModuleDeploymentModel(CommonModel parentConfiguration, DeploymentSource source) {
        super(parentConfiguration, source);
    }

    public boolean isEEArtifact() {
        Artifact artifact = this.getArtifact();
        return artifact != null && !(artifact.getArtifactType() instanceof WebApplicationArtifactType);
    }

    @Override
    public String getContextPath() {
        if (this.isEEArtifact()) {
            return "/" + FileUtil.sanitizeFileName((String)this.getDeploymentSource().getPresentableName());
        }
        return this.getContextRoot();
    }

    public TomcatServerModel getServerModel() {
        return (TomcatServerModel)super.getServerModel();
    }

    public boolean isDefaultContextRoot() {
        return this.isEEArtifact();
    }

    public String getContextRoot() {
        String result = this.CONTEXT_PATH;
        Element contextRoot = TomcatUtil.findContextInContextXmlByFacet(this);
        if (StringUtil.isEmpty((String)result) && contextRoot != null && !this.getServerModel().isTomEE()) {
            result = contextRoot.getAttributeValue("path");
        }
        if (!StringUtil.startsWithChar((CharSequence)result, (char)'/')) {
            result = "/" + result;
        }
        if (result.equals("/")) {
            result = "";
        }
        return result;
    }
}

