/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.appengine.descriptor;

import com.intellij.appengine.facet.AppEngineFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlSchemaProvider;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppEngineWebSchemaProvider
extends XmlSchemaProvider {
    private static final Set<String> FILE_NAMES = new HashSet<String>(Arrays.asList("appengine-web.xml", "appengine-application.xml", "jdoconfig.xml"));

    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            AppEngineWebSchemaProvider.$$$reportNull$$$0(0);
        }
        if (!FILE_NAMES.contains(file.getName())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return AppEngineFacet.getAppEngineFacetByModule(module) != null;
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            AppEngineWebSchemaProvider.$$$reportNull$$$0(1);
        }
        if (baseFile == null) {
            AppEngineWebSchemaProvider.$$$reportNull$$$0(2);
        }
        if (module == null) {
            return null;
        }
        if (url.startsWith("http://appengine.google.com/ns/")) {
            AppEngineFacet facet = AppEngineFacet.getAppEngineFacetByModule(module);
            if (facet != null) {
                PsiFile psiFile;
                File file = AppEngineWebSchemaProvider.isApplicationXmlFile(baseFile) ? facet.getSdk().getApplicationSchemeFile() : facet.getSdk().getWebSchemeFile();
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file);
                if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile)) instanceof XmlFile) {
                    return (XmlFile)psiFile;
                }
            }
        } else if (url.startsWith("http://java.sun.com/xml/ns/jdo/jdoconfig")) {
            PsiPackage jdoPackage = JavaPsiFacade.getInstance((Project)module.getProject()).findPackage("javax.jdo");
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            if (jdoPackage != null) {
                for (PsiDirectory directory : jdoPackage.getDirectories(scope)) {
                    PsiFile file = directory.findFile("jdoconfig_2_3.xsd");
                    if (!(file instanceof XmlFile)) continue;
                    return (XmlFile)file;
                }
            }
        }
        return null;
    }

    private static boolean isApplicationXmlFile(PsiFile baseFile) {
        if (!(baseFile instanceof XmlFile)) {
            return false;
        }
        XmlTag rootTag = ((XmlFile)baseFile).getRootTag();
        return rootTag != null && rootTag.getName().equals("appengine-application");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/appengine/descriptor/AppEngineWebSchemaProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSchema";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

