/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContextImpl;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;

class ChainedTargetsBuildListener
implements BuildListener {
    private final CompileContextImpl myContext;

    public ChainedTargetsBuildListener(CompileContextImpl context) {
        this.myContext = context;
    }

    @Override
    public void filesGenerated(FileGeneratedEvent event) {
        ProjectDescriptor pd = this.myContext.getProjectDescriptor();
        BuildFSState fsState = pd.fsState;
        for (Pair<String, String> pair : event.getPaths()) {
            String relativePath = (String)pair.getSecond();
            File file = relativePath.equals(".") ? new File((String)pair.getFirst()) : new File((String)pair.getFirst(), relativePath);
            for (BuildRootDescriptor desc : pd.getBuildRootIndex().findAllParentDescriptors(file, this.myContext)) {
                if (event.getSourceTarget().equals(desc.getTarget())) continue;
                try {
                    fsState.markDirty(this.myContext, file, desc, pd.timestamps.getStorage(), false);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void filesDeleted(FileDeletedEvent event) {
        BuildFSState state = this.myContext.getProjectDescriptor().fsState;
        BuildRootIndex rootsIndex = this.myContext.getProjectDescriptor().getBuildRootIndex();
        for (String path : event.getFilePaths()) {
            File file = new File(FileUtil.toSystemDependentName((String)path));
            for (BuildRootDescriptor desc : rootsIndex.findAllParentDescriptors(file, this.myContext)) {
                state.registerDeleted(this.myContext, desc.getTarget(), file);
            }
        }
    }
}

