/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.fix;

import com.intellij.history.LocalHistory;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.linter.tslint.TsLintBundle;
import com.intellij.lang.javascript.linter.tslint.config.TsLintConfiguration;
import com.intellij.lang.javascript.linter.tslint.config.TsLintState;
import com.intellij.lang.javascript.linter.tslint.service.TsLintLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ResultWithError;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class TsLintFileFixAction
extends JSLinterFixAction {
    public TsLintFileFixAction() {
        super(TsLintBundle.message("tslint.framework.title", new Object[0]), TsLintBundle.message("tslint.action.fix.all.problem.title", new Object[0]), null);
    }

    @NotNull
    protected JSLinterConfiguration getConfiguration(Project project) {
        TsLintConfiguration tsLintConfiguration = TsLintConfiguration.getInstance(project);
        if (tsLintConfiguration == null) {
            TsLintFileFixAction.$$$reportNull$$$0(0);
        }
        return tsLintConfiguration;
    }

    protected Task createTask(final @NotNull Project project, final @NotNull Collection<VirtualFile> filesToProcess, final @NotNull Runnable completeCallback) {
        if (project == null) {
            TsLintFileFixAction.$$$reportNull$$$0(1);
        }
        if (filesToProcess == null) {
            TsLintFileFixAction.$$$reportNull$$$0(2);
        }
        if (completeCallback == null) {
            TsLintFileFixAction.$$$reportNull$$$0(3);
        }
        LocalHistory.getInstance().putSystemLabel(project, JSBundle.message((String)"javascript.linter.action.fix.problems.name.start", (Object[])new Object[]{TsLintBundle.message("tslint.framework.title", new Object[0])}));
        return new Task.Backgroundable(project, TsLintBundle.message("tslint.action.background.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                TsLintLanguageService service = TsLintLanguageService.getService(project);
                TsLintState state = (TsLintState)TsLintConfiguration.getInstance(project).getExtendedState().getState();
                for (VirtualFile file : filesToProcess) {
                    indicator.setText("Processing file " + file.getCanonicalPath());
                    Future future = (Future)ReadAction.compute(() -> service.highlightAndFix(file, state));
                    ResultWithError result = JSLanguageServiceUtil.awaitLanguageService((Future)future, (LinterLanguageServiceClient)service);
                    if (result.getError() == null) continue;
                    JSLinterGuesser.NOTIFICATION_GROUP.createNotification("TSLint: " + result.getError(), MessageType.ERROR).notify(project);
                }
                completeCallback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction$1", "run"));
            }
        };
    }

    protected Collection<FileType> getFileTypes() {
        return TypeScriptUtil.TYPESCRIPT_FILE_TYPES;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/tslint/fix/TsLintFileFixAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

