/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2meplugin.run.states.midp.nokia;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.DebuggingRunnerData;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.j2meplugin.emulator.Emulator;
import com.intellij.j2meplugin.emulator.midp.nokia.ConfigurationUtil;
import com.intellij.j2meplugin.emulator.midp.nokia.NokiaEmulatorType;
import com.intellij.j2meplugin.run.J2MERunConfiguration;
import com.intellij.j2meplugin.run.J2MERunnableState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.util.PathUtil;
import java.io.File;

public class NokiaRunnableState
extends J2MERunnableState {
    public NokiaRunnableState(RunnerSettings runnerSettings, ConfigurationPerRunnerSettings configurationSetting, J2MERunConfiguration configuration, Project project, Sdk projectJdk) {
        super(runnerSettings, configurationSetting, configuration, project, projectJdk);
    }

    @Override
    protected ProcessHandler getExecutionProcess(String availablePort) throws ExecutionException {
        Emulator emulator = (Emulator)this.myProjectJdk.getSdkAdditionalData();
        JavaParameters javaParameters = new JavaParameters();
        javaParameters.setJdk(emulator.getJavaSdk());
        String key = "kvem.main";
        javaParameters.setMainClass(ConfigurationUtil.getProperties(this.myProjectJdk.getHomePath()).getProperty("kvem.main"));
        javaParameters.getClassPath().add(NokiaEmulatorType.getKvemPath(this.myProjectJdk.getHomeDirectory().getPath()));
        String[] urls = this.myProjectJdk.getRootProvider().getUrls(OrderRootType.CLASSES);
        for (int k = 0; urls != null && k < urls.length; ++k) {
            javaParameters.getClassPath().add(PathUtil.toPresentableUrl((String)urls[k]));
        }
        javaParameters.getVMParametersList().add("-Demulator.home=" + this.myProjectJdk.getHomeDirectory().getPath());
        ParametersList params = javaParameters.getProgramParametersList();
        if (this.myRunnerSettings instanceof DebuggingRunnerData) {
            params.add("-debugger");
            params.add("-dbg_port");
            params.add(availablePort);
        }
        if (!this.myConfiguration.IS_CLASSES) {
            params.add(this.myConfiguration.JAD_NAME);
        } else {
            File tempJad = this.findFilesToDelete(this.myConfiguration.getModule());
            params.add(tempJad.getPath());
        }
        if (this.myConfiguration.COMMAND_LINE_PARAMETERS != null && this.myConfiguration.COMMAND_LINE_PARAMETERS.length() > 0) {
            params.add(this.myConfiguration.COMMAND_LINE_PARAMETERS);
        }
        return new OSProcessHandler(javaParameters.toCommandLine());
    }
}

