/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.chart.editor;

import com.intellij.diagram.DiagramProvider;
import com.intellij.jboss.jbpm.chart.BpmnChartProvider;
import com.intellij.jboss.jbpm.chart.editor.BpmnDesignerComponent;
import com.intellij.jboss.jbpm.chart.model.BpmnChartSource;
import com.intellij.jboss.jbpm.model.ChartSource;
import com.intellij.jboss.jpdl.resources.messages.JpdlBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmnDesignerFileEditor
extends PerspectiveFileEditor {
    private BpmnDesignerComponent bpmnDesignerComponent;
    @NotNull
    private final BpmnChartSource source;

    protected BpmnDesignerFileEditor(Project project, VirtualFile file) {
        super(project, file);
        this.source = new BpmnChartSource(project, file);
        Disposer.register((Disposable)this, (Disposable)this.source);
    }

    @Nullable
    protected DomElement getSelectedDomElement() {
        return null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
    }

    @NotNull
    protected JComponent createCustomComponent() {
        if (this.bpmnDesignerComponent == null) {
            this.bpmnDesignerComponent = this.createDesignerComponent();
            Disposer.register((Disposable)this, (Disposable)this.bpmnDesignerComponent);
        }
        BpmnDesignerComponent bpmnDesignerComponent = this.bpmnDesignerComponent;
        if (bpmnDesignerComponent == null) {
            BpmnDesignerFileEditor.$$$reportNull$$$0(0);
        }
        return bpmnDesignerComponent;
    }

    public void commit() {
    }

    public void reset() {
        this.bpmnDesignerComponent.scheduleUpdate();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        String string = JpdlBundle.message("jpdl.file.editor.designer.name", new Object[0]);
        if (string == null) {
            BpmnDesignerFileEditor.$$$reportNull$$$0(1);
        }
        return string;
    }

    private BpmnDesignerComponent createDesignerComponent() {
        Ref bpmnDesignerComponentRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            AccessToken accessToken = ApplicationManager.getApplication().acquireReadActionLock();
            try {
                BpmnChartProvider bpmnChartProvider = (BpmnChartProvider)((Object)((Object)DiagramProvider.DIAGRAM_PROVIDER.findExtension(BpmnChartProvider.class)));
                BpmnDesignerComponent designerComponent = new BpmnDesignerComponent(this.getProject(), (ChartSource)this.source, bpmnChartProvider);
                designerComponent.refreshDataModel();
                bpmnDesignerComponentRef.set((Object)designerComponent);
            }
            finally {
                accessToken.finish();
            }
        }, JpdlBundle.message("progress.manager.generating.designer.component", new Object[0]), false, this.getProject());
        return (BpmnDesignerComponent)((Object)bpmnDesignerComponentRef.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jboss/jbpm/chart/editor/BpmnDesignerFileEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

