/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

public class CaptureStorage {
    private static final int MAX_STORED_STACKS = 1000;
    private static final Map<WeakReference, CapturedStack> STORAGE;
    private static final Deque<WeakReference> HISTORY;
    private static final ThreadLocal<Deque<InsertMatch>> CURRENT_STACKS;
    private static boolean DEBUG;
    private static boolean ENABLED;
    private static final JavaLangAccess ourJavaLangAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void capture(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Deque<InsertMatch> currentStacks;
            Throwable exception = new Throwable();
            if (DEBUG) {
                System.out.println("capture " + CaptureStorage.getCallerDescriptor(exception) + " - " + key);
            }
            CapturedStack stack = CaptureStorage.createCapturedStack(exception, (currentStacks = CURRENT_STACKS.get()).isEmpty() ? null : currentStacks.getLast());
            WeakKey keyRef = new WeakKey(key);
            Deque<WeakReference> deque = HISTORY;
            synchronized (deque) {
                CapturedStack old = STORAGE.put(keyRef, stack);
                if (old == null) {
                    if (HISTORY.size() >= 1000) {
                        STORAGE.remove(HISTORY.removeFirst());
                    }
                } else {
                    HISTORY.removeFirstOccurrence(keyRef);
                }
                HISTORY.addLast(keyRef);
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertEnter(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            CapturedStack stack = STORAGE.get(new WeakKey(key));
            Deque<InsertMatch> currentStacks = CURRENT_STACKS.get();
            if (stack != null) {
                Throwable exception = new Throwable();
                currentStacks.add(new InsertMatch(stack, CaptureStorage.getStackTraceDepth(exception)));
                if (DEBUG) {
                    System.out.println("insert " + CaptureStorage.getCallerDescriptor(exception) + " -> " + key + ", stack saved (" + currentStacks.size() + ")");
                }
            } else {
                currentStacks.add(InsertMatch.EMPTY);
                if (DEBUG) {
                    System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " -> " + key + ", no stack found (" + currentStacks.size() + ")");
                }
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    public static void insertExit(Object key) {
        if (!ENABLED) {
            return;
        }
        try {
            Deque<InsertMatch> currentStacks = CURRENT_STACKS.get();
            currentStacks.removeLast();
            if (DEBUG) {
                System.out.println("insert " + CaptureStorage.getCallerDescriptor(new Throwable()) + " <- " + key + ", stack removed (" + currentStacks.size() + ")");
            }
        }
        catch (Exception e) {
            CaptureStorage.handleException(e);
        }
    }

    private static CapturedStack createCapturedStack(Throwable exception, InsertMatch insertMatch) {
        if (insertMatch != null && insertMatch != InsertMatch.EMPTY) {
            return new DeepCapturedStack(exception, insertMatch);
        }
        return new CapturedStack(exception);
    }

    public static Object[][] getRelatedStack(Object key) {
        CapturedStack stack = STORAGE.get(new WeakKey(key));
        if (stack == null) {
            return null;
        }
        List<StackTraceElement> stackTrace = stack.getStackTrace();
        Object[][] res = new Object[stackTrace.size()][];
        for (int i = 0; i < stackTrace.size(); ++i) {
            StackTraceElement elem = stackTrace.get(i);
            res[i] = elem == null ? null : new Object[]{elem.getClassName(), elem.getFileName(), elem.getMethodName(), String.valueOf(elem.getLineNumber())};
        }
        return res;
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    private static int getStackTraceDepth(Throwable exception) {
        return ourJavaLangAccess != null ? ourJavaLangAccess.getStackTraceDepth(exception) : exception.getStackTrace().length;
    }

    private static void handleException(Throwable e) {
        ENABLED = false;
        System.err.println("Critical error in IDEA Async Stacktraces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
        e.printStackTrace();
    }

    private static String getCallerDescriptor(Throwable e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        StackTraceElement caller = stackTrace[stackTrace.length - 2];
        return caller.getClassName() + "." + caller.getMethodName();
    }

    static {
        JavaLangAccess access;
        STORAGE = new ConcurrentHashMap<WeakReference, CapturedStack>();
        HISTORY = new ArrayDeque<WeakReference>(1000);
        CURRENT_STACKS = new ThreadLocal<Deque<InsertMatch>>(){

            @Override
            protected Deque<InsertMatch> initialValue() {
                return new LinkedList<InsertMatch>();
            }
        };
        DEBUG = false;
        ENABLED = true;
        try {
            access = SharedSecrets.getJavaLangAccess();
            if (access != null) {
                access.getStackTraceDepth(new Throwable());
            }
        }
        catch (Throwable e) {
            access = null;
        }
        ourJavaLangAccess = access;
    }

    private static class InsertMatch {
        private final CapturedStack myStack;
        private final int myDepth;
        static final InsertMatch EMPTY = new InsertMatch(null, 0);

        private InsertMatch(CapturedStack stack, int depth) {
            this.myStack = stack;
            this.myDepth = depth;
        }
    }

    private static class DeepCapturedStack
    extends CapturedStack {
        final InsertMatch myInsertMatch;

        public DeepCapturedStack(Throwable exception, InsertMatch insertMatch) {
            super(exception);
            this.myInsertMatch = insertMatch;
        }

        @Override
        List<StackTraceElement> getStackTrace() {
            StackTraceElement[] stackTrace = this.myException.getStackTrace();
            if (this.myInsertMatch == null || this.myInsertMatch == InsertMatch.EMPTY) {
                return super.getStackTrace();
            }
            List<StackTraceElement> insertStack = this.myInsertMatch.myStack.getStackTrace();
            int insertPos = stackTrace.length - this.myInsertMatch.myDepth + 2;
            ArrayList<StackTraceElement> res = new ArrayList<StackTraceElement>(insertPos + insertStack.size() + 1);
            res.addAll(Arrays.asList(stackTrace).subList(1, insertPos));
            res.add(null);
            res.addAll(insertStack);
            return res;
        }
    }

    private static class CapturedStack {
        final Throwable myException;

        private CapturedStack(Throwable exception) {
            this.myException = exception;
        }

        List<StackTraceElement> getStackTrace() {
            StackTraceElement[] stackTrace = this.myException.getStackTrace();
            return Arrays.asList(stackTrace).subList(1, stackTrace.length);
        }
    }

    private static class WeakKey
    extends WeakReference {
        private final int myHashCode;

        public WeakKey(Object referent) {
            super(referent);
            this.myHashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object o) {
            return this == o || o instanceof WeakKey && ((WeakKey)o).get() == this.get();
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }
}

